/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.LithoView;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.FromMeasure;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.HorizontalScrollEventsController;
import com.facebook.litho.widget.ScrollStateDetector;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.yoga.YogaDirection;
import java.util.List;

@MountSpec
class HorizontalScrollSpec {
    private static final int LAST_SCROLL_POSITION_UNSET = -1;
    @PropDefault
    static final boolean scrollbarEnabled = true;
    @PropDefault
    static final int initialScrollPosition = -1;

    HorizontalScrollSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<Boolean> scrollbarEnabled) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.HorizontalScroll, 0);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.HorizontalScroll_android_scrollbars) continue;
            scrollbarEnabled.set((Object)(a.getInt(attr2, 0) != 0 ? 1 : 0));
        }
        a.recycle();
    }

    @OnMeasure
    static void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, @Prop Component contentProps, @State ComponentTree childComponentTree, Output<Integer> measuredComponentWidth, Output<Integer> measuredComponentHeight) {
        Size contentSize = new Size();
        childComponentTree.setRootAndSizeSpec(contentProps, SizeSpec.makeSizeSpec((int)0, (int)0), heightSpec, contentSize);
        int measuredWidth = contentSize.width;
        int measuredHeight = contentSize.height;
        measuredComponentWidth.set((Object)measuredWidth);
        measuredComponentHeight.set((Object)measuredHeight);
        size.width = SizeSpec.getMode((int)widthSpec) == 0 ? measuredWidth : SizeSpec.getSize((int)widthSpec);
        size.height = measuredHeight;
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext context, ComponentLayout layout, @Prop Component contentProps, @Prop(optional=true) boolean fillViewport, @State ComponentTree childComponentTree, @FromMeasure Integer measuredComponentWidth, @FromMeasure Integer measuredComponentHeight, Output<Integer> componentWidth, Output<Integer> componentHeight, Output<YogaDirection> layoutDirection) {
        int layoutWidth = layout.getWidth() - layout.getPaddingLeft() - layout.getPaddingRight();
        if (measuredComponentWidth != null && measuredComponentHeight != null) {
            componentWidth.set((Object)Math.max(measuredComponentWidth, fillViewport ? layoutWidth : 0));
            componentHeight.set((Object)measuredComponentHeight);
        } else {
            Size contentSize = new Size();
            childComponentTree.setRootAndSizeSpec(contentProps, SizeSpec.makeSizeSpec((int)0, (int)0), SizeSpec.makeSizeSpec((int)layout.getHeight(), (int)0x40000000), contentSize);
            int measuredWidth = Math.max(contentSize.width, fillViewport ? layoutWidth : 0);
            int measuredHeight = contentSize.height;
            componentWidth.set((Object)measuredWidth);
            componentHeight.set((Object)measuredHeight);
        }
        layoutDirection.set((Object)layout.getResolvedLayoutDirection());
    }

    @OnCreateMountContent
    static HorizontalScrollLithoView onCreateMountContent(Context c) {
        return new HorizontalScrollLithoView(c);
    }

    @OnMount
    static void onMount(ComponentContext context, final HorizontalScrollLithoView horizontalScrollLithoView, @Prop(optional=true, resType=ResType.BOOL) boolean scrollbarEnabled, @Prop(optional=true) @Nullable HorizontalScrollEventsController eventsController, @Prop(optional=true) @Nullable OnScrollChangeListener onScrollChangeListener, @Prop(optional=true) @Nullable ScrollStateListener scrollStateListener, final @State ScrollPosition lastScrollPosition, @State ComponentTree childComponentTree, int componentWidth, int componentHeight, final YogaDirection layoutDirection) {
        horizontalScrollLithoView.setHorizontalScrollBarEnabled(scrollbarEnabled);
        horizontalScrollLithoView.mount(childComponentTree, lastScrollPosition, onScrollChangeListener, scrollStateListener, componentWidth, componentHeight);
        ViewTreeObserver viewTreeObserver = horizontalScrollLithoView.getViewTreeObserver();
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                horizontalScrollLithoView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                if (lastScrollPosition.x == -1) {
                    if (layoutDirection == YogaDirection.RTL) {
                        horizontalScrollLithoView.fullScroll(66);
                    }
                    lastScrollPosition.x = horizontalScrollLithoView.getScrollX();
                } else {
                    horizontalScrollLithoView.setScrollX(lastScrollPosition.x);
                }
                return true;
            }
        });
        if (eventsController != null) {
            eventsController.setScrollableView(horizontalScrollLithoView);
        }
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, HorizontalScrollLithoView mountedView, @Prop(optional=true) @Nullable HorizontalScrollEventsController eventsController) {
        mountedView.unmount();
        if (eventsController != null) {
            eventsController.setScrollableView(null);
        }
    }

    @OnCreateInitialState
    static void onCreateInitialState(ComponentContext c, StateValue<ScrollPosition> lastScrollPosition, StateValue<ComponentTree> childComponentTree, @Prop Component contentProps, @Prop(optional=true) int initialScrollPosition) {
        lastScrollPosition.set((Object)new ScrollPosition(initialScrollPosition));
        childComponentTree.set((Object)ComponentTree.create((ComponentContext)ComponentContext.makeCopyForNestedTree((ComponentContext)c), (Component)contentProps).incrementalMount(false).build());
    }

    static class ScrollPosition {
        int x;

        ScrollPosition(int initialX) {
            this.x = initialX;
        }
    }

    static class HorizontalScrollLithoView
    extends HorizontalScrollView
    implements HasLithoViewChildren {
        private final LithoView mLithoView;
        private int mComponentWidth;
        private int mComponentHeight;
        @Nullable
        private ScrollPosition mScrollPosition;
        @Nullable
        private OnScrollChangeListener mOnScrollChangeListener;
        @Nullable
        private ScrollStateDetector mScrollStateDetector;

        public HorizontalScrollLithoView(Context context) {
            super(context);
            this.mLithoView = new LithoView(context);
            this.addView((View)this.mLithoView);
        }

        public void fling(int velocityX) {
            super.fling(velocityX);
            if (this.mScrollStateDetector != null) {
                this.mScrollStateDetector.fling();
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.mScrollStateDetector != null) {
                this.mScrollStateDetector.onDraw();
            }
        }

        protected void onScrollChanged(int l, int t, int oldl, int oldt) {
            super.onScrollChanged(l, t, oldl, oldt);
            if (this.mScrollPosition != null) {
                if (this.mOnScrollChangeListener != null) {
                    this.mOnScrollChangeListener.onScrollChange((View)this, this.getScrollX(), this.mScrollPosition.x);
                }
                this.mScrollPosition.x = this.getScrollX();
            }
            if (this.mScrollStateDetector != null) {
                this.mScrollStateDetector.onScrollChanged();
            }
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean isConsumed = super.onTouchEvent(motionEvent);
            if (this.mScrollStateDetector != null) {
                this.mScrollStateDetector.onTouchEvent(motionEvent);
            }
            return isConsumed;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.mLithoView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mComponentWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mComponentHeight, (int)0x40000000));
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        }

        public void obtainLithoViewChildren(List<LithoView> lithoViews) {
            lithoViews.add(this.mLithoView);
        }

        void mount(ComponentTree componentTree, ScrollPosition scrollPosition, @Nullable OnScrollChangeListener onScrollChangeListener, ScrollStateListener scrollStateListener, int width, int height) {
            this.mLithoView.setComponentTree(componentTree);
            this.mScrollPosition = scrollPosition;
            this.mOnScrollChangeListener = onScrollChangeListener;
            this.mComponentWidth = width;
            this.mComponentHeight = height;
            if (scrollStateListener != null) {
                if (this.mScrollStateDetector == null) {
                    this.mScrollStateDetector = new ScrollStateDetector((View)this);
                }
                this.mScrollStateDetector.setListener(scrollStateListener);
            }
        }

        void unmount() {
            this.mLithoView.unbind();
            this.mLithoView.setComponentTree(null);
            this.mComponentWidth = 0;
            this.mComponentHeight = 0;
            this.mScrollPosition = null;
            this.mOnScrollChangeListener = null;
            this.setScrollX(0);
            if (this.mScrollStateDetector != null) {
                this.mScrollStateDetector.setListener(null);
            }
        }
    }

    public static interface OnScrollChangeListener {
        public void onScrollChange(View var1, int var2, int var3);
    }
}

