/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.HorizontalScrollEventsController;
import com.facebook.litho.widget.HorizontalScrollSpec;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.yoga.YogaDirection;
import java.util.BitSet;

public final class HorizontalScroll
extends Component {
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=10)
    Component contentProps;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    HorizontalScrollEventsController eventsController;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean fillViewport;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int initialScrollPosition = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    HorizontalScrollSpec.OnScrollChangeListener onScrollChangeListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    ScrollStateListener scrollStateListener;
    @Prop(resType=ResType.BOOL, optional=true)
    @Comparable(type=3)
    boolean scrollbarEnabled = true;

    private HorizontalScroll() {
        super("HorizontalScroll");
    }

    private HorizontalScrollStateContainer getStateContainerImpl(ComponentContext c) {
        return (HorizontalScrollStateContainer)super.getStateContainer(c);
    }

    protected HorizontalScrollStateContainer createStateContainer() {
        return new HorizontalScrollStateContainer();
    }

    protected HorizontalScrollInterStagePropsContainer createInterStagePropsContainer() {
        return new HorizontalScrollInterStagePropsContainer();
    }

    private HorizontalScrollInterStagePropsContainer getInterStagePropsContainerImpl(ComponentContext c) {
        return (HorizontalScrollInterStagePropsContainer)super.getInterStagePropsContainer(c);
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        HorizontalScroll horizontalScrollRef = (HorizontalScroll)other;
        if (this.contentProps != null ? !this.contentProps.isEquivalentTo(horizontalScrollRef.contentProps) : horizontalScrollRef.contentProps != null) {
            return false;
        }
        if (this.eventsController != null ? !this.eventsController.equals(horizontalScrollRef.eventsController) : horizontalScrollRef.eventsController != null) {
            return false;
        }
        if (this.fillViewport != horizontalScrollRef.fillViewport) {
            return false;
        }
        if (this.initialScrollPosition != horizontalScrollRef.initialScrollPosition) {
            return false;
        }
        if (this.onScrollChangeListener != null ? !this.onScrollChangeListener.equals(horizontalScrollRef.onScrollChangeListener) : horizontalScrollRef.onScrollChangeListener != null) {
            return false;
        }
        if (this.scrollStateListener != null ? !this.scrollStateListener.equals(horizontalScrollRef.scrollStateListener) : horizontalScrollRef.scrollStateListener != null) {
            return false;
        }
        return this.scrollbarEnabled == horizontalScrollRef.scrollbarEnabled;
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
        HorizontalScrollInterStagePropsContainer copyIntoInterStagePropsContainer_ref = (HorizontalScrollInterStagePropsContainer)copyIntoInterStagePropsContainer;
        HorizontalScrollInterStagePropsContainer copyFromInterStagePropsContainer_ref = (HorizontalScrollInterStagePropsContainer)copyFromInterStagePropsContainer;
        copyIntoInterStagePropsContainer_ref.componentHeight = copyFromInterStagePropsContainer_ref.componentHeight;
        copyIntoInterStagePropsContainer_ref.componentWidth = copyFromInterStagePropsContainer_ref.componentWidth;
        copyIntoInterStagePropsContainer_ref.layoutDirection = copyFromInterStagePropsContainer_ref.layoutDirection;
        copyIntoInterStagePropsContainer_ref.measuredComponentHeight = copyFromInterStagePropsContainer_ref.measuredComponentHeight;
        copyIntoInterStagePropsContainer_ref.measuredComponentWidth = copyFromInterStagePropsContainer_ref.measuredComponentWidth;
    }

    public HorizontalScroll makeShallowCopy() {
        HorizontalScroll component = (HorizontalScroll)super.makeShallowCopy();
        component.contentProps = component.contentProps != null ? component.contentProps.makeShallowCopy() : null;
        component.setStateContainer(new HorizontalScrollStateContainer());
        component.setInterStagePropsContainer(this.createInterStagePropsContainer());
        return component;
    }

    protected void onLoadStyle(ComponentContext c) {
        Output scrollbarEnabledTmp = new Output();
        HorizontalScrollSpec.onLoadStyle(c, (Output<Boolean>)scrollbarEnabledTmp);
        if (scrollbarEnabledTmp.get() != null) {
            this.scrollbarEnabled = (Boolean)scrollbarEnabledTmp.get();
        }
    }

    protected void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size) {
        Output measuredComponentWidthTmp = new Output();
        Output measuredComponentHeightTmp = new Output();
        HorizontalScrollSpec.onMeasure(context, layout, widthSpec, heightSpec, size, this.contentProps, this.getStateContainerImpl((ComponentContext)context).childComponentTree, (Output<Integer>)measuredComponentWidthTmp, (Output<Integer>)measuredComponentHeightTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)context).measuredComponentWidth = (Integer)measuredComponentWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context).measuredComponentHeight = (Integer)measuredComponentHeightTmp.get();
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext context, ComponentLayout layout) {
        Output componentWidthTmp = new Output();
        Output componentHeightTmp = new Output();
        Output layoutDirectionTmp = new Output();
        HorizontalScrollSpec.onBoundsDefined(context, layout, this.contentProps, this.fillViewport, this.getStateContainerImpl((ComponentContext)context).childComponentTree, this.getInterStagePropsContainerImpl((ComponentContext)context).measuredComponentWidth, this.getInterStagePropsContainerImpl((ComponentContext)context).measuredComponentHeight, (Output<Integer>)componentWidthTmp, (Output<Integer>)componentHeightTmp, (Output<YogaDirection>)layoutDirectionTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)context).componentWidth = (Integer)componentWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context).componentHeight = (Integer)componentHeightTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context).layoutDirection = (YogaDirection)layoutDirectionTmp.get();
    }

    protected Object onCreateMountContent(Context c) {
        HorizontalScrollSpec.HorizontalScrollLithoView _result = HorizontalScrollSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext context, Object horizontalScrollLithoView) {
        HorizontalScrollSpec.onMount(context, (HorizontalScrollSpec.HorizontalScrollLithoView)((Object)horizontalScrollLithoView), this.scrollbarEnabled, this.eventsController, this.onScrollChangeListener, this.scrollStateListener, this.getStateContainerImpl((ComponentContext)context).lastScrollPosition, this.getStateContainerImpl((ComponentContext)context).childComponentTree, this.getInterStagePropsContainerImpl((ComponentContext)context).componentWidth, this.getInterStagePropsContainerImpl((ComponentContext)context).componentHeight, this.getInterStagePropsContainerImpl((ComponentContext)context).layoutDirection);
    }

    protected void onUnmount(ComponentContext context, Object mountedView) {
        HorizontalScrollSpec.onUnmount(context, (HorizontalScrollSpec.HorizontalScrollLithoView)((Object)mountedView), this.eventsController);
    }

    protected void createInitialState(ComponentContext c) {
        StateValue lastScrollPosition = new StateValue();
        StateValue childComponentTree = new StateValue();
        HorizontalScrollSpec.onCreateInitialState(c, (StateValue<HorizontalScrollSpec.ScrollPosition>)lastScrollPosition, (StateValue<ComponentTree>)childComponentTree, this.contentProps, this.initialScrollPosition);
        this.getStateContainerImpl((ComponentContext)c).lastScrollPosition = (HorizontalScrollSpec.ScrollPosition)lastScrollPosition.get();
        this.getStateContainerImpl((ComponentContext)c).childComponentTree = (ComponentTree)childComponentTree.get();
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(StateContainer _prevStateContainer, StateContainer _nextStateContainer) {
        HorizontalScrollStateContainer prevStateContainer = (HorizontalScrollStateContainer)_prevStateContainer;
        HorizontalScrollStateContainer nextStateContainer = (HorizontalScrollStateContainer)_nextStateContainer;
        nextStateContainer.childComponentTree = prevStateContainer.childComponentTree;
        nextStateContainer.lastScrollPosition = prevStateContainer.lastScrollPosition;
    }

    public static Builder create(ComponentContext context) {
        return HorizontalScroll.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        HorizontalScroll instance = new HorizontalScroll();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        HorizontalScroll mHorizontalScroll;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"contentProps"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, HorizontalScroll horizontalScrollRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)horizontalScrollRef);
            this.mHorizontalScroll = horizontalScrollRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mHorizontalScroll = (HorizontalScroll)component;
        }

        @PropSetter(value="contentProps", required=true)
        @RequiredProp(value="contentProps")
        public Builder contentProps(Component contentProps) {
            this.mHorizontalScroll.contentProps = contentProps == null ? null : contentProps.makeShallowCopy();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="contentProps", required=true)
        @RequiredProp(value="contentProps")
        public Builder contentProps(Component.Builder<?> contentPropsBuilder) {
            this.mHorizontalScroll.contentProps = contentPropsBuilder == null ? null : contentPropsBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="eventsController", required=false)
        public Builder eventsController(@Nullable HorizontalScrollEventsController eventsController) {
            this.mHorizontalScroll.eventsController = eventsController;
            return this;
        }

        @PropSetter(value="fillViewport", required=false)
        public Builder fillViewport(boolean fillViewport) {
            this.mHorizontalScroll.fillViewport = fillViewport;
            return this;
        }

        @PropSetter(value="initialScrollPosition", required=false)
        public Builder initialScrollPosition(int initialScrollPosition) {
            this.mHorizontalScroll.initialScrollPosition = initialScrollPosition;
            return this;
        }

        @PropSetter(value="onScrollChangeListener", required=false)
        public Builder onScrollChangeListener(@Nullable HorizontalScrollSpec.OnScrollChangeListener onScrollChangeListener) {
            this.mHorizontalScroll.onScrollChangeListener = onScrollChangeListener;
            return this;
        }

        @PropSetter(value="scrollStateListener", required=false)
        public Builder scrollStateListener(@Nullable ScrollStateListener scrollStateListener) {
            this.mHorizontalScroll.scrollStateListener = scrollStateListener;
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabled(boolean scrollbarEnabled) {
            this.mHorizontalScroll.scrollbarEnabled = scrollbarEnabled;
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabledRes(@BoolRes int resId) {
            this.mHorizontalScroll.scrollbarEnabled = this.mResourceResolver.resolveBoolRes(resId);
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabledAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mHorizontalScroll.scrollbarEnabled = this.mResourceResolver.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabledAttr(@AttrRes int attrResId) {
            this.mHorizontalScroll.scrollbarEnabled = this.mResourceResolver.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public HorizontalScroll build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mHorizontalScroll;
        }
    }

    @VisibleForTesting(otherwise=2)
    static class HorizontalScrollStateContainer
    extends StateContainer {
        @State
        @Comparable(type=13)
        ComponentTree childComponentTree;
        @State
        @Comparable(type=13)
        HorizontalScrollSpec.ScrollPosition lastScrollPosition;

        HorizontalScrollStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            int cfr_ignored_0 = stateUpdate.type;
        }
    }

    static class HorizontalScrollInterStagePropsContainer
    implements InterStagePropsContainer {
        Integer componentHeight;
        Integer componentWidth;
        YogaDirection layoutDirection;
        Integer measuredComponentHeight;
        Integer measuredComponentWidth;

        HorizontalScrollInterStagePropsContainer() {
        }
    }
}

