/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.LithoView;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.LayoutInfoUtils;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RenderInfo;
import java.util.List;

public class GridLayoutInfo
implements LayoutInfo {
    public static final String OVERRIDE_SIZE = "OVERRIDE_SIZE";
    private final GridLayoutManager mGridLayoutManager;
    private final GridSpanSizeLookup mGridSpanSizeLookup;
    private LayoutInfo.RenderInfoCollection mRenderInfoCollection;

    public GridLayoutInfo(GridLayoutManager gridLayoutManager) {
        this.mGridLayoutManager = gridLayoutManager;
        this.mGridSpanSizeLookup = new GridSpanSizeLookup();
        this.mGridLayoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.mGridSpanSizeLookup);
    }

    public GridLayoutInfo(Context context, int spanCount, int orientation, boolean reverseLayout, boolean allowGridMeasuresOverride) {
        this((GridLayoutManager)(allowGridMeasuresOverride ? new GridLayoutManager(context, spanCount, orientation, reverseLayout) : new LithoGridLayoutManager(context, spanCount, orientation, reverseLayout)));
    }

    public GridLayoutInfo(Context context, int spanCount, int orientation, boolean reverseLayout) {
        this(context, spanCount, orientation, reverseLayout, false);
    }

    public GridLayoutInfo(Context context, int spanCount) {
        this(context, spanCount, 1, false);
    }

    @Override
    public int getScrollDirection() {
        return this.mGridLayoutManager.getOrientation();
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mGridLayoutManager.findFirstVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mGridLayoutManager.findLastVisibleItemPosition();
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return this.mGridLayoutManager.findFirstCompletelyVisibleItemPosition();
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return this.mGridLayoutManager.findLastCompletelyVisibleItemPosition();
    }

    @Override
    public int getItemCount() {
        return this.mGridLayoutManager.getItemCount();
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mGridLayoutManager;
    }

    @Override
    public void setRenderInfoCollection(LayoutInfo.RenderInfoCollection renderInfoCollection) {
        this.mRenderInfoCollection = renderInfoCollection;
    }

    @Override
    public void scrollToPositionWithOffset(int position, int offset) {
        this.mGridLayoutManager.scrollToPositionWithOffset(position, offset);
    }

    @Override
    public int approximateRangeSize(int firstMeasuredItemWidth, int firstMeasuredItemHeight, int recyclerMeasuredWidth, int recyclerMeasuredHeight) {
        int spanCount = this.mGridLayoutManager.getSpanCount();
        switch (this.mGridLayoutManager.getOrientation()) {
            case 0: {
                int colCount = (int)Math.ceil((double)recyclerMeasuredWidth / (double)firstMeasuredItemWidth);
                return colCount * spanCount;
            }
        }
        int rowCount = (int)Math.ceil((double)recyclerMeasuredHeight / (double)firstMeasuredItemHeight);
        return rowCount * spanCount;
    }

    @Override
    public int getChildWidthSpec(int widthSpec, RenderInfo renderInfo) {
        switch (this.mGridLayoutManager.getOrientation()) {
            case 0: {
                return SizeSpec.makeSizeSpec((int)0, (int)0);
            }
        }
        Integer overrideWidth = (Integer)renderInfo.getCustomAttribute(OVERRIDE_SIZE);
        if (overrideWidth != null) {
            return SizeSpec.makeSizeSpec((int)overrideWidth, (int)0x40000000);
        }
        if (renderInfo.isFullSpan()) {
            return SizeSpec.makeSizeSpec((int)SizeSpec.getSize((int)widthSpec), (int)0x40000000);
        }
        int spanCount = this.mGridLayoutManager.getSpanCount();
        int spanSize = renderInfo.getSpanSize();
        return SizeSpec.makeSizeSpec((int)(spanSize * (SizeSpec.getSize((int)widthSpec) / spanCount)), (int)0x40000000);
    }

    @Override
    public int getChildHeightSpec(int heightSpec, RenderInfo renderInfo) {
        switch (this.mGridLayoutManager.getOrientation()) {
            case 0: {
                Integer overrideHeight = (Integer)renderInfo.getCustomAttribute(OVERRIDE_SIZE);
                if (overrideHeight != null) {
                    return SizeSpec.makeSizeSpec((int)overrideHeight, (int)0x40000000);
                }
                if (renderInfo.isFullSpan()) {
                    return SizeSpec.makeSizeSpec((int)SizeSpec.getSize((int)heightSpec), (int)0x40000000);
                }
                int spanCount = this.mGridLayoutManager.getSpanCount();
                int spanSize = renderInfo.getSpanSize();
                return SizeSpec.makeSizeSpec((int)(spanSize * (SizeSpec.getSize((int)heightSpec) / spanCount)), (int)0x40000000);
            }
        }
        return SizeSpec.makeSizeSpec((int)0, (int)0);
    }

    @Override
    public ViewportFiller createViewportFiller(int measuredWidth, int measuredHeight) {
        return new ViewportFiller(measuredWidth, measuredHeight, this.getScrollDirection(), this.mGridLayoutManager.getSpanCount());
    }

    @Override
    public int computeWrappedHeight(int maxHeight, List<ComponentTreeHolder> componentTreeHolders) {
        int itemCount = componentTreeHolders.size();
        int spanCount = this.mGridLayoutManager.getSpanCount();
        int measuredHeight = 0;
        switch (this.mGridLayoutManager.getOrientation()) {
            case 1: {
                for (int i = 0; i < itemCount; i += spanCount) {
                    ComponentTreeHolder holder = componentTreeHolders.get(i);
                    int firstRowItemHeight = holder.getMeasuredHeight();
                    measuredHeight += firstRowItemHeight;
                    measuredHeight += LayoutInfoUtils.getTopDecorationHeight((RecyclerView.LayoutManager)this.mGridLayoutManager, i);
                    if ((measuredHeight += LayoutInfoUtils.getBottomDecorationHeight((RecyclerView.LayoutManager)this.mGridLayoutManager, i)) <= maxHeight) continue;
                    measuredHeight = maxHeight;
                    break;
                }
                return measuredHeight;
            }
        }
        throw new IllegalStateException("This method should only be called when orientation is vertical");
    }

    static class ViewportFiller
    implements LayoutInfo.ViewportFiller {
        private final int mWidth;
        private final int mHeight;
        private final int mOrientation;
        private final int mSpanCount;
        private int mFill;
        private int mIndexOfSpan;

        public ViewportFiller(int width, int height, int orientation, int spanCount) {
            this.mWidth = width;
            this.mHeight = height;
            this.mOrientation = orientation;
            this.mSpanCount = spanCount;
        }

        @Override
        public boolean wantsMore() {
            int target = this.mOrientation == 1 ? this.mHeight : this.mWidth;
            return this.mFill < target;
        }

        @Override
        public void add(RenderInfo renderInfo, int width, int height) {
            if (this.mIndexOfSpan == 0) {
                this.mFill += this.mOrientation == 1 ? height : width;
            }
            if (renderInfo.isFullSpan()) {
                this.mIndexOfSpan = 0;
            } else {
                this.mIndexOfSpan += renderInfo.getSpanSize();
                if (this.mIndexOfSpan == this.mSpanCount) {
                    this.mIndexOfSpan = 0;
                }
            }
        }

        @Override
        public int getFill() {
            return this.mFill;
        }
    }

    private static class LithoGridLayoutManager
    extends GridLayoutManager {
        public LithoGridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout) {
            super(context, spanCount, orientation, reverseLayout);
        }

        public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
            if (lp instanceof RecyclerBinder.RecyclerViewLayoutManagerOverrideParams) {
                return new LayoutParams((RecyclerBinder.RecyclerViewLayoutManagerOverrideParams)lp);
            }
            return super.generateLayoutParams(lp);
        }

        public static class LayoutParams
        extends GridLayoutManager.LayoutParams
        implements LithoView.LayoutManagerOverrideParams {
            private final int mOverrideWidthMeasureSpec;
            private final int mOverrideHeightMeasureSpec;

            public LayoutParams(RecyclerBinder.RecyclerViewLayoutManagerOverrideParams source) {
                super((RecyclerView.LayoutParams)source);
                this.mOverrideWidthMeasureSpec = source.getWidthMeasureSpec();
                this.mOverrideHeightMeasureSpec = source.getHeightMeasureSpec();
            }

            public int getWidthMeasureSpec() {
                return this.mOverrideWidthMeasureSpec;
            }

            public int getHeightMeasureSpec() {
                return this.mOverrideHeightMeasureSpec;
            }

            public boolean hasValidAdapterPosition() {
                return false;
            }
        }
    }

    private class GridSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private GridSpanSizeLookup() {
        }

        public int getSpanSize(int position) {
            if (GridLayoutInfo.this.mRenderInfoCollection == null) {
                return 1;
            }
            RenderInfo renderInfo = GridLayoutInfo.this.mRenderInfoCollection.getRenderInfoAt(position);
            if (renderInfo.isFullSpan()) {
                return GridLayoutInfo.this.mGridLayoutManager.getSpanCount();
            }
            return renderInfo.getSpanSize();
        }
    }
}

