/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.StateValue;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.annotations.FromTrigger;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnTrigger;
import com.facebook.litho.annotations.OnUnbind;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.OnUpdateState;
import com.facebook.litho.annotations.Param;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.utils.MeasureUtils;
import com.facebook.litho.widget.ClearFocusEvent;
import com.facebook.litho.widget.EditText;
import com.facebook.litho.widget.EditTextStateUpdatePolicy;
import com.facebook.litho.widget.KeyUpEvent;
import com.facebook.litho.widget.RequestFocusEvent;
import com.facebook.litho.widget.SelectionChangedEvent;
import com.facebook.litho.widget.SetTextEvent;
import com.facebook.litho.widget.TextChangedEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@MountSpec(isPureRender=true, events={TextChangedEvent.class, SelectionChangedEvent.class, KeyUpEvent.class, SetTextEvent.class})
@Deprecated
class EditTextSpec {
    private static final Layout.Alignment[] ALIGNMENT = Layout.Alignment.values();
    private static final TextUtils.TruncateAt[] TRUNCATE_AT = TextUtils.TruncateAt.values();
    private static final Typeface DEFAULT_TYPEFACE = Typeface.DEFAULT;
    private static final int DEFAULT_COLOR = 0;
    private static final int[][] DEFAULT_TEXT_COLOR_STATE_LIST_STATES = new int[][]{{0}};
    private static final int[] DEFAULT_TEXT_COLOR_STATE_LIST_COLORS = new int[]{-16777216};
    private static final int DEFAULT_HINT_COLOR = 0;
    private static final int[][] DEFAULT_HINT_COLOR_STATE_LIST_STATES = new int[][]{{0}};
    private static final int[] DEFAULT_HINT_COLOR_STATE_LIST_COLORS = new int[]{-3355444};
    private static final int DEFAULT_GRAVITY = 8388627;
    @PropDefault
    protected static final int minLines = Integer.MIN_VALUE;
    @PropDefault
    protected static final int maxLines = Integer.MAX_VALUE;
    @PropDefault
    protected static final int maxLength = Integer.MAX_VALUE;
    @PropDefault
    protected static final int shadowColor = -7829368;
    @PropDefault
    protected static final int textColor = 0;
    @PropDefault
    protected static final ColorStateList textColorStateList = new ColorStateList(DEFAULT_TEXT_COLOR_STATE_LIST_STATES, DEFAULT_TEXT_COLOR_STATE_LIST_COLORS);
    @PropDefault
    protected static final int hintColor = 0;
    @PropDefault
    protected static final ColorStateList hintColorStateList = new ColorStateList(DEFAULT_HINT_COLOR_STATE_LIST_STATES, DEFAULT_HINT_COLOR_STATE_LIST_COLORS);
    @PropDefault
    protected static final int linkColor = 0;
    @PropDefault
    protected static final int textSize = -1;
    @PropDefault
    protected static final int textStyle = DEFAULT_TYPEFACE.getStyle();
    @PropDefault
    protected static final Typeface typeface = DEFAULT_TYPEFACE;
    @PropDefault
    protected static final float spacingMultiplier = 1.0f;
    @PropDefault
    protected static final Layout.Alignment textAlignment = Layout.Alignment.ALIGN_NORMAL;
    @PropDefault
    protected static final int gravity = 8388627;
    @PropDefault
    protected static final boolean editable = true;
    @PropDefault
    protected static final int selection = -1;
    @PropDefault
    protected static final int inputType = 131073;
    @PropDefault
    protected static final int rawInputType = 0;
    @PropDefault
    protected static final int imeOptions = 0;
    @PropDefault
    protected static final boolean isSingleLineWrap = false;
    @PropDefault
    protected static final boolean requestFocus = false;
    @PropDefault
    protected static final int cursorDrawableRes = -1;
    @PropDefault
    protected static final EditTextStateUpdatePolicy stateUpdatePolicy = EditTextStateUpdatePolicy.NO_UPDATES;

    EditTextSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<TextUtils.TruncateAt> ellipsize, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<Layout.Alignment> textAlignment, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<Integer> gravity, Output<Integer> inputType, Output<Integer> imeOptions) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.Text, 0);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.Text_android_text) {
                text.set((Object)a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColor) {
                textColorStateList.set((Object)a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textSize) {
                textSize.set((Object)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_ellipsize) {
                int index = a.getInteger(attr2, 0);
                if (index <= 0) continue;
                ellipsize.set((Object)TRUNCATE_AT[index - 1]);
                continue;
            }
            if (attr2 == R.styleable.Text_android_textAlignment) {
                if (Build.VERSION.SDK_INT < 17) continue;
                int viewTextAlignment = a.getInt(attr2, -1);
                textAlignment.set((Object)EditTextSpec.getAlignment(viewTextAlignment, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minLines) {
                minLines.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxLines) {
                maxLines.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_singleLine) {
                isSingleLine.set((Object)a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColorLink) {
                linkColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColorHighlight) {
                highlightColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textStyle) {
                textStyle.set((Object)a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_lineSpacingMultiplier) {
                spacingMultiplier.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowDx) {
                shadowDx.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowDy) {
                shadowDy.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowRadius) {
                shadowRadius.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowColor) {
                shadowColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_gravity) {
                gravity.set((Object)a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_inputType) {
                inputType.set((Object)a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.Text_android_imeOptions) continue;
            imeOptions.set((Object)a.getInteger(attr2, 0));
        }
        a.recycle();
    }

    @OnMeasure
    static void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, @Prop(optional=true, resType=ResType.STRING) CharSequence text, @Prop(optional=true, resType=ResType.STRING) CharSequence initialText, @Prop(optional=true, resType=ResType.STRING) CharSequence hint, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.INT) int minLines, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int maxLength, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int hintColor, @Prop(optional=true) ColorStateList hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.COLOR) int highlightColor, @Prop(optional=true) ColorStateList tintColorStateList, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) Layout.Alignment textAlignment, @Prop(optional=true) int gravity, @Prop(optional=true) boolean editable, @Prop(optional=true) int selection, @Prop(optional=true) int inputType, @Prop(optional=true) int rawInputType, @Prop(optional=true) int imeOptions, @Prop(optional=true) TextView.OnEditorActionListener editorActionListener, @Prop(optional=true) boolean isSingleLineWrap, @Prop(optional=true) boolean requestFocus, @Prop(optional=true) int cursorDrawableRes, @Prop(optional=true, varArg="inputFilter") List<InputFilter> inputFilters, @State(canUpdateLazily=true) CharSequence input) {
        EditTextForMeasure editText = new EditTextForMeasure(c.getAndroidContext());
        EditTextSpec.initEditText(editText, input == null ? text : input, initialText, hint, ellipsize, inputFilters, minLines, maxLines, maxLength, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, textColor, textColorStateList, hintColor, hintColorStateList, linkColor, highlightColor, tintColorStateList, textSize, extraSpacing, spacingMultiplier, textStyle, typeface, textAlignment, gravity, editable, selection, inputType, rawInputType, imeOptions, editorActionListener, isSingleLineWrap, requestFocus, cursorDrawableRes);
        Drawable background = layout.getBackground();
        if (background != null) {
            Rect rect = new Rect();
            background.getPadding(rect);
            if (rect.left != 0 || rect.top != 0 || rect.right != 0 || rect.bottom != 0) {
                editText.setPadding(0, 0, 0, 0);
                if (Build.VERSION.SDK_INT < 16) {
                    editText.setBackgroundDrawable(null);
                } else {
                    editText.setBackground(null);
                }
            }
        }
        editText.measure(MeasureUtils.getViewMeasureSpec((int)widthSpec), MeasureUtils.getViewMeasureSpec((int)heightSpec));
        size.width = editText.getMeasuredWidth();
        size.height = editText.getMeasuredHeight();
    }

    @OnCreateMountContent
    protected static EditTextWithEventHandlers onCreateMountContent(Context c) {
        return new EditTextWithEventHandlers(c);
    }

    @OnMount
    static void onMount(ComponentContext c, EditTextWithEventHandlers editText, @Prop(optional=true, resType=ResType.STRING) CharSequence text, @Prop(optional=true, resType=ResType.STRING) CharSequence initialText, @Prop(optional=true, resType=ResType.STRING) CharSequence hint, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.INT) int minLines, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int maxLength, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int hintColor, @Prop(optional=true) ColorStateList hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.COLOR) int highlightColor, @Prop(optional=true) ColorStateList tintColorStateList, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) Layout.Alignment textAlignment, @Prop(optional=true) int gravity, @Prop(optional=true) boolean editable, @Prop(optional=true) int selection, @Prop(optional=true) int inputType, @Prop(optional=true) int rawInputType, @Prop(optional=true) int imeOptions, @Prop(optional=true) TextView.OnEditorActionListener editorActionListener, @Prop(optional=true) boolean isSingleLineWrap, @Prop(optional=true) boolean requestFocus, @Prop(optional=true) int cursorDrawableRes, @Prop(optional=true, varArg="inputFilter") List<InputFilter> inputFilters, @State AtomicReference<EditTextWithEventHandlers> mountedView, @State AtomicBoolean configuredInitialText, @State(canUpdateLazily=true) CharSequence input) {
        mountedView.set(editText);
        EditTextSpec.initEditText(editText, input == null ? text : input, configuredInitialText.getAndSet(true) ? null : initialText, hint, ellipsize, inputFilters, minLines, maxLines, maxLength, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, textColor, textColorStateList, hintColor, hintColorStateList, linkColor, highlightColor, tintColorStateList, textSize, extraSpacing, spacingMultiplier, textStyle, typeface, textAlignment, gravity, editable, selection, inputType, rawInputType, imeOptions, editorActionListener, isSingleLineWrap, requestFocus, cursorDrawableRes);
    }

    @OnBind
    static void onBind(ComponentContext c, EditTextWithEventHandlers editText, @Prop(optional=true) EditTextStateUpdatePolicy stateUpdatePolicy, @Prop(optional=true, varArg="textWatcher") List<TextWatcher> textWatchers) {
        editText.setComponentContext(c);
        editText.setTextChangedEventHandler(EditText.getTextChangedEventHandler(c));
        editText.setSelectionChangedEventHandler(EditText.getSelectionChangedEventHandler(c));
        editText.setKeyUpEventHandler(EditText.getKeyUpEventHandler(c));
        editText.setStateUpdatePolicy(stateUpdatePolicy);
        editText.attachWatchers(textWatchers);
    }

    @OnUnbind
    static void onUnbind(ComponentContext c, EditTextWithEventHandlers editText) {
        editText.detachWatchers();
        editText.clear();
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, EditTextWithEventHandlers editText, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        mountedView.set(null);
    }

    @OnTrigger(value=RequestFocusEvent.class)
    static void requestFocus(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        EditTextWithEventHandlers eventHandler = mountedView.get();
        if (eventHandler != null && eventHandler.requestFocus()) {
            InputMethodManager imm = (InputMethodManager)c.getAndroidContext().getSystemService("input_method");
            imm.showSoftInput((View)eventHandler, 0);
        }
    }

    @OnTrigger(value=ClearFocusEvent.class)
    static void clearFocus(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        EditTextWithEventHandlers eventHandler = mountedView.get();
        if (eventHandler != null) {
            eventHandler.clearFocus();
            InputMethodManager imm = (InputMethodManager)c.getAndroidContext().getSystemService("input_method");
            imm.hideSoftInputFromWindow(eventHandler.getWindowToken(), 0);
        }
    }

    @OnTrigger(value=SetTextEvent.class)
    static void setText(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView, @FromTrigger CharSequence text) {
        ThreadUtils.assertMainThread();
        EditText.lazyUpdateInput(c, text);
        EditTextWithEventHandlers view = mountedView.get();
        if (view != null) {
            view.setText(text);
        }
    }

    @OnUpdateState
    static void updateInput(StateValue<CharSequence> input, @Param CharSequence newInput) {
        input.set((Object)newInput);
    }

    @OnCreateInitialState
    static void onCreateInitialState(StateValue<AtomicReference<EditTextWithEventHandlers>> mountedView, StateValue<AtomicBoolean> configuredInitialText) {
        mountedView.set(new AtomicReference());
        configuredInitialText.set((Object)new AtomicBoolean());
    }

    private static void initEditText(android.widget.EditText editText, CharSequence text, CharSequence initialText, CharSequence hint, TextUtils.TruncateAt ellipsize, @Nullable List<InputFilter> inputFilters, int minLines, int maxLines, int maxLength, float shadowRadius, float shadowDx, float shadowDy, int shadowColor, boolean isSingleLine, int textColor, ColorStateList textColorStateList, int hintColor, ColorStateList hintColorStateList, int linkColor, int highlightColor, ColorStateList tintColorStateList, int textSize, float extraSpacing, float spacingMultiplier, int textStyle, Typeface typeface, Layout.Alignment textAlignment, int gravity, boolean editable, int selection, int inputType, int rawInputType, int imeOptions, TextView.OnEditorActionListener editorActionListener, boolean isSingleLineWrap, boolean requestFocus, int cursorDrawableRes) {
        int textLength;
        boolean hintsAreEqual;
        if (textSize == -1) {
            editText.setTextSize(2, 14.0f);
        } else {
            editText.setTextSize(0, (float)textSize);
        }
        inputType = isSingleLine ? (inputType &= 0xFFFDFFFF) : (inputType |= 0x20000);
        if (rawInputType != 0) {
            editText.setSingleLine(isSingleLine);
            editText.setRawInputType(rawInputType);
        } else if (inputType != editText.getInputType()) {
            editText.setSingleLine(isSingleLine);
            editText.setInputType(inputType);
        }
        if (isSingleLine && isSingleLineWrap) {
            editText.setHorizontallyScrolling(false);
        }
        InputFilter.LengthFilter lengthFilter = new InputFilter.LengthFilter(maxLength);
        if (inputFilters == null) {
            editText.setFilters(new InputFilter[]{lengthFilter});
        } else {
            inputFilters = new ArrayList<InputFilter>(inputFilters);
            inputFilters.add((InputFilter)lengthFilter);
            editText.setFilters(inputFilters.toArray(new InputFilter[inputFilters.size()]));
        }
        if (!(text instanceof String) || !text.equals(editText.getText().toString())) {
            editText.setText(text);
        } else if (initialText != null) {
            editText.setText(initialText);
        }
        CharSequence oldHint = editText.getHint();
        boolean bl = hintsAreEqual = oldHint == hint || oldHint != null && oldHint.equals(hint);
        if (!hintsAreEqual) {
            editText.setHint(hint);
        }
        editText.setEllipsize(ellipsize);
        editText.setMinLines(minLines);
        editText.setMaxLines(maxLines);
        editText.setShadowLayer(shadowRadius, shadowDx, shadowDy, shadowColor);
        editText.setLinkTextColor(linkColor);
        editText.setHighlightColor(highlightColor);
        editText.setLineSpacing(extraSpacing, spacingMultiplier);
        editText.setTypeface(typeface, textStyle);
        editText.setGravity(gravity);
        editText.setImeOptions(imeOptions);
        editText.setOnEditorActionListener(editorActionListener);
        editText.setFocusable(editable);
        editText.setFocusableInTouchMode(editable);
        editText.setClickable(editable);
        editText.setLongClickable(editable);
        editText.setCursorVisible(editable);
        Editable editableText = editText.getText();
        int n = textLength = editableText != null ? editableText.length() : -1;
        if (selection > -1 && selection <= textLength) {
            editText.setSelection(selection);
        }
        if (textColor != 0 || textColorStateList == null) {
            editText.setTextColor(textColor);
        } else {
            editText.setTextColor(textColorStateList);
        }
        if (hintColor != 0 || hintColorStateList == null) {
            editText.setHintTextColor(hintColor);
        } else {
            editText.setHintTextColor(hintColorStateList);
        }
        if (tintColorStateList != null) {
            ViewCompat.setBackgroundTintList((View)editText, (ColorStateList)tintColorStateList);
        }
        if (requestFocus) {
            editText.requestFocus();
        }
        if (cursorDrawableRes != -1) {
            if (Build.VERSION.SDK_INT >= 29) {
                editText.setTextCursorDrawable(cursorDrawableRes);
            } else {
                try {
                    Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                    f.setAccessible(true);
                    f.set(editText, cursorDrawableRes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        switch (textAlignment) {
            case ALIGN_NORMAL: {
                if (Build.VERSION.SDK_INT >= 17) {
                    editText.setTextAlignment(2);
                    break;
                }
                editText.setGravity(gravity | 3);
                break;
            }
            case ALIGN_OPPOSITE: {
                if (Build.VERSION.SDK_INT >= 17) {
                    editText.setTextAlignment(3);
                    break;
                }
                editText.setGravity(gravity | 5);
                break;
            }
            case ALIGN_CENTER: {
                if (Build.VERSION.SDK_INT >= 17) {
                    editText.setTextAlignment(4);
                    break;
                }
                editText.setGravity(gravity | 1);
            }
        }
    }

    private static Layout.Alignment getAlignment(int viewTextAlignment, int gravity) {
        Layout.Alignment alignment;
        switch (viewTextAlignment) {
            case 1: {
                alignment = EditTextSpec.getAlignment(gravity);
                break;
            }
            case 2: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 4: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 6: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 0: {
                alignment = EditTextSpec.getAlignment(gravity);
                break;
            }
            default: {
                alignment = textAlignment;
            }
        }
        return alignment;
    }

    private static Layout.Alignment getAlignment(int gravity) {
        Layout.Alignment alignment;
        switch (gravity & 0x800007) {
            case 0x800003: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 0x800005: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            default: {
                alignment = textAlignment;
            }
        }
        return alignment;
    }

    static class EditTextForMeasure
    extends android.widget.EditText {
        EditTextForMeasure(Context context) {
            super(context);
        }

        public void setBackground(Drawable background) {
            if (background != null) {
                background.mutate();
            }
            super.setBackground(background);
        }
    }

    static class EditTextWithEventHandlers
    extends android.widget.EditText {
        private final DelegatingTextWatcher mTextWatcher = new DelegatingTextWatcher();
        private ComponentContext mComponentContext;
        private EditTextStateUpdatePolicy mStateUpdatePolicy;
        private EventHandler mTextChangedEventHandler;
        private EventHandler mSelectionChangedEventHandler;
        private EventHandler mKeyUpEventHandler;

        EditTextWithEventHandlers(Context context) {
            super(context);
        }

        protected void onSelectionChanged(int selStart, int selEnd) {
            super.onSelectionChanged(selStart, selEnd);
            if (this.mSelectionChangedEventHandler != null) {
                EditText.dispatchSelectionChangedEvent(this.mSelectionChangedEventHandler, selStart, selEnd);
            }
        }

        public boolean onKeyUp(int keyCode, KeyEvent event) {
            if (this.mKeyUpEventHandler != null) {
                EditText.dispatchKeyUpEvent(this.mKeyUpEventHandler, keyCode, event);
            }
            return super.onKeyUp(keyCode, event);
        }

        void setStateUpdatePolicy(EditTextStateUpdatePolicy stateUpdatePolicy) {
            this.mStateUpdatePolicy = stateUpdatePolicy;
        }

        void setComponentContext(ComponentContext componentContext) {
            this.mComponentContext = componentContext;
        }

        void setTextChangedEventHandler(EventHandler textChangedEventHandler) {
            this.mTextChangedEventHandler = textChangedEventHandler;
        }

        void setSelectionChangedEventHandler(EventHandler selectionChangedEventHandler) {
            this.mSelectionChangedEventHandler = selectionChangedEventHandler;
        }

        void setKeyUpEventHandler(EventHandler keyUpEventHandler) {
            this.mKeyUpEventHandler = keyUpEventHandler;
        }

        void clear() {
            this.mStateUpdatePolicy = stateUpdatePolicy;
            this.mComponentContext = null;
            this.mTextChangedEventHandler = null;
            this.mSelectionChangedEventHandler = null;
            this.mKeyUpEventHandler = null;
        }

        void attachWatchers(@Nullable List<TextWatcher> textWatchers) {
            this.mTextWatcher.setDelegates(textWatchers);
            this.addTextChangedListener(this.mTextWatcher);
        }

        void detachWatchers() {
            this.mTextWatcher.setDelegates(null);
            this.removeTextChangedListener(this.mTextWatcher);
        }

        private class DelegatingTextWatcher
        implements TextWatcher {
            @Nullable
            List<TextWatcher> mDelegates;
            int mPrevLineCount;

            private DelegatingTextWatcher() {
            }

            public void setDelegates(@Nullable List<TextWatcher> delegates) {
                this.mDelegates = delegates;
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (this.mDelegates != null) {
                    int stop = this.mDelegates.size();
                    for (int i = 0; i < stop; ++i) {
                        this.mDelegates.get(i).beforeTextChanged(s, start, count, after);
                    }
                }
                if (EditTextWithEventHandlers.this.mStateUpdatePolicy == EditTextStateUpdatePolicy.UPDATE_ON_LINE_COUNT_CHANGE) {
                    this.mPrevLineCount = EditTextWithEventHandlers.this.getLineCount();
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (this.mDelegates != null) {
                    int stop = this.mDelegates.size();
                    for (int i = 0; i < stop; ++i) {
                        this.mDelegates.get(i).onTextChanged(s, start, before, count);
                    }
                }
                if (EditTextWithEventHandlers.this.mStateUpdatePolicy == EditTextStateUpdatePolicy.UPDATE_ON_LINE_COUNT_CHANGE && this.mPrevLineCount != EditTextWithEventHandlers.this.getLineCount() || EditTextWithEventHandlers.this.mStateUpdatePolicy == EditTextStateUpdatePolicy.UPDATE_ON_TEXT_CHANGE) {
                    EditText.updateInputSync(EditTextWithEventHandlers.this.mComponentContext, s.toString());
                } else if (EditTextWithEventHandlers.this.mStateUpdatePolicy != EditTextStateUpdatePolicy.NO_UPDATES) {
                    EditText.lazyUpdateInput(EditTextWithEventHandlers.this.mComponentContext, s.toString());
                }
            }

            public void afterTextChanged(Editable s) {
                if (this.mDelegates != null) {
                    int stop = this.mDelegates.size();
                    for (int i = 0; i < stop; ++i) {
                        this.mDelegates.get(i).afterTextChanged(s);
                    }
                }
                if (EditTextWithEventHandlers.this.mTextChangedEventHandler != null) {
                    EditText.dispatchTextChangedEvent(EditTextWithEventHandlers.this.mTextChangedEventHandler, EditTextWithEventHandlers.this, s.toString());
                }
            }
        }
    }
}

