/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.Resources;
import com.facebook.litho.Column;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.annotations.LayoutSpec;
import com.facebook.litho.annotations.OnCreateLayout;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardClip;
import com.facebook.litho.widget.CardShadow;
import com.facebook.litho.widget.CardShadowDrawable;
import com.facebook.litho.widget.TransparencyEnabledCardClip;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;

@LayoutSpec(isPureRender=true)
class CardSpec {
    private static final int DEFAULT_CORNER_RADIUS_DP = 2;
    private static final int DEFAULT_SHADOW_SIZE_DP = 2;
    private static final int UNSET_CLIPPING = Integer.MIN_VALUE;
    @PropDefault
    static final int cardBackgroundColor = -1;
    @PropDefault
    static final int clippingColor = Integer.MIN_VALUE;
    @PropDefault
    static final int shadowStartColor = 0x37000000;
    @PropDefault
    static final int shadowEndColor = 0x3000000;
    @PropDefault
    static final float cornerRadius = -1.0f;
    @PropDefault
    static final float elevation = -1.0f;
    @PropDefault
    static final int shadowTopOverride = -1;
    @PropDefault
    static final int shadowBottomOverride = -1;
    @PropDefault
    static final boolean transparencyEnabled = false;

    CardSpec() {
    }

    private static float pixels(Resources resources, int dips) {
        float scale = resources.getDisplayMetrics().density;
        return (float)dips * scale + 0.5f;
    }

    @OnCreateLayout
    static Component onCreateLayout(ComponentContext c, @Prop Component content, @Prop(optional=true, resType=ResType.COLOR) int cardBackgroundColor, @Prop(optional=true, resType=ResType.COLOR) int clippingColor, @Prop(optional=true, resType=ResType.COLOR) int shadowStartColor, @Prop(optional=true, resType=ResType.COLOR) int shadowEndColor, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float cornerRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float elevation, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) int shadowTopOverride, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) int shadowBottomOverride, @Prop(optional=true, docString="[UNPERFORMANT WARNING] if you do not need to render your corners transparently please set to false. It is more expensive to perform rounded corners with transparent\nclipping due to antialiasing operations.\n\n<p>A component that renders a given component into a card border with shadow, and allows for\ntransparent corners. With transparencyEnabled(false) {@link * com.facebook.litho.widget.Card} uses imitation clipped corners that\ndraw in a solid color to mimic the background. transparencyEnabled(true) is useful if you are\nrendering your pill over a gradient or dynamic background.\n") boolean transparencyEnabled, @Prop(optional=true) boolean disableClipTopLeft, @Prop(optional=true) boolean disableClipTopRight, @Prop(optional=true) boolean disableClipBottomLeft, @Prop(optional=true) boolean disableClipBottomRight) {
        Resources resources = c.getResources();
        if (cornerRadius == -1.0f) {
            cornerRadius = CardSpec.pixels(resources, 2);
        }
        if (elevation == -1.0f) {
            elevation = CardSpec.pixels(resources, 2);
        }
        int shadowTop = shadowTopOverride == -1 ? CardShadowDrawable.getShadowTop(elevation) : shadowTopOverride;
        int shadowBottom = shadowBottomOverride == -1 ? CardShadowDrawable.getShadowBottom(elevation) : shadowBottomOverride;
        int shadowLeft = CardShadowDrawable.getShadowLeft(elevation);
        int shadowRight = CardShadowDrawable.getShadowRight(elevation);
        Column.Builder columnBuilder = (Column.Builder)((Column.Builder)((Column.Builder)((Column.Builder)Column.create((ComponentContext)c).marginPx(YogaEdge.LEFT, shadowLeft)).marginPx(YogaEdge.RIGHT, shadowRight)).marginPx(YogaEdge.TOP, disableClipTopLeft && disableClipTopRight ? 0 : shadowTop)).marginPx(YogaEdge.BOTTOM, disableClipBottomLeft && disableClipBottomRight ? 0 : shadowBottom);
        if (transparencyEnabled) {
            int realClippingColor = clippingColor == Integer.MIN_VALUE ? 0 : clippingColor;
            columnBuilder = ((Column.Builder)columnBuilder.backgroundColor(realClippingColor)).child(CardSpec.makeTransparencyEnabledCardClip(c, cardBackgroundColor, cornerRadius)).child(content);
        } else {
            int realClippingColor = clippingColor == Integer.MIN_VALUE ? -1 : clippingColor;
            columnBuilder = ((Column.Builder)columnBuilder.backgroundColor(cardBackgroundColor)).child(content).child(CardSpec.makeCardClip(c, realClippingColor, cornerRadius, disableClipTopLeft, disableClipTopRight, disableClipBottomLeft, disableClipBottomRight));
        }
        return Column.create((ComponentContext)c).child((Component.Builder)columnBuilder).child(elevation > 0.0f ? (CardShadow.Builder)((CardShadow.Builder)CardShadow.create(c).shadowStartColor(shadowStartColor).shadowEndColor(shadowEndColor).cornerRadiusPx(cornerRadius).shadowSizePx(elevation).hideTopShadow(disableClipTopLeft && disableClipTopRight).hideBottomShadow(disableClipBottomLeft && disableClipBottomRight).positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0) : null).build();
    }

    private static Component.Builder makeTransparencyEnabledCardClip(ComponentContext c, int clippingColor, float cornerRadius) {
        return ((TransparencyEnabledCardClip.Builder)TransparencyEnabledCardClip.create(c).cardBackgroundColor(clippingColor).cornerRadiusPx(cornerRadius).positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0);
    }

    private static Component.Builder makeCardClip(ComponentContext c, int clippingColor, float cornerRadius, boolean disableClipTopLeft, boolean disableClipTopRight, boolean disableClipBottomLeft, boolean disableClipBottomRight) {
        return ((CardClip.Builder)((CardClip.Builder)CardClip.create(c).clippingColor(clippingColor).cornerRadiusPx(cornerRadius).positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0)).disableClipTopLeft(disableClipTopLeft).disableClipTopRight(disableClipTopRight).disableClipBottomLeft(disableClipBottomLeft).disableClipBottomRight(disableClipBottomRight);
    }
}

