/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardShadowDrawable;

@MountSpec(isPureRender=true)
class CardShadowSpec {
    @PropDefault
    static final float shadowDx = -1.0f;
    @PropDefault
    static final float shadowDy = -1.0f;

    CardShadowSpec() {
    }

    @OnCreateMountContent
    static CardShadowDrawable onCreateMountContent(Context c) {
        return new CardShadowDrawable();
    }

    @OnMount
    static void onMount(ComponentContext context, CardShadowDrawable cardShadowDrawable, @Prop(optional=true, resType=ResType.COLOR) int shadowStartColor, @Prop(optional=true, resType=ResType.COLOR) int shadowEndColor, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float cornerRadius, @Prop(optional=true, resType=ResType.DIMEN_SIZE) float shadowSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true) boolean hideTopShadow, @Prop(optional=true) boolean hideBottomShadow) {
        cardShadowDrawable.setShadowStartColor(shadowStartColor);
        cardShadowDrawable.setShadowEndColor(shadowEndColor);
        cardShadowDrawable.setCornerRadius(cornerRadius);
        cardShadowDrawable.setShadowSize(shadowSize);
        cardShadowDrawable.setHideTopShadow(hideTopShadow);
        cardShadowDrawable.setHideBottomShadow(hideBottomShadow);
        cardShadowDrawable.setShadowDx(shadowDx);
        cardShadowDrawable.setShadowDy(shadowDy);
    }
}

