/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Px;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardShadowDrawable;
import com.facebook.litho.widget.CardShadowSpec;

public final class CardShadow
extends Component {
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float cornerRadius;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean hideBottomShadow;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean hideTopShadow;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDx = -1.0f;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDy = -1.0f;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowEndColor;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=0)
    float shadowSize;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowStartColor;

    private CardShadow() {
        super("CardShadow");
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        CardShadow cardShadowRef = (CardShadow)other;
        if (Float.compare(this.cornerRadius, cardShadowRef.cornerRadius) != 0) {
            return false;
        }
        if (this.hideBottomShadow != cardShadowRef.hideBottomShadow) {
            return false;
        }
        if (this.hideTopShadow != cardShadowRef.hideTopShadow) {
            return false;
        }
        if (Float.compare(this.shadowDx, cardShadowRef.shadowDx) != 0) {
            return false;
        }
        if (Float.compare(this.shadowDy, cardShadowRef.shadowDy) != 0) {
            return false;
        }
        if (this.shadowEndColor != cardShadowRef.shadowEndColor) {
            return false;
        }
        if (Float.compare(this.shadowSize, cardShadowRef.shadowSize) != 0) {
            return false;
        }
        return this.shadowStartColor == cardShadowRef.shadowStartColor;
    }

    protected Object onCreateMountContent(Context c) {
        CardShadowDrawable _result = CardShadowSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext context, Object cardShadowDrawable) {
        CardShadowSpec.onMount(context, (CardShadowDrawable)((Object)cardShadowDrawable), this.shadowStartColor, this.shadowEndColor, this.cornerRadius, this.shadowSize, this.shadowDx, this.shadowDy, this.hideTopShadow, this.hideBottomShadow);
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return CardShadow.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        CardShadow instance = new CardShadow();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        CardShadow mCardShadow;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, CardShadow cardShadowRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)cardShadowRef);
            this.mCardShadow = cardShadowRef;
            this.mContext = context;
        }

        protected void setComponent(Component component) {
            this.mCardShadow = (CardShadow)component;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mCardShadow.cornerRadius = cornerRadius;
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mCardShadow.cornerRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusSp(@Dimension(unit=2) float sip) {
            this.mCardShadow.cornerRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mCardShadow.cornerRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardShadow.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCardShadow.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hideBottomShadow", required=false)
        public Builder hideBottomShadow(boolean hideBottomShadow) {
            this.mCardShadow.hideBottomShadow = hideBottomShadow;
            return this;
        }

        @PropSetter(value="hideTopShadow", required=false)
        public Builder hideTopShadow(boolean hideTopShadow) {
            this.mCardShadow.hideTopShadow = hideTopShadow;
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxPx(@Px float shadowDx) {
            this.mCardShadow.shadowDx = shadowDx;
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxDip(@Dimension(unit=0) float dip) {
            this.mCardShadow.shadowDx = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxSp(@Dimension(unit=2) float sip) {
            this.mCardShadow.shadowDx = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxRes(@DimenRes int resId) {
            this.mCardShadow.shadowDx = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardShadow.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId) {
            this.mCardShadow.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyPx(@Px float shadowDy) {
            this.mCardShadow.shadowDy = shadowDy;
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyDip(@Dimension(unit=0) float dip) {
            this.mCardShadow.shadowDy = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDySp(@Dimension(unit=2) float sip) {
            this.mCardShadow.shadowDy = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyRes(@DimenRes int resId) {
            this.mCardShadow.shadowDy = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardShadow.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId) {
            this.mCardShadow.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColor(@ColorInt int shadowEndColor) {
            this.mCardShadow.shadowEndColor = shadowEndColor;
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColorRes(@ColorRes int resId) {
            this.mCardShadow.shadowEndColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardShadow.shadowEndColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColorAttr(@AttrRes int attrResId) {
            this.mCardShadow.shadowEndColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowSize", required=false)
        public Builder shadowSizePx(@Px float shadowSize) {
            this.mCardShadow.shadowSize = shadowSize;
            return this;
        }

        @PropSetter(value="shadowSize", required=false)
        public Builder shadowSizeDip(@Dimension(unit=0) float dip) {
            this.mCardShadow.shadowSize = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowSize", required=false)
        public Builder shadowSizeRes(@DimenRes int resId) {
            this.mCardShadow.shadowSize = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowSize", required=false)
        public Builder shadowSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardShadow.shadowSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowSize", required=false)
        public Builder shadowSizeAttr(@AttrRes int attrResId) {
            this.mCardShadow.shadowSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColor(@ColorInt int shadowStartColor) {
            this.mCardShadow.shadowStartColor = shadowStartColor;
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColorRes(@ColorRes int resId) {
            this.mCardShadow.shadowStartColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardShadow.shadowStartColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColorAttr(@AttrRes int attrResId) {
            this.mCardShadow.shadowStartColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public CardShadow build() {
            return this.mCardShadow;
        }
    }
}

