/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.EventHandler;
import com.facebook.litho.RenderCompleteEvent;
import com.facebook.litho.viewcompat.ViewBinder;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.RenderInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseRenderInfo
implements RenderInfo {
    private static final String IS_STICKY = "is_sticky";
    private static final String SPAN_SIZE = "span_size";
    private static final String IS_FULL_SPAN = "is_full_span";
    @Nullable
    private Map<String, Object> mCustomAttributes;
    @Nullable
    private Map<String, Object> mDebugInfo;

    protected BaseRenderInfo(Builder builder) {
        this.mCustomAttributes = builder.mCustomAttributes;
        this.mDebugInfo = builder.mDebugInfo;
    }

    @Override
    public boolean isSticky() {
        if (this.mCustomAttributes == null || !this.mCustomAttributes.containsKey(IS_STICKY)) {
            return false;
        }
        return (Boolean)this.mCustomAttributes.get(IS_STICKY);
    }

    @Override
    public int getSpanSize() {
        if (this.mCustomAttributes == null || !this.mCustomAttributes.containsKey(SPAN_SIZE)) {
            return 1;
        }
        return (Integer)this.mCustomAttributes.get(SPAN_SIZE);
    }

    @Override
    public boolean isFullSpan() {
        if (this.mCustomAttributes == null || !this.mCustomAttributes.containsKey(IS_FULL_SPAN)) {
            return false;
        }
        return (Boolean)this.mCustomAttributes.get(IS_FULL_SPAN);
    }

    @Override
    @Nullable
    public Object getCustomAttribute(String key) {
        return this.mCustomAttributes == null ? null : this.mCustomAttributes.get(key);
    }

    @Override
    public void addCustomAttribute(String key, Object value) {
        if (this.mCustomAttributes == null) {
            this.mCustomAttributes = Collections.synchronizedMap(new HashMap());
        }
        this.mCustomAttributes.put(key, value);
    }

    @Override
    public boolean rendersComponent() {
        return false;
    }

    @Override
    public Component getComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public EventHandler<RenderCompleteEvent> getRenderCompleteEventHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public ComponentsLogger getComponentsLogger() {
        return null;
    }

    @Override
    @Nullable
    public String getLogTag() {
        return null;
    }

    @Override
    public boolean rendersView() {
        return false;
    }

    @Override
    public ViewBinder getViewBinder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ViewCreator getViewCreator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCustomViewType() {
        return false;
    }

    @Override
    public int getViewType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDebugInfo(String key, Object value) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = Collections.synchronizedMap(new HashMap());
        }
        this.mDebugInfo.put(key, value);
    }

    @Override
    @Nullable
    public Object getDebugInfo(String key) {
        if (this.mDebugInfo == null) {
            return null;
        }
        return this.mDebugInfo.get(key);
    }

    @Override
    public void setViewType(int viewType) {
        throw new UnsupportedOperationException();
    }

    public static abstract class Builder<T> {
        @Nullable
        private Map<String, Object> mCustomAttributes;
        @Nullable
        private Map<String, Object> mDebugInfo;

        public T isSticky(boolean isSticky) {
            return this.customAttribute(BaseRenderInfo.IS_STICKY, isSticky);
        }

        public T spanSize(int spanSize) {
            return this.customAttribute(BaseRenderInfo.SPAN_SIZE, spanSize);
        }

        public T isFullSpan(boolean isFullSpan) {
            return this.customAttribute(BaseRenderInfo.IS_FULL_SPAN, isFullSpan);
        }

        public T customAttribute(String key, Object value) {
            if (this.mCustomAttributes == null) {
                this.mCustomAttributes = Collections.synchronizedMap(new HashMap());
            }
            this.mCustomAttributes.put(key, value);
            return (T)this;
        }

        public T debugInfo(String key, Object value) {
            if (this.mDebugInfo == null) {
                this.mDebugInfo = Collections.synchronizedMap(new HashMap());
            }
            this.mDebugInfo.put(key, value);
            return (T)this;
        }
    }
}

