/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import com.facebook.rendercore.RenderCoreConfig;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public final class ThreadUtils {
    private static final String THREAD_NAME = "ThreadUtilsBackgroundHandler";
    private static final int DEFAULT_BACKGROUND_THREAD_PRIORITY = 5;
    @Nullable
    private static volatile Handler sUiThreadHandler;
    @Nullable
    private static volatile Handler sDefaultBackgroundThreadHandler;

    private ThreadUtils() {
    }

    public static void assertMainThread() {
        ThreadUtils.assertMainThread("This must run on the main thread; but is running on " + Thread.currentThread().getName());
    }

    public static void assertMainThread(String message) {
        if (RenderCoreConfig.isEndToEndTestRun) {
            return;
        }
        if (!ThreadUtils.isMainThread()) {
            throw new IllegalStateException(message);
        }
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static <T> T getResultInheritingPriority(Future<T> future, int runningThreadId) {
        boolean didRaiseThreadPriority;
        int originalThreadPriority;
        boolean shouldWaitForResult;
        boolean notRunningOnMyThread = runningThreadId != Process.myTid();
        boolean bl = shouldWaitForResult = !future.isDone() && notRunningOnMyThread;
        if (ThreadUtils.isMainThread() && shouldWaitForResult) {
            originalThreadPriority = ThreadUtils.tryInheritThreadPriorityFromCurrentThread(runningThreadId);
            didRaiseThreadPriority = true;
        } else {
            originalThreadPriority = 0;
            didRaiseThreadPriority = false;
        }
        try {
            T t = future.get();
            return t;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InterruptedException | CancellationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (didRaiseThreadPriority) {
                try {
                    Process.setThreadPriority((int)runningThreadId, (int)originalThreadPriority);
                }
                catch (IllegalArgumentException | SecurityException e) {
                    throw new RuntimeException("Unable to restore priority: " + runningThreadId + ", " + originalThreadPriority, e);
                }
            }
        }
    }

    public static int tryInheritThreadPriorityFromCurrentThread(int threadId) {
        return ThreadUtils.tryRaiseThreadPriority(threadId, Process.getThreadPriority((int)Process.myTid()));
    }

    public static int tryRaiseThreadPriority(int threadId, int targetThreadPriority) {
        int originalThreadPriority = Process.getThreadPriority((int)threadId);
        boolean success = false;
        while (!success && targetThreadPriority < originalThreadPriority) {
            try {
                Process.setThreadPriority((int)threadId, (int)targetThreadPriority);
                success = true;
            }
            catch (SecurityException e) {
                ++targetThreadPriority;
            }
        }
        return originalThreadPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler ensureUiThreadHandler() {
        if (sUiThreadHandler != null) return sUiThreadHandler;
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            if (sUiThreadHandler != null) return sUiThreadHandler;
            sUiThreadHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sUiThreadHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler ensureDefaultBackgroundThreadHandler() {
        if (sDefaultBackgroundThreadHandler != null) return sDefaultBackgroundThreadHandler;
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            if (sDefaultBackgroundThreadHandler != null) return sDefaultBackgroundThreadHandler;
            HandlerThread handlerThread = new HandlerThread(THREAD_NAME, 5);
            handlerThread.start();
            sDefaultBackgroundThreadHandler = new Handler(handlerThread.getLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultBackgroundThreadHandler;
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        if (ThreadUtils.isMainThread()) {
            runnable.run();
        } else {
            ThreadUtils.ensureUiThreadHandler().post(runnable);
        }
    }

    public static void runOnBackgroundThread(Runnable runnable) {
        ThreadUtils.ensureDefaultBackgroundThreadHandler().post(runnable);
    }
}

