/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.utils;

import android.view.View;

public class MeasureSpecUtils {
    private static final float DELTA = 0.5f;

    public static int unspecified() {
        return View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    }

    public static int atMost(int px) {
        return View.MeasureSpec.makeMeasureSpec((int)px, (int)Integer.MIN_VALUE);
    }

    public static int exactly(int px) {
        return View.MeasureSpec.makeMeasureSpec((int)px, (int)0x40000000);
    }

    public static boolean areMeasureSpecsEquivalent(int specA, int specB) {
        return specA == specB || View.MeasureSpec.getMode((int)specA) == 0 && View.MeasureSpec.getMode((int)specB) == 0;
    }

    public static boolean isMeasureSpecCompatible(int oldSizeSpec, int sizeSpec, int oldMeasuredSize) {
        int newSpecMode = View.MeasureSpec.getMode((int)sizeSpec);
        int newSpecSize = View.MeasureSpec.getSize((int)sizeSpec);
        int oldSpecMode = View.MeasureSpec.getMode((int)oldSizeSpec);
        int oldSpecSize = View.MeasureSpec.getSize((int)oldSizeSpec);
        return oldSizeSpec == sizeSpec || oldSpecMode == 0 && newSpecMode == 0 || MeasureSpecUtils.newSizeIsExactAndMatchesOldMeasuredSize(newSpecMode, newSpecSize, oldMeasuredSize) || MeasureSpecUtils.oldSizeIsUnspecifiedAndStillFits(oldSpecMode, newSpecMode, newSpecSize, oldMeasuredSize) || MeasureSpecUtils.newMeasureSizeIsStricterAndStillValid(oldSpecMode, newSpecMode, oldSpecSize, newSpecSize, oldMeasuredSize);
    }

    private static boolean newSizeIsExactAndMatchesOldMeasuredSize(int newSizeSpecMode, int newSizeSpecSize, float oldMeasuredSize) {
        return newSizeSpecMode == 0x40000000 && Math.abs((float)newSizeSpecSize - oldMeasuredSize) < 0.5f;
    }

    private static boolean oldSizeIsUnspecifiedAndStillFits(int oldSizeSpecMode, int newSizeSpecMode, int newSizeSpecSize, float oldMeasuredSize) {
        return newSizeSpecMode == Integer.MIN_VALUE && oldSizeSpecMode == 0 && (float)newSizeSpecSize >= oldMeasuredSize;
    }

    private static boolean newMeasureSizeIsStricterAndStillValid(int oldSizeSpecMode, int newSizeSpecMode, int oldSizeSpecSize, int newSizeSpecSize, float oldMeasuredSize) {
        return oldSizeSpecMode == Integer.MIN_VALUE && newSizeSpecMode == Integer.MIN_VALUE && oldSizeSpecSize > newSizeSpecSize && oldMeasuredSize <= (float)newSizeSpecSize;
    }
}

