/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import androidx.annotation.RequiresApi;

public class LayoutUtils {
    public static boolean isLayoutDirectionRTL(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 17 && (applicationInfo.flags & 0x400000) != 0) {
            int layoutDirection = API17LayoutUtils.getLayoutDirection(context);
            return layoutDirection == 1;
        }
        return false;
    }

    private static class API17LayoutUtils {
        private API17LayoutUtils() {
        }

        @RequiresApi(value=17)
        public static int getLayoutDirection(Context context) {
            return context.getResources().getConfiguration().getLayoutDirection();
        }
    }
}

