/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.utils;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.RenderTreeNode;

public class BoundsUtils {
    public static void applyBoundsToMountContent(RenderTreeNode renderTreeNode, Object content, boolean force) {
        Rect bounds = renderTreeNode.getBounds();
        BoundsUtils.applyBoundsToMountContent(bounds, renderTreeNode.getResolvedPadding(), content, force);
    }

    public static void applyBoundsToMountContent(Rect bounds, @Nullable Rect padding, Object content, boolean force) {
        BoundsUtils.applyBoundsToMountContent(bounds.left, bounds.top, bounds.right, bounds.bottom, padding, content, force);
    }

    public static void applyBoundsToMountContent(int left, int top, int right, int bottom, @Nullable Rect padding, Object content, boolean force) {
        if (content instanceof View) {
            BoundsUtils.applyBoundsToView((View)content, left, top, right, bottom, padding, force);
        } else if (content instanceof Drawable) {
            if (padding != null) {
                left += padding.left;
                top += padding.top;
                right -= padding.right;
                bottom -= padding.bottom;
            }
            ((Drawable)content).setBounds(left, top, right, bottom);
        } else {
            throw new IllegalStateException("Unsupported mounted content " + content);
        }
    }

    private static void applyBoundsToView(View view, int left, int top, int right, int bottom, @Nullable Rect padding, boolean force) {
        int width = right - left;
        int height = bottom - top;
        if (padding != null && !(view instanceof Host)) {
            view.setPadding(padding.left, padding.top, padding.right, padding.bottom);
        }
        if (force || view.getMeasuredHeight() != height || view.getMeasuredWidth() != width) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        }
        if (force || view.getLeft() != left || view.getTop() != top || view.getRight() != right || view.getBottom() != bottom) {
            view.layout(left, top, right, bottom);
        }
    }
}

