/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.renderunits;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.rendercore.HostView;
import com.facebook.rendercore.InterceptTouchHandler;
import com.facebook.rendercore.RenderUnit;

public class HostRenderUnit
extends RenderUnit<HostView> {
    private static final int UNSET = -1;
    private static final int SET_FALSE = 0;
    private static final int SET_TRUE = 1;
    private long mId;
    @Nullable
    private Drawable mBackground;
    @Nullable
    private Drawable mForeground;
    private int mLayerType = 0;
    private int mClickable = -1;
    private boolean mEnabled = true;
    private boolean mFocusable;
    private boolean mFocusableInTouchMode;
    private View.OnFocusChangeListener mOnFocusChangeListener;
    private InterceptTouchHandler mInterceptTouchHandler;
    private View.OnLongClickListener mLongClickListener;
    private View.OnClickListener mClickListener;
    private View.OnTouchListener mOnTouchListener;
    public static RenderUnit.Binder<HostRenderUnit, HostView> sBackgroundBindFunction = new RenderUnit.Binder<HostRenderUnit, HostView>(){

        @Override
        public boolean shouldUpdate(HostRenderUnit currentValue, HostRenderUnit newValue, Object currentLayoutData, Object nextLayoutData) {
            Drawable currentBackground = currentValue.mBackground;
            Drawable newBackground = newValue.mBackground;
            if (currentBackground == null) {
                return newBackground != null;
            }
            return newBackground != null && !currentBackground.equals(newBackground);
        }

        @Override
        public void bind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, Object layoutData) {
            hostView.setBackground(hostRenderUnit.getBackground());
        }

        @Override
        public void unbind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, Object layoutData) {
            hostView.setBackground(null);
        }
    };
    public static RenderUnit.Binder<HostRenderUnit, HostView> sForegroundBindFunction = new RenderUnit.Binder<HostRenderUnit, HostView>(){

        @Override
        public boolean shouldUpdate(HostRenderUnit currentValue, HostRenderUnit newValue, Object currentLayoutData, Object nextLayoutData) {
            Drawable currentForeground = currentValue.mForeground;
            Drawable newForeground = newValue.mForeground;
            if (currentForeground == null) {
                return newForeground != null;
            }
            return newForeground != null && !currentForeground.equals(newForeground);
        }

        @Override
        public void bind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, Object layoutData) {
            hostView.setForegroundCompat(hostRenderUnit.getForeground());
        }

        @Override
        public void unbind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, Object layoutData) {
            hostView.setForegroundCompat(null);
        }
    };
    public static RenderUnit.Binder<HostRenderUnit, HostView> sLayerTypeBindFunction = new RenderUnit.Binder<HostRenderUnit, HostView>(){

        @Override
        public boolean shouldUpdate(HostRenderUnit currentModel, HostRenderUnit newModel, @Nullable Object currentLayoutData, @Nullable Object nextLayoutData) {
            return currentModel.mLayerType != newModel.mLayerType;
        }

        @Override
        public void bind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, @Nullable Object layoutData) {
            hostView.setLayerType(hostRenderUnit.getLayerType(), null);
        }

        @Override
        public void unbind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, @Nullable Object layoutData) {
            hostView.setLayerType(0, null);
        }
    };
    public static RenderUnit.Binder<HostRenderUnit, HostView> sTouchHandlersBindFunction = new RenderUnit.Binder<HostRenderUnit, HostView>(){

        @Override
        public boolean shouldUpdate(HostRenderUnit currentValue, HostRenderUnit newValue, Object currentLayoutData, Object nextLayoutData) {
            return true;
        }

        @Override
        public void bind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, Object layoutData) {
            View.OnLongClickListener onLongClickListener;
            hostView.setOnTouchListener(hostRenderUnit.getOnTouchListener());
            hostView.setInterceptTouchEventHandler(hostRenderUnit.getOnInterceptTouchEvent());
            View.OnClickListener onClickListener = hostRenderUnit.getOnClickListener();
            if (onClickListener != null) {
                hostView.setOnClickListener(onClickListener);
            }
            if ((onLongClickListener = hostRenderUnit.getOnLongClickListener()) != null) {
                hostView.setOnLongClickListener(onLongClickListener);
            }
            View.OnFocusChangeListener onFocusChangeListener = hostRenderUnit.getOnFocusChangeListener();
            hostView.setOnFocusChangeListener(onFocusChangeListener);
            hostView.setFocusable(hostRenderUnit.isFocusable());
            hostView.setFocusableInTouchMode(hostRenderUnit.isFocusableInTouchMode());
            hostView.setEnabled(hostRenderUnit.isEnabled());
            int clickable = hostRenderUnit.getClickable();
            if (clickable != -1) {
                hostView.setClickable(clickable == 1);
            }
        }

        @Override
        public void unbind(Context context, HostView hostView, HostRenderUnit hostRenderUnit, Object layoutData) {
            hostView.setOnTouchListener(null);
            hostView.setInterceptTouchEventHandler(null);
            hostView.setOnClickListener(null);
            hostView.setClickable(false);
            hostView.setOnLongClickListener(null);
            hostView.setLongClickable(false);
            hostView.setOnFocusChangeListener(null);
            hostView.setFocusable(false);
            hostView.setFocusableInTouchMode(false);
        }
    };

    public HostRenderUnit(long id) {
        super(RenderUnit.RenderType.VIEW);
        this.mId = id;
        this.addMountUnmountExtensions(RenderUnit.Extension.extension(this, sBackgroundBindFunction), RenderUnit.Extension.extension(this, sForegroundBindFunction), RenderUnit.Extension.extension(this, sTouchHandlersBindFunction), RenderUnit.Extension.extension(this, sLayerTypeBindFunction));
    }

    @Override
    public HostView createContent(Context c) {
        return new HostView(c);
    }

    @Override
    public long getId() {
        return this.mId;
    }

    @Nullable
    public Drawable getBackground() {
        return this.mBackground;
    }

    @Nullable
    public Drawable getForeground() {
        return this.mForeground;
    }

    public int getLayerType() {
        return this.mLayerType;
    }

    public int getClickable() {
        return this.mClickable;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public View.OnTouchListener getOnTouchListener() {
        return this.mOnTouchListener;
    }

    public View.OnClickListener getOnClickListener() {
        return this.mClickListener;
    }

    public View.OnLongClickListener getOnLongClickListener() {
        return this.mLongClickListener;
    }

    public InterceptTouchHandler getOnInterceptTouchEvent() {
        return this.mInterceptTouchHandler;
    }

    public View.OnFocusChangeListener getOnFocusChangeListener() {
        return this.mOnFocusChangeListener;
    }

    public boolean isFocusable() {
        return this.mFocusable;
    }

    public boolean isFocusableInTouchMode() {
        return this.mFocusableInTouchMode;
    }

    public void setBackground(Drawable background) {
        this.mBackground = background;
    }

    public void setForeground(Drawable foreground) {
        this.mForeground = foreground;
    }

    public void setLayerType(int layerType) {
        this.mLayerType = layerType;
    }

    public void setClickable(boolean clickable) {
        this.mClickable = clickable ? 1 : 0;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public void setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        this.mFocusableInTouchMode = focusableInTouchMode;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnFocusChangeListener = onFocusChangeListener;
    }

    public void setInterceptTouchHandler(InterceptTouchHandler interceptTouchHandler) {
        this.mInterceptTouchHandler = interceptTouchHandler;
    }

    public void setLongClickListener(View.OnLongClickListener longClickListener) {
        this.mLongClickListener = longClickListener;
    }

    public void setClickListener(View.OnClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }
}

