/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.extensions;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.RenderCoreExtensionHost;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.LayoutResultVisitor;
import com.facebook.rendercore.extensions.MountExtension;
import java.util.Map;
import java.util.Set;

public class RenderCoreExtension<Input, State> {
    @Nullable
    public LayoutResultVisitor<? extends Input> getLayoutVisitor() {
        return null;
    }

    @Nullable
    public MountExtension<? extends Input, State> getMountExtension() {
        return null;
    }

    @Nullable
    public Input createInput() {
        return null;
    }

    public static void beforeMount(MountDelegateTarget mountDelegateTarget, Host host, @Nullable Map<RenderCoreExtension<?, ?>, Object> results) {
        if (results != null) {
            Rect rect = new Rect();
            host.getLocalVisibleRect(rect);
            for (Map.Entry<RenderCoreExtension<?, ?>, Object> entry : results.entrySet()) {
                Object state = entry.getValue();
                MountExtension<?, ?> extension = entry.getKey().getMountExtension();
                if (extension == null) continue;
                extension.beforeMount(mountDelegateTarget.getExtensionState(extension), state, rect);
            }
        }
    }

    public static void afterMount(MountDelegateTarget mountDelegateTarget, @Nullable Map<RenderCoreExtension<?, ?>, Object> results) {
        if (results != null) {
            for (Map.Entry<RenderCoreExtension<?, ?>, Object> entry : results.entrySet()) {
                MountExtension<?, ?> extension = entry.getKey().getMountExtension();
                if (extension == null) continue;
                extension.afterMount(mountDelegateTarget.getExtensionState(extension));
            }
        }
    }

    public static void notifyVisibleBoundsChanged(MountDelegateTarget mountDelegateTarget, Host host, Map<RenderCoreExtension<?, ?>, Object> results) {
        if (results != null) {
            Rect rect = new Rect();
            host.getLocalVisibleRect(rect);
            for (Map.Entry<RenderCoreExtension<?, ?>, Object> e : results.entrySet()) {
                ExtensionState state;
                MountExtension<?, ?> extension = e.getKey().getMountExtension();
                if (extension == null || (state = mountDelegateTarget.getExtensionState(extension)) == null) continue;
                extension.onVisibleBoundsChanged(state, rect);
            }
        }
    }

    public static boolean shouldUpdate(@Nullable Map<RenderCoreExtension<?, ?>, Object> currentResults, @Nullable Map<RenderCoreExtension<?, ?>, Object> nextResults) {
        Set<RenderCoreExtension<?, ?>> next;
        Set<RenderCoreExtension<?, ?>> current = currentResults != null ? currentResults.keySet() : null;
        Set<RenderCoreExtension<?, ?>> set = next = nextResults != null ? nextResults.keySet() : null;
        if (current == next) {
            return false;
        }
        if (current == null || next == null) {
            return true;
        }
        return !current.equals(next);
    }

    public static void recursivelyNotifyVisibleBoundsChanged(@Nullable Object content) {
        if (content instanceof RenderCoreExtensionHost) {
            RenderCoreExtensionHost host = (RenderCoreExtensionHost)content;
            host.notifyVisibleBoundsChanged();
        } else if (content instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)content;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                View child = parent.getChildAt(i);
                RenderCoreExtension.recursivelyNotifyVisibleBoundsChanged(child);
            }
        }
    }
}

