/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.extensions;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.rendercore.MountDelegate;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.ExtensionState;

public abstract class MountExtension<Input, State> {
    public final ExtensionState<State> createExtensionState(MountDelegate mountDelegate) {
        return new ExtensionState<State>(mountDelegate, this.createState());
    }

    protected abstract State createState();

    @VisibleForTesting(otherwise=4)
    public boolean canPreventMount() {
        return false;
    }

    public void beforeMount(ExtensionState<State> extensionState, Input input, @Nullable Rect localVisibleRect) {
    }

    public void beforeMountItem(ExtensionState<State> extensionState, RenderTreeNode renderTreeNode, int index) {
    }

    public void afterMount(ExtensionState<State> extensionState) {
    }

    public void onVisibleBoundsChanged(ExtensionState<State> extensionState, @Nullable Rect localVisibleRect) {
    }

    public void onUnmount(ExtensionState<State> extensionState) {
    }

    public void onUnbind(ExtensionState<State> extensionState) {
    }

    public void onBindItem(ExtensionState<State> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
    }

    public void onUnbindItem(ExtensionState<State> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
    }

    public void onUnmountItem(ExtensionState<State> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
    }

    public void onMountItem(ExtensionState<State> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
    }

    public static MountDelegateTarget getMountTarget(ExtensionState<?> extensionState) {
        return extensionState.getMountDelegate().getMountDelegateTarget();
    }

    protected static boolean isRootItem(long id) {
        return id == 0L;
    }

    protected static Object getContentAt(ExtensionState<?> extensionState, int position) {
        return extensionState.getMountDelegate().getContentAt(position);
    }

    protected static Object getContentById(ExtensionState<?> extensionState, long id) {
        return extensionState.getMountDelegate().getContentById(id);
    }

    protected static boolean isLockedForMount(ExtensionState<?> extensionState, RenderTreeNode renderTreeNode) {
        return MountExtension.isLockedForMount(extensionState, renderTreeNode.getRenderUnit().getId());
    }

    protected static boolean isLockedForMount(ExtensionState extensionState, long id) {
        return extensionState.getMountDelegate().isLockedForMount(id);
    }
}

