/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.extensions;

import androidx.annotation.Nullable;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountDelegate;
import com.facebook.rendercore.MountItem;
import java.util.HashSet;
import java.util.Set;

public class ExtensionState<State> {
    private final MountDelegate mMountDelegate;
    private final State mState;
    private final Set<Long> mLayoutOutputMountRefs = new HashSet<Long>();

    ExtensionState(MountDelegate mountDelegate, State state) {
        this.mMountDelegate = mountDelegate;
        this.mState = state;
    }

    @Nullable
    public Host getRootHost() {
        MountItem root = this.mMountDelegate.getMountDelegateTarget().getRootItem();
        if (root != null) {
            return (Host)((Object)root.getContent());
        }
        return null;
    }

    public MountDelegate getMountDelegate() {
        return this.mMountDelegate;
    }

    public State getState() {
        return this.mState;
    }

    public void releaseAllAcquiredReferences() {
        for (Long id : this.mLayoutOutputMountRefs) {
            this.mMountDelegate.releaseMountRef(id);
        }
        this.mLayoutOutputMountRefs.clear();
    }

    public void acquireMountReference(long id, boolean isMounting) {
        if (this.ownsReference(id)) {
            throw new IllegalStateException("Cannot acquire the same reference more than once.");
        }
        this.mLayoutOutputMountRefs.add(id);
        if (isMounting) {
            this.mMountDelegate.acquireAndMountRef(id);
        } else {
            this.mMountDelegate.acquireMountRef(id);
        }
    }

    public void releaseMountReference(long id, boolean isMounting) {
        if (!this.ownsReference(id)) {
            throw new IllegalStateException("Trying to release a reference that wasn't acquired.");
        }
        this.mLayoutOutputMountRefs.remove(id);
        if (isMounting) {
            this.mMountDelegate.releaseAndUnmountRef(id);
        } else {
            this.mMountDelegate.releaseMountRef(id);
        }
    }

    public boolean ownsReference(long id) {
        return this.mLayoutOutputMountRefs.contains(id);
    }
}

