/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.rendercore.HostView;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RootHost;
import com.facebook.rendercore.RootHostDelegate;

public class RootHostView
extends HostView
implements RootHost {
    private static final int[] MEASURE_OUTPUTS = new int[2];
    private final RootHostDelegate mRootHostDelegate = new RootHostDelegate(this);

    public RootHostView(Context context) {
        this(context, null);
    }

    public RootHostView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void setRenderState(@Nullable RenderState renderState) {
        this.mRootHostDelegate.setRenderState(renderState);
    }

    @Override
    public void notifyVisibleBoundsChanged() {
        this.mRootHostDelegate.notifyVisibleBoundsChanged();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRootHostDelegate.onMeasure(widthMeasureSpec, heightMeasureSpec, MEASURE_OUTPUTS)) {
            this.setMeasuredDimension(MEASURE_OUTPUTS[0], MEASURE_OUTPUTS[1]);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    void performLayout(boolean changed, int l, int t, int r, int b) {
        this.mRootHostDelegate.onLayout(changed, l, t, r, b);
        RootHostView.performLayoutOnChildrenIfNecessary(this);
    }

    @VisibleForTesting(otherwise=4)
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRootHostDelegate.detach();
    }

    @VisibleForTesting(otherwise=4)
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mRootHostDelegate.attach();
    }

    public void offsetTopAndBottom(int offset) {
        super.offsetTopAndBottom(offset);
        this.notifyVisibleBoundsChanged();
    }

    public void offsetLeftAndRight(int offset) {
        super.offsetLeftAndRight(offset);
        this.notifyVisibleBoundsChanged();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.notifyVisibleBoundsChanged();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.notifyVisibleBoundsChanged();
    }

    @Nullable
    public Object findMountContentById(long id) {
        return this.mRootHostDelegate.findMountContentById(id);
    }
}

