/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.rendercore.ErrorReporter;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.LogLevel;
import com.facebook.rendercore.MountState;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.RootHost;
import com.facebook.rendercore.extensions.RenderCoreExtension;

public class RootHostDelegate
implements RenderState.HostListener,
RootHost {
    static final int MAX_REMOUNT_RETRIES = 4;
    private static final String TAG = "RootHostDelegate";
    private final Host mHost;
    private final MountState mMountState;
    @Nullable
    private RenderState mRenderState;
    @Nullable
    private RenderTree mCurrentRenderTree;
    private boolean mDoMeasureInLayout;

    public RootHostDelegate(Host host) {
        this.mHost = host;
        this.mMountState = new MountState(this.mHost);
    }

    @Override
    @ThreadConfined(value="UI")
    public void setRenderState(RenderState renderState) {
        if (this.mRenderState == renderState) {
            return;
        }
        if (this.mRenderState != null) {
            this.mRenderState.detach();
        }
        this.mRenderState = renderState;
        if (renderState != null) {
            renderState.attach(this);
            this.onUIRenderTreeUpdated(renderState.getUIRenderTree());
        } else {
            this.onUIRenderTreeUpdated(null);
        }
    }

    @Override
    public void onUIRenderTreeUpdated(RenderTree newRenderTree) {
        if (this.mCurrentRenderTree == newRenderTree) {
            return;
        }
        if (newRenderTree == null) {
            this.mMountState.unmountAllItems();
        }
        this.mCurrentRenderTree = newRenderTree;
        this.mHost.requestLayout();
    }

    @Override
    public void notifyVisibleBoundsChanged() {
        RenderTree tree = this.mMountState.getRenderTree();
        RenderCoreExtension.notifyVisibleBoundsChanged(this.mMountState, this.mHost, tree != null ? tree.getExtensionResults() : null);
    }

    public boolean onMeasure(int widthMeasureSpec, int heightMeasureSpec, int[] measureOutput) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000 && View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            this.mDoMeasureInLayout = true;
            measureOutput[0] = width;
            measureOutput[1] = height;
            return true;
        }
        if (this.mRenderState != null) {
            this.mRenderState.measure(widthMeasureSpec, heightMeasureSpec, measureOutput);
            this.mDoMeasureInLayout = false;
            return true;
        }
        return false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mDoMeasureInLayout && this.mRenderState != null) {
            this.mRenderState.measure(View.MeasureSpec.makeMeasureSpec((int)(right - left), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(bottom - top), (int)0x40000000), null);
            this.mDoMeasureInLayout = false;
        }
        if (this.mCurrentRenderTree != null) {
            RenderTree renderTree = this.mCurrentRenderTree;
            this.mMountState.mount(renderTree);
            int retries = 0;
            while (renderTree != this.mCurrentRenderTree) {
                if (retries > 4) {
                    ErrorReporter.report(LogLevel.ERROR, TAG, "More than 4 recursive mount attempts. Skipping mounting the latest version.");
                    return;
                }
                renderTree = this.mCurrentRenderTree;
                this.mMountState.mount(renderTree);
                ++retries;
            }
        }
    }

    @Nullable
    public Object findMountContentById(long id) {
        return this.mMountState.getContentById(id);
    }

    public void detach() {
        this.mMountState.detach();
    }

    public void attach() {
        this.mMountState.attach();
    }
}

