/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Copyable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RenderUnit<MOUNT_CONTENT>
implements Copyable {
    private final RenderType mRenderType;
    @Nullable
    private Map<Class<?>, Extension<?, MOUNT_CONTENT>> mMountUnmountBinderTypeToExtensionMap;
    @Nullable
    private List<Extension<?, MOUNT_CONTENT>> mMountUnmountExtensions;
    @Nullable
    private Map<Class<?>, Extension<?, MOUNT_CONTENT>> mAttachDetachBinderTypeToExtensionMap;
    @Nullable
    private List<Extension<?, MOUNT_CONTENT>> mAttachDetachExtensions;

    public RenderUnit(RenderType renderType) {
        this(renderType, Collections.emptyList(), Collections.emptyList());
    }

    public RenderUnit(RenderType renderType, List<Extension<?, ? super MOUNT_CONTENT>> mountUnmountExtensions) {
        this(renderType, mountUnmountExtensions, Collections.emptyList());
    }

    public RenderUnit(RenderType renderType, List<Extension<?, ? super MOUNT_CONTENT>> mountUnmountExtensions, List<Extension<?, ? super MOUNT_CONTENT>> attachDetachExtensions) {
        this.mRenderType = renderType;
        for (Extension<?, MOUNT_CONTENT> extension : mountUnmountExtensions) {
            this.addMountUnmountExtension(extension);
        }
        for (Extension<?, MOUNT_CONTENT> extension : attachDetachExtensions) {
            this.addAttachDetachExtension(extension);
        }
    }

    public RenderType getRenderType() {
        return this.mRenderType;
    }

    public abstract MOUNT_CONTENT createContent(Context var1);

    public abstract long getId();

    public Object getRenderContentType() {
        return this.getClass();
    }

    protected Class getDescription() {
        return this.getClass();
    }

    @Override
    public RenderUnit makeCopy() {
        try {
            RenderUnit renderUnit = (RenderUnit)super.clone();
            if (this.mMountUnmountExtensions != null) {
                renderUnit.mMountUnmountExtensions = new ArrayList(this.mMountUnmountExtensions);
                renderUnit.mMountUnmountBinderTypeToExtensionMap = new HashMap(this.mMountUnmountBinderTypeToExtensionMap);
            }
            if (this.mAttachDetachExtensions != null) {
                renderUnit.mAttachDetachExtensions = new ArrayList(this.mAttachDetachExtensions);
                renderUnit.mAttachDetachBinderTypeToExtensionMap = new HashMap(this.mAttachDetachBinderTypeToExtensionMap);
            }
            return renderUnit;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void addMountUnmountExtension(Extension<?, ? super MOUNT_CONTENT> extension) {
        if (this.mMountUnmountExtensions == null) {
            this.mMountUnmountExtensions = new ArrayList();
            if (this.mMountUnmountBinderTypeToExtensionMap != null) {
                throw new IllegalStateException("Extension Map and Extension List out of sync!");
            }
            this.mMountUnmountBinderTypeToExtensionMap = new HashMap();
        }
        RenderUnit.addExtension(this.mMountUnmountBinderTypeToExtensionMap, this.mMountUnmountExtensions, extension);
    }

    @SafeVarargs
    public final void addMountUnmountExtensions(Extension<?, ? super MOUNT_CONTENT> ... extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            this.addMountUnmountExtension(extensions[i]);
        }
    }

    public void addAttachDetachExtension(Extension<?, ? super MOUNT_CONTENT> extension) {
        if (this.mAttachDetachExtensions == null) {
            this.mAttachDetachExtensions = new ArrayList();
            if (this.mAttachDetachBinderTypeToExtensionMap != null) {
                throw new IllegalStateException("Extension Map and Extension List out of sync!");
            }
            this.mAttachDetachBinderTypeToExtensionMap = new HashMap();
        }
        RenderUnit.addExtension(this.mAttachDetachBinderTypeToExtensionMap, this.mAttachDetachExtensions, extension);
    }

    @SafeVarargs
    public final void addAttachDetachExtensions(Extension<?, ? super MOUNT_CONTENT> ... extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            this.addAttachDetachExtension(extensions[i]);
        }
    }

    private static <MOUNT_CONTENT> void addExtension(Map<Class<?>, Extension<?, MOUNT_CONTENT>> binderTypeToExtensionMap, List<Extension<?, MOUNT_CONTENT>> extensions, Extension extension) {
        Extension prevExtension = binderTypeToExtensionMap.put(extension.binder.getClass(), extension);
        if (prevExtension != null) {
            boolean found = false;
            for (int i = extensions.size() - 1; i >= 0; --i) {
                if (((Extension)extensions.get(i)).binder.getClass() != extension.binder.getClass()) continue;
                extensions.remove(i);
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("Extension Map and Extension List out of sync!");
            }
        }
        extensions.add(extension);
    }

    void mountExtensions(Context context, MOUNT_CONTENT content, @Nullable Object layoutData) {
        RenderUnit.bind(this.mMountUnmountExtensions, context, content, layoutData);
    }

    public void unmountExtensions(Context context, MOUNT_CONTENT content, @Nullable Object layoutData) {
        RenderUnit.unbind(this.mMountUnmountExtensions, context, content, layoutData);
    }

    void attachExtensions(Context context, MOUNT_CONTENT content, @Nullable Object layoutData) {
        RenderUnit.bind(this.mAttachDetachExtensions, context, content, layoutData);
    }

    void detachExtensions(Context context, MOUNT_CONTENT content, @Nullable Object layoutData) {
        RenderUnit.unbind(this.mAttachDetachExtensions, context, content, layoutData);
    }

    void updateExtensions(Context context, MOUNT_CONTENT content, RenderUnit<MOUNT_CONTENT> currentRenderUnit, @Nullable Object currentLayoutData, @Nullable Object newLayoutData) {
        ArrayList<Extension> attachDetachExtensionsForBind = new ArrayList<Extension>(RenderUnit.sizeOrZero(this.mAttachDetachExtensions));
        ArrayList<Extension> attachDetachExtensionsForUnbind = new ArrayList<Extension>(RenderUnit.sizeOrZero(currentRenderUnit.mAttachDetachExtensions));
        ArrayList<Extension> mountUnmountExtensionsForBind = new ArrayList<Extension>(RenderUnit.sizeOrZero(this.mMountUnmountExtensions));
        ArrayList<Extension> mountUnmountExtensionsForUnbind = new ArrayList<Extension>(RenderUnit.sizeOrZero(currentRenderUnit.mMountUnmountExtensions));
        RenderUnit.resolveExtensionsToUpdate(currentRenderUnit.mAttachDetachExtensions, this.mAttachDetachExtensions, currentRenderUnit.mAttachDetachBinderTypeToExtensionMap, this.mAttachDetachBinderTypeToExtensionMap, currentLayoutData, newLayoutData, attachDetachExtensionsForBind, attachDetachExtensionsForUnbind);
        RenderUnit.resolveExtensionsToUpdate(currentRenderUnit.mMountUnmountExtensions, this.mMountUnmountExtensions, currentRenderUnit.mMountUnmountBinderTypeToExtensionMap, this.mMountUnmountBinderTypeToExtensionMap, currentLayoutData, newLayoutData, mountUnmountExtensionsForBind, mountUnmountExtensionsForUnbind);
        RenderUnit.unbind(attachDetachExtensionsForUnbind, context, content, currentLayoutData);
        RenderUnit.unbind(mountUnmountExtensionsForUnbind, context, content, currentLayoutData);
        RenderUnit.bind(mountUnmountExtensionsForBind, context, content, newLayoutData);
        RenderUnit.bind(attachDetachExtensionsForBind, context, content, newLayoutData);
    }

    private static <MOUNT_CONTENT> void resolveExtensionsToUpdate(@Nullable List<Extension<?, MOUNT_CONTENT>> currentExtensions, @Nullable List<Extension<?, MOUNT_CONTENT>> newExtensions, @Nullable Map<Class<?>, Extension<?, MOUNT_CONTENT>> currentBinderTypeToExtensionMap, @Nullable Map<Class<?>, Extension<?, MOUNT_CONTENT>> newBinderTypeToExtensionMap, @Nullable Object currentLayoutData, @Nullable Object newLayoutData, List<Extension> extensionsToBind, List<Extension> extensionsToUnbind) {
        Class<?> binderClass;
        if (currentExtensions == null || currentExtensions.isEmpty()) {
            if (newExtensions != null) {
                extensionsToBind.addAll(newExtensions);
            }
            return;
        }
        if (newExtensions == null || newExtensions.isEmpty()) {
            extensionsToUnbind.addAll(currentExtensions);
            return;
        }
        HashMap binderToShouldUpdate = new HashMap(newExtensions.size());
        for (Extension<?, MOUNT_CONTENT> newExtension : newExtensions) {
            binderClass = ((Extension)newExtension).binder.getClass();
            Extension<?, MOUNT_CONTENT> currentExtension = currentBinderTypeToExtensionMap.get(binderClass);
            if (currentExtension == null) {
                extensionsToBind.add(newExtension);
                continue;
            }
            boolean shouldUpdate = newExtension.shouldUpdate(currentExtension, currentLayoutData, newLayoutData);
            binderToShouldUpdate.put(binderClass, shouldUpdate);
            if (!shouldUpdate) continue;
            extensionsToBind.add(newExtension);
        }
        for (Extension<?, MOUNT_CONTENT> currentExtension : currentExtensions) {
            binderClass = ((Extension)currentExtension).binder.getClass();
            if (binderToShouldUpdate.containsKey(binderClass) && !((Boolean)binderToShouldUpdate.get(binderClass)).booleanValue()) continue;
            extensionsToUnbind.add(currentExtension);
        }
    }

    private static <MOUNT_CONTENT> void bind(@Nullable List<Extension> extensions, Context context, MOUNT_CONTENT content, @Nullable Object layoutData) {
        if (extensions == null) {
            return;
        }
        for (Extension extension : extensions) {
            extension.bind(context, content, layoutData);
        }
    }

    private static <MOUNT_CONTENT> void unbind(@Nullable List<Extension> extensions, Context context, MOUNT_CONTENT content, @Nullable Object layoutData) {
        if (extensions == null) {
            return;
        }
        for (int i = extensions.size() - 1; i >= 0; --i) {
            Extension extension = extensions.get(i);
            extension.unbind(context, content, layoutData);
        }
    }

    private static int sizeOrZero(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static interface Binder<MODEL, CONTENT> {
        public boolean shouldUpdate(MODEL var1, MODEL var2, @Nullable Object var3, @Nullable Object var4);

        public void bind(Context var1, CONTENT var2, MODEL var3, @Nullable Object var4);

        public void unbind(Context var1, CONTENT var2, MODEL var3, @Nullable Object var4);
    }

    public static class Extension<MODEL, CONTENT> {
        private final MODEL model;
        private final Binder<MODEL, CONTENT> binder;

        private Extension(MODEL model, Binder<MODEL, CONTENT> binder) {
            this.model = model;
            this.binder = binder;
        }

        public static <MODEL, CONTENT> Extension<MODEL, CONTENT> extension(MODEL model, Binder<MODEL, CONTENT> binder) {
            return new Extension<MODEL, CONTENT>(model, binder);
        }

        boolean shouldUpdate(Extension<MODEL, CONTENT> prevExtension, @Nullable Object currentLayoutData, @Nullable Object nextLayoutData) {
            return this.binder.shouldUpdate(prevExtension.model, this.model, currentLayoutData, nextLayoutData);
        }

        void bind(Context context, CONTENT content, @Nullable Object layoutData) {
            this.binder.bind(context, content, this.model, layoutData);
        }

        void unbind(Context context, CONTENT content, @Nullable Object layoutData) {
            this.binder.unbind(context, content, this.model, layoutData);
        }
    }

    public static enum RenderType {
        DRAWABLE,
        VIEW;

    }
}

