/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.rendercore.RenderUnit;
import java.util.ArrayList;
import java.util.List;

@DoNotStrip
public class RenderTreeNode {
    private static final int DEFAULT_SIZE = 4;
    @Nullable
    private final RenderTreeNode mParent;
    private final RenderUnit mRenderUnit;
    @Nullable
    private final Object mLayoutData;
    private final Rect mBounds;
    private final int mAbsoluteX;
    private final int mAbsoluteY;
    @Nullable
    private final Rect mResolvedPadding;
    final int mPositionInParent;
    private List<RenderTreeNode> mChildren;

    public RenderTreeNode(@Nullable RenderTreeNode parent, RenderUnit renderUnit, @Nullable Object layoutData, Rect bounds, @Nullable Rect resolvedPadding, int positionInParent) {
        this.mParent = parent;
        this.mRenderUnit = renderUnit;
        this.mLayoutData = layoutData;
        this.mBounds = bounds;
        this.mAbsoluteX = parent != null ? parent.getAbsoluteX() + bounds.left : 0;
        this.mAbsoluteY = parent != null ? parent.getAbsoluteY() + bounds.top : 0;
        this.mResolvedPadding = resolvedPadding;
        this.mPositionInParent = positionInParent;
    }

    public void child(RenderTreeNode renderTreeNode) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<RenderTreeNode>(4);
        }
        this.mChildren.add(renderTreeNode);
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    int getAbsoluteX() {
        return this.mAbsoluteX;
    }

    int getAbsoluteY() {
        return this.mAbsoluteY;
    }

    public Rect getAbsoluteBounds(Rect outRect) {
        outRect.left = this.mAbsoluteX;
        outRect.top = this.mAbsoluteY;
        outRect.right = this.mAbsoluteX + this.mBounds.width();
        outRect.bottom = this.mAbsoluteY + this.mBounds.height();
        return outRect;
    }

    @Nullable
    public Rect getResolvedPadding() {
        return this.mResolvedPadding;
    }

    public RenderUnit getRenderUnit() {
        return this.mRenderUnit;
    }

    @Nullable
    public RenderTreeNode getParent() {
        return this.mParent;
    }

    public int getChildrenCount() {
        return this.mChildren != null ? this.mChildren.size() : 0;
    }

    public RenderTreeNode getChildAt(int idx) {
        return this.mChildren.get(idx);
    }

    public int getPositionInParent() {
        return this.mPositionInParent;
    }

    @Nullable
    public Object getLayoutData() {
        return this.mLayoutData;
    }
}

