/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.rendercore.ErrorReporter;
import com.facebook.rendercore.HostView;
import com.facebook.rendercore.LogLevel;
import com.facebook.rendercore.MountState;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.RenderTreeHost;
import com.facebook.rendercore.extensions.RenderCoreExtension;

public class RenderTreeHostView
extends HostView
implements RenderTreeHost {
    private static final String TAG = "RenderTreeHostView";
    private final MountState mMountState = new MountState(this);
    @Nullable
    private RenderTree mCurrentRenderTree;

    public RenderTreeHostView(Context context) {
        this(context, null);
    }

    public RenderTreeHostView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mCurrentRenderTree == null) {
            this.setMeasuredDimension(0, 0);
        } else {
            this.setMeasuredDimension(this.mCurrentRenderTree.getWidth(), this.mCurrentRenderTree.getHeight());
        }
    }

    @Override
    void performLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mCurrentRenderTree != null) {
            RenderTree renderTree = this.mCurrentRenderTree;
            this.mMountState.mount(renderTree);
            int retries = 0;
            while (renderTree != this.mCurrentRenderTree) {
                if (retries > 4) {
                    ErrorReporter.report(LogLevel.ERROR, TAG, "More than 4 recursive mount attempts. Skipping mounting the latest version.");
                    return;
                }
                renderTree = this.mCurrentRenderTree;
                this.mMountState.mount(renderTree);
                ++retries;
            }
        }
        RenderTreeHostView.performLayoutOnChildrenIfNecessary(this);
    }

    @Override
    public void setRenderTree(@Nullable RenderTree tree) {
        if (this.mCurrentRenderTree == tree) {
            return;
        }
        if (tree == null) {
            this.mMountState.unmountAllItems();
        }
        this.mCurrentRenderTree = tree;
        this.requestLayout();
    }

    @VisibleForTesting(otherwise=4)
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mMountState.detach();
    }

    @VisibleForTesting(otherwise=4)
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mMountState.attach();
    }

    @Override
    public void notifyVisibleBoundsChanged() {
        RenderTree tree = this.mMountState.getRenderTree();
        RenderCoreExtension.notifyVisibleBoundsChanged(this.mMountState, this, tree != null ? tree.getExtensionResults() : null);
    }

    public void offsetTopAndBottom(int offset) {
        super.offsetTopAndBottom(offset);
        this.notifyVisibleBoundsChanged();
    }

    public void offsetLeftAndRight(int offset) {
        super.offsetLeftAndRight(offset);
        this.notifyVisibleBoundsChanged();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.notifyVisibleBoundsChanged();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.notifyVisibleBoundsChanged();
    }
}

