/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import androidx.annotation.Nullable;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import java.util.Map;

public class RenderTree {
    private final RenderTreeNode mRoot;
    private final RenderTreeNode[] mFlatList;
    private final int mWidthSpec;
    private final int mHeightSpec;
    @Nullable
    private final Map<RenderCoreExtension<?, ?>, Object> mResults;
    @Nullable
    private Object mRenderTreeData;

    public RenderTree(RenderTreeNode root, RenderTreeNode[] flatList, int widthSpec, int heightSpec, @Nullable Map<RenderCoreExtension<?, ?>, Object> results) {
        this.mRoot = root;
        this.mFlatList = flatList;
        this.mWidthSpec = widthSpec;
        this.mHeightSpec = heightSpec;
        this.mResults = results;
    }

    public int getWidth() {
        return this.mRoot.getBounds().width();
    }

    public int getHeight() {
        return this.mRoot.getBounds().height();
    }

    public int getWidthSpec() {
        return this.mWidthSpec;
    }

    public int getHeightSpec() {
        return this.mHeightSpec;
    }

    public int getRenderTreeNodeIndex(long renderUnitId) {
        for (int i = 0; i < this.mFlatList.length; ++i) {
            if (this.mFlatList[i].getRenderUnit().getId() != renderUnitId) continue;
            return i;
        }
        return -1;
    }

    public RenderTreeNode getRenderTreeNodeAtIndex(int index) {
        return this.mFlatList[index];
    }

    public int getMountableOutputCount() {
        return this.mFlatList.length;
    }

    @Nullable
    public Map<RenderCoreExtension<?, ?>, Object> getExtensionResults() {
        return this.mResults;
    }

    @Nullable
    public Object getRenderTreeData() {
        return this.mRenderTreeData;
    }

    public void setRenderTreeData(Object renderTreeData) {
        this.mRenderTreeData = renderTreeData;
    }

    public RenderTreeNode getRoot() {
        return this.mRoot;
    }
}

