/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.rendercore.LayoutCache;
import com.facebook.rendercore.Node;
import com.facebook.rendercore.RenderResult;
import com.facebook.rendercore.RenderResultFuture;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.utils.MeasureSpecUtils;
import com.facebook.rendercore.utils.ThreadUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class RenderState<State, RenderContext> {
    private static final int UNSET = -1;
    private static final int PROMOTION_MESSAGE = 99;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final RenderStateHandler mUIHandler = new RenderStateHandler(Looper.getMainLooper());
    private final Context mContext;
    private final Delegate<State> mDelegate;
    @Nullable
    private final RenderContext mRenderContext;
    @Nullable
    private final RenderCoreExtension<?, ?>[] mExtensions;
    private final int mId = ID_GENERATOR.incrementAndGet();
    @ThreadConfined(value="UI")
    @Nullable
    private HostListener mHostListener;
    @Nullable
    private RenderResult<State> mUIRenderResult;
    @Nullable
    private RenderResult<State> mCommittedRenderResult;
    @Nullable
    private LazyTree<State> mLatestLazyTree;
    private int mExternalRootVersion = -1;
    @Nullable
    private RenderResultFuture<State, RenderContext> mRenderResultFuture;
    private int mNextSetRootId = 0;
    private int mCommittedSetRootId = -1;
    private int mWidthSpec = -1;
    private int mHeightSpec = -1;

    public RenderState(Context context, Delegate<State> delegate, @Nullable RenderContext renderContext, @Nullable RenderCoreExtension<?, ?>[] extensions) {
        this.mContext = context;
        this.mDelegate = delegate;
        this.mRenderContext = renderContext;
        this.mExtensions = extensions;
    }

    @ThreadConfined(value="ANY")
    public void setVersionedTree(LazyTree<State> lazyTree, int version, int widthSpec, int heightSpec, @Nullable int[] measureOutput) {
        this.setTreeInternal(lazyTree, version, widthSpec, heightSpec, measureOutput);
    }

    @ThreadConfined(value="ANY")
    public void setTree(LazyTree<State> lazyTree) {
        this.setTreeInternal(lazyTree, -1, -1, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTreeInternal(LazyTree<State> lazyTree, int version, int widthSpec, int heightSpec, @Nullable int[] measureOutput) {
        RenderResultFuture<State, RenderContext> future;
        int setRootId;
        RenderResult<State> previousRenderResult;
        RenderState renderState = this;
        synchronized (renderState) {
            if (version > -1) {
                if (this.mExternalRootVersion > version) {
                    return;
                }
            } else if (this.mExternalRootVersion > -1) {
                throw new IllegalStateException("Setting an unversioned tree after calling setVersionedTree is not supported. If this RenderState takes its version from a parent tree make sure to always call setVersionedTree");
            }
            previousRenderResult = this.mCommittedRenderResult;
            this.mExternalRootVersion = version;
            this.mLatestLazyTree = lazyTree;
            if (widthSpec != -1) {
                this.mWidthSpec = widthSpec;
            }
            if (heightSpec != -1) {
                this.mHeightSpec = heightSpec;
            }
            if (this.mWidthSpec == -1 || this.mHeightSpec == -1) {
                return;
            }
            setRootId = this.mNextSetRootId++;
            future = new RenderResultFuture<State, RenderContext>(this.mContext, lazyTree, this.mRenderContext, this.mExtensions, this.mCommittedRenderResult, setRootId, this.mWidthSpec, this.mHeightSpec);
            this.mRenderResultFuture = future;
        }
        RenderResult<State> result = future.runAndGet();
        boolean committedNewLayout = false;
        RenderState renderState2 = this;
        synchronized (renderState2) {
            if (setRootId > this.mCommittedSetRootId) {
                this.mCommittedSetRootId = setRootId;
                this.mCommittedRenderResult = result;
                committedNewLayout = true;
            }
            if (measureOutput != null && this.mCommittedRenderResult != null) {
                measureOutput[0] = this.mCommittedRenderResult.getRenderTree().getWidth();
                measureOutput[1] = this.mCommittedRenderResult.getRenderTree().getHeight();
            }
            if (this.mRenderResultFuture == future) {
                this.mRenderResultFuture = null;
            }
        }
        if (committedNewLayout) {
            this.mDelegate.commit(setRootId, previousRenderResult != null ? previousRenderResult.getRenderTree() : null, result.getRenderTree(), previousRenderResult != null ? (Object)previousRenderResult.getState() : null, result.getState());
            this.schedulePromoteCommittedTreeToUI();
        }
    }

    @ThreadConfined(value="UI")
    public void measure(int widthSpec, int heightSpec, @Nullable int[] measureOutput) {
        if (this.mUIRenderResult != null && this.hasCompatibleSize(this.mUIRenderResult.getRenderTree(), widthSpec, heightSpec)) {
            if (measureOutput != null) {
                measureOutput[0] = this.mUIRenderResult.getRenderTree().getWidth();
                measureOutput[1] = this.mUIRenderResult.getRenderTree().getHeight();
            }
            return;
        }
        this.measureImpl(widthSpec, heightSpec, measureOutput);
    }

    @ThreadConfined(value="ANY")
    public void preMeasure(int widthSpec, int heightSpec, int[] measureOutput) {
        this.measureImpl(widthSpec, heightSpec, measureOutput);
    }

    @ThreadConfined(value="UI")
    public void attach(HostListener hostListener) {
        if (this.mHostListener != null && this.mHostListener != hostListener) {
            throw new RuntimeException("Must detach from previous host listener first");
        }
        this.mHostListener = hostListener;
    }

    @ThreadConfined(value="UI")
    public void detach() {
        this.mHostListener = null;
    }

    @ThreadConfined(value="UI")
    @Nullable
    public RenderTree getUIRenderTree() {
        return this.mUIRenderResult != null ? this.mUIRenderResult.getRenderTree() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void measureImpl(int widthSpec, int heightSpec, @Nullable int[] measureOutput) {
        int setRootId;
        RenderResultFuture<State, RenderContext> future;
        RenderResult<State> previousResult;
        RenderState renderState = this;
        synchronized (renderState) {
            this.mWidthSpec = widthSpec;
            this.mHeightSpec = heightSpec;
            previousResult = this.mCommittedRenderResult;
            if (this.mCommittedRenderResult != null && this.hasCompatibleSize(this.mCommittedRenderResult.getRenderTree(), widthSpec, heightSpec) && measureOutput != null) {
                measureOutput[0] = this.mCommittedRenderResult.getRenderTree().getWidth();
                measureOutput[1] = this.mCommittedRenderResult.getRenderTree().getHeight();
                return;
            }
            if (this.mRenderResultFuture != null && this.hasSameSpecs(this.mRenderResultFuture, widthSpec, heightSpec)) {
                future = this.mRenderResultFuture;
                setRootId = future.getSetRootId();
            } else {
                setRootId = this.mNextSetRootId++;
                future = new RenderResultFuture<State, RenderContext>(this.mContext, this.mLatestLazyTree, this.mRenderContext, this.mExtensions, this.mCommittedRenderResult, setRootId, this.mWidthSpec, this.mHeightSpec);
                this.mRenderResultFuture = future;
            }
        }
        RenderResult<State> result = future.runAndGet();
        boolean committedNewLayout = false;
        RenderState renderState2 = this;
        synchronized (renderState2) {
            if (setRootId > this.mCommittedSetRootId) {
                this.mCommittedSetRootId = setRootId;
                this.mCommittedRenderResult = result;
                committedNewLayout = true;
            }
            if (this.mRenderResultFuture == future) {
                this.mRenderResultFuture = null;
            }
            if (measureOutput != null) {
                measureOutput[0] = this.mCommittedRenderResult.getRenderTree().getWidth();
                measureOutput[1] = this.mCommittedRenderResult.getRenderTree().getHeight();
            }
        }
        if (committedNewLayout) {
            this.mDelegate.commit(setRootId, previousResult != null ? previousResult.getRenderTree() : null, result.getRenderTree(), previousResult != null ? (Object)previousResult.getState() : null, result.getState());
            this.schedulePromoteCommittedTreeToUI();
        }
    }

    private void schedulePromoteCommittedTreeToUI() {
        if (ThreadUtils.isMainThread()) {
            this.promoteCommittedTreeToUI();
        } else if (!this.mUIHandler.hasMessages(99)) {
            this.mUIHandler.sendEmptyMessage(99);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    private void promoteCommittedTreeToUI() {
        RenderState renderState = this;
        synchronized (renderState) {
            this.mDelegate.commitToUI(this.mCommittedRenderResult.getRenderTree(), this.mCommittedRenderResult.getState());
            this.mUIRenderResult = this.mCommittedRenderResult;
        }
        if (this.mHostListener != null) {
            this.mHostListener.onUIRenderTreeUpdated(this.mUIRenderResult.getRenderTree());
        }
    }

    private boolean hasCompatibleSize(RenderTree tree, int widthSpec, int heightSpec) {
        return MeasureSpecUtils.isMeasureSpecCompatible(tree.getWidthSpec(), widthSpec, tree.getWidth()) && MeasureSpecUtils.isMeasureSpecCompatible(tree.getHeightSpec(), heightSpec, tree.getHeight());
    }

    private boolean hasSameSpecs(RenderResultFuture<State, RenderContext> future, int widthSpec, int heightSpec) {
        return MeasureSpecUtils.areMeasureSpecsEquivalent(future.getWidthSpec(), widthSpec) && MeasureSpecUtils.areMeasureSpecsEquivalent(future.getHeightSpec(), heightSpec);
    }

    public int getId() {
        return this.mId;
    }

    @Nullable
    RenderCoreExtension<?, ?>[] getExtensions() {
        return this.mExtensions;
    }

    public static class LayoutContext<RenderContext> {
        private final Context androidContext;
        private final int layoutVersion;
        @Nullable
        private LayoutCache layoutCache;
        @Nullable
        private final RenderContext mRenderContext;
        @Nullable
        private final RenderCoreExtension<?, ?>[] extensions;

        @VisibleForTesting(otherwise=3)
        public LayoutContext(Context androidContext, @Nullable RenderContext renderContext, int layoutVersion, LayoutCache layoutCache, @Nullable RenderCoreExtension<?, ?>[] extensions) {
            this.androidContext = androidContext;
            this.layoutVersion = layoutVersion;
            this.layoutCache = layoutCache;
            this.mRenderContext = renderContext;
            this.extensions = extensions;
        }

        @Nullable
        public RenderContext getRenderContext() {
            return this.mRenderContext;
        }

        public Context getAndroidContext() {
            return this.androidContext;
        }

        public int getLayoutVersion() {
            return this.layoutVersion;
        }

        public LayoutCache getLayoutCache() {
            if (this.layoutCache == null) {
                throw new IllegalStateException("Trying to access the LayoutCache from outside a layout call");
            }
            return this.layoutCache;
        }

        void clearCache() {
            this.layoutCache = null;
        }

        @Nullable
        RenderCoreExtension<?, ?>[] getExtensions() {
            return this.extensions;
        }
    }

    private class RenderStateHandler
    extends Handler {
        public RenderStateHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 99: {
                    RenderState.this.promoteCommittedTreeToUI();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message: " + msg.what);
                }
            }
        }
    }

    public static interface HostListener {
        public void onUIRenderTreeUpdated(RenderTree var1);
    }

    public static interface Delegate<State> {
        public void commit(int var1, RenderTree var2, RenderTree var3, State var4, State var5);

        public void commitToUI(RenderTree var1, State var2);
    }

    public static interface LazyTree<State> {
        public Pair<Node, State> resolve();
    }
}

