/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.os.Process;
import androidx.annotation.Nullable;
import com.facebook.rendercore.RenderResult;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.utils.ThreadUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;

public class RenderResultFuture<State, RenderContext> {
    private final RenderState.LazyTree<State> mLazyTree;
    private final RenderResult<State> mPreviousResult;
    private final int mSetRootId;
    private final int mWidthSpec;
    private final int mHeightSpec;
    private final FutureTask<RenderResult<State>> mFutureTask;
    private final AtomicInteger mRunningThreadId = new AtomicInteger(-1);

    public RenderResultFuture(final Context context, RenderState.LazyTree<State> lazyTree, final @Nullable RenderContext renderContext, final @Nullable RenderCoreExtension<?, ?>[] extensions, @Nullable RenderResult<State> previousResult, int setRootId, int widthSpec, int heightSpec) {
        this.mLazyTree = lazyTree;
        this.mPreviousResult = previousResult;
        this.mSetRootId = setRootId;
        this.mWidthSpec = widthSpec;
        this.mHeightSpec = heightSpec;
        this.mFutureTask = new FutureTask(new Callable<RenderResult<State>>(){

            @Override
            public RenderResult<State> call() {
                return RenderResult.resolve(context, RenderResultFuture.this.mLazyTree, renderContext, extensions, RenderResultFuture.this.mPreviousResult, RenderResultFuture.this.mSetRootId, RenderResultFuture.this.mWidthSpec, RenderResultFuture.this.mHeightSpec);
            }
        });
    }

    public RenderResult<State> runAndGet() {
        if (this.mRunningThreadId.compareAndSet(-1, Process.myTid())) {
            this.mFutureTask.run();
            try {
                return this.mFutureTask.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
        return ThreadUtils.getResultInheritingPriority(this.mFutureTask, this.mRunningThreadId.get());
    }

    public boolean isDone() {
        return this.mFutureTask.isDone();
    }

    public boolean isRunning() {
        return this.mRunningThreadId.get() != -1;
    }

    public void cancel() {
        this.mFutureTask.cancel(false);
    }

    public boolean isCanceled() {
        return this.mFutureTask.isCancelled();
    }

    public int getSetRootId() {
        return this.mSetRootId;
    }

    public int getWidthSpec() {
        return this.mWidthSpec;
    }

    public int getHeightSpec() {
        return this.mHeightSpec;
    }
}

