/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.rendercore.LayoutCache;
import com.facebook.rendercore.Node;
import com.facebook.rendercore.Reducer;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.utils.MeasureSpecUtils;

public class RenderResult<State> {
    private final RenderTree mRenderTree;
    private final RenderState.LazyTree mLazyTree;
    private final Node mNodeTree;
    private final LayoutCache mLayoutCache;
    @Nullable
    private final State mState;

    public static <State, RenderContext> RenderResult<State> resolve(Context context, RenderState.LazyTree<State> lazyTree, @Nullable RenderContext renderContext, @Nullable RenderCoreExtension<?, ?>[] extensions, @Nullable RenderResult<State> previousResult, int layoutVersion, int widthSpec, int heightSpec) {
        RenderResult<Object> renderResult;
        Node previousTree = previousResult != null ? previousResult.getNodeTree() : null;
        Object previousState = previousResult != null ? previousResult.getState() : null;
        RenderCoreSystrace.beginSection("RC Create Tree");
        Pair result = previousResult != null && lazyTree == previousResult.getLazyTree() ? new Pair((Object)previousTree, previousState) : lazyTree.resolve();
        if (RenderResult.shouldReuseResult((Node)result.first, widthSpec, heightSpec, previousResult)) {
            renderResult = new RenderResult<Object>(previousResult.getRenderTree(), lazyTree, (Node)result.first, previousResult.getLayoutCache(), result.second);
        } else {
            RenderCoreSystrace.beginSection("RC Layout");
            LayoutCache layoutCache = RenderResult.buildCache(previousResult == null ? null : previousResult.getLayoutCache());
            RenderState.LayoutContext<RenderContext> layoutContext = new RenderState.LayoutContext<RenderContext>(context, renderContext, layoutVersion, layoutCache, extensions);
            Node.LayoutResult layoutResult = ((Node)result.first).calculateLayout(layoutContext, widthSpec, heightSpec);
            RenderCoreSystrace.endSection();
            RenderCoreSystrace.beginSection("RC Reduce");
            renderResult = RenderResult.create(layoutContext, (Node)result.first, layoutResult, lazyTree, widthSpec, heightSpec, result.second);
            RenderCoreSystrace.endSection();
            layoutContext.clearCache();
        }
        RenderCoreSystrace.endSection();
        return renderResult;
    }

    public static <State> RenderResult<State> create(RenderState.LayoutContext c, Node node, Node.LayoutResult layoutResult, RenderState.LazyTree<State> lazyTree, int widthSpec, int heightSpec, @Nullable State state) {
        return new RenderResult<State>(Reducer.getReducedTree(c.getAndroidContext(), layoutResult, widthSpec, heightSpec, c.getExtensions()), lazyTree, node, c.getLayoutCache(), state);
    }

    public static <State> boolean shouldReuseResult(Node node, int widthSpec, int heightSpec, @Nullable RenderResult<State> previousResult) {
        if (previousResult == null) {
            return false;
        }
        RenderTree prevRenderTree = previousResult.getRenderTree();
        return previousResult.getRenderTree() != null && node == previousResult.getNodeTree() && MeasureSpecUtils.isMeasureSpecCompatible(prevRenderTree.getWidthSpec(), widthSpec, prevRenderTree.getWidth()) && MeasureSpecUtils.isMeasureSpecCompatible(prevRenderTree.getHeightSpec(), heightSpec, prevRenderTree.getHeight());
    }

    private RenderResult(RenderTree renderTree, RenderState.LazyTree lazyTree, Node nodeTree, LayoutCache layoutCache, @Nullable State state) {
        this.mRenderTree = renderTree;
        this.mLazyTree = lazyTree;
        this.mNodeTree = nodeTree;
        this.mLayoutCache = layoutCache;
        this.mState = state;
    }

    public RenderTree getRenderTree() {
        return this.mRenderTree;
    }

    RenderState.LazyTree getLazyTree() {
        return this.mLazyTree;
    }

    Node getNodeTree() {
        return this.mNodeTree;
    }

    LayoutCache getLayoutCache() {
        return this.mLayoutCache;
    }

    @Nullable
    public State getState() {
        return this.mState;
    }

    @VisibleForTesting
    public static LayoutCache buildCache(@Nullable LayoutCache previousCache) {
        return previousCache != null ? new LayoutCache(previousCache) : new LayoutCache(null);
    }

    public static RenderState.LazyTree<Void> wrapInLazyTree(final Node node) {
        return new RenderState.LazyTree<Void>(){

            @Override
            public Pair<Node, Void> resolve() {
                return new Pair((Object)node, null);
            }
        };
    }
}

