/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.graphics.Rect;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.facebook.rendercore.Node;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.LayoutResultVisitor;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import java.util.ArrayList;
import java.util.Map;

public class Reducer {
    public static final RenderUnit sRootHostRenderUnit = new RenderUnit(RenderUnit.RenderType.VIEW){

        public Object createContent(Context c) {
            return null;
        }

        @Override
        public long getId() {
            return 0L;
        }
    };

    private static void reduceTree(Context context, Node.LayoutResult<?> layoutResult, RenderTreeNode parent, int x, int y, ArrayList<RenderTreeNode> flattenedTree, @Nullable Map<RenderCoreExtension<?, ?>, Object> extensions) {
        int yTranslation;
        int xTranslation;
        RenderTreeNode nextParent;
        if (layoutResult.getWidth() == 0 && layoutResult.getHeight() == 0) {
            return;
        }
        Rect bounds = new Rect(x, y, x + layoutResult.getWidth(), y + layoutResult.getHeight());
        int absoluteX = parent.getAbsoluteX() + x;
        int absoluteY = parent.getAbsoluteY() + y;
        Reducer.visit(parent, layoutResult, bounds, absoluteX, absoluteY, flattenedTree.size(), extensions);
        RenderUnit renderUnit = layoutResult.getRenderUnit();
        if (renderUnit != null && layoutResult.getChildrenCount() > 0) {
            RenderTreeNode node = Reducer.createRenderTreeNode(layoutResult, renderUnit, bounds, parent);
            flattenedTree.add(node);
            parent.child(node);
            nextParent = node;
            xTranslation = 0;
            yTranslation = 0;
        } else if (renderUnit != null) {
            RenderTreeNode content = Reducer.createRenderTreeNode(layoutResult, renderUnit, bounds, parent);
            flattenedTree.add(content);
            parent.child(content);
            nextParent = parent;
            xTranslation = 0;
            yTranslation = 0;
        } else {
            nextParent = parent;
            xTranslation = x;
            yTranslation = y;
        }
        for (int i = 0; i < layoutResult.getChildrenCount(); ++i) {
            Reducer.reduceTree(context, layoutResult.getChildAt(i), nextParent, layoutResult.getXForChildAtIndex(i) + xTranslation, layoutResult.getYForChildAtIndex(i) + yTranslation, flattenedTree, extensions);
        }
    }

    private static RenderTreeNode createRenderTreeNode(Node.LayoutResult<?> layoutResult, RenderUnit<?> renderUnit, Rect bounds, @Nullable RenderTreeNode parent) {
        boolean hasPadding = layoutResult.getPaddingLeft() != 0 || layoutResult.getPaddingTop() != 0 || layoutResult.getPaddingRight() != 0 || layoutResult.getPaddingBottom() != 0;
        Rect padding = hasPadding ? new Rect(layoutResult.getPaddingLeft(), layoutResult.getPaddingTop(), layoutResult.getPaddingRight(), layoutResult.getPaddingBottom()) : null;
        RenderTreeNode renderTreeNode = new RenderTreeNode(parent, renderUnit, layoutResult.getLayoutData(), bounds, padding, parent != null ? parent.getChildrenCount() : 0);
        return renderTreeNode;
    }

    public static RenderTree getReducedTree(Context context, Node.LayoutResult<?> layoutResult, int widthSpec, int heightSpec, @Nullable RenderCoreExtension<?, ?>[] extensions) {
        RenderCoreSystrace.beginSection("Reducer.reduceTree");
        Map<RenderCoreExtension<?, ?>, Object> results = Reducer.populate(extensions);
        ArrayList<RenderTreeNode> nodes = new ArrayList<RenderTreeNode>();
        Rect bounds = new Rect(0, 0, layoutResult.getWidth(), layoutResult.getHeight());
        Reducer.visit(null, layoutResult, bounds, 0, 0, 0, results);
        RenderTreeNode root = Reducer.createRenderTreeNode(layoutResult, sRootHostRenderUnit, bounds, null);
        nodes.add(root);
        Reducer.reduceTree(context, layoutResult, root, 0, 0, nodes, results);
        RenderTreeNode[] nodesArray = nodes.toArray(new RenderTreeNode[nodes.size()]);
        RenderCoreSystrace.endSection();
        return new RenderTree(root, nodesArray, widthSpec, heightSpec, results);
    }

    @Nullable
    private static Map<RenderCoreExtension<?, ?>, Object> populate(@Nullable RenderCoreExtension<?, ?>[] extensions) {
        if (extensions == null || extensions.length == 0) {
            return null;
        }
        ArrayMap results = new ArrayMap(extensions.length);
        for (int i = 0; i < extensions.length; ++i) {
            Object input = extensions[i].createInput();
            results.put(extensions[i], input);
        }
        return results;
    }

    private static void visit(@Nullable RenderTreeNode parent, Node.LayoutResult<?> result, Rect bounds, int absoluteX, int absoluteY, int size, @Nullable Map<RenderCoreExtension<?, ?>, Object> extensions) {
        if (extensions != null) {
            for (Map.Entry<RenderCoreExtension<?, ?>, Object> entry : extensions.entrySet()) {
                RenderCoreExtension<?, ?> e = entry.getKey();
                LayoutResultVisitor<?> visitor = e.getLayoutVisitor();
                if (visitor == null) continue;
                Object state = entry.getValue();
                visitor.visit(parent, result, bounds, absoluteX, absoluteY, size, state);
            }
        }
    }
}

