/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.graphics.drawable.Drawable;
import android.view.View;

class MountUtils {
    MountUtils() {
    }

    static <T> void moveItem(int oldIndex, int newIndex, T[] items, T[] scrapItems) {
        T itemToMove;
        if (MountUtils.existsScrapItemAt(oldIndex, scrapItems)) {
            itemToMove = scrapItems[oldIndex];
            scrapItems[oldIndex] = null;
        } else {
            itemToMove = items[oldIndex];
            items[oldIndex] = null;
        }
        items[newIndex] = itemToMove;
    }

    static <T> void scrapItemAt(int index, T[] items, T[] scrapItems) {
        if (items == null || scrapItems == null) {
            return;
        }
        T value = items[index];
        if (value != null) {
            scrapItems[index] = value;
        }
    }

    static <T> boolean existsScrapItemAt(int index, T[] scrapItems) {
        return scrapItems != null && scrapItems[index] != null;
    }

    static void maybeSetDrawableState(View view, Drawable drawable) {
        if (drawable.isStateful()) {
            drawable.setState(view.getDrawableState());
        }
    }

    static <T> void removeItem(int index, T[] items, T[] scrapItems) {
        if (MountUtils.existsScrapItemAt(index, scrapItems)) {
            scrapItems[index] = null;
        } else {
            items[index] = null;
        }
    }

    static void mountDrawable(View view, Drawable drawable) {
        drawable.setVisible(view.getVisibility() == 0, false);
        drawable.setCallback((Drawable.Callback)view);
        MountUtils.maybeSetDrawableState(view, drawable);
    }
}

