/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.HostNotMountedException;
import com.facebook.rendercore.MountDelegate;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.MountItemsPool;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.UnmountDelegateExtension;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.utils.BoundsUtils;
import java.util.ArrayList;
import java.util.Map;

public class MountState
implements MountDelegateTarget {
    public static final long ROOT_HOST_ID = 0L;
    private final LongSparseArray<MountItem> mIndexToMountedItemMap = new LongSparseArray();
    private final Context mContext;
    private final Host mRootHost;
    @Nullable
    private long[] mRenderUnitIds;
    private boolean mIsMounting;
    private boolean mNeedsRemount;
    private RenderTree mRenderTree;
    @Nullable
    private MountDelegate mMountDelegate;
    @Nullable
    private UnmountDelegateExtension mUnmountDelegateExtension;

    public MountState(Host rootHost) {
        this.mContext = rootHost.getContext();
        this.mRootHost = rootHost;
    }

    @Override
    public boolean needsRemount() {
        return this.mNeedsRemount;
    }

    @Override
    public void notifyMount(long id) {
        if (this.mRenderTree == null) {
            return;
        }
        int position = this.mRenderTree.getRenderTreeNodeIndex(id);
        if (this.getItemAt(position) != null) {
            return;
        }
        RenderTreeNode node = this.mRenderTree.getRenderTreeNodeAtIndex(position);
        this.mountRenderUnit(position, node);
    }

    @Override
    public void notifyUnmount(long id) {
        if (this.mIndexToMountedItemMap == null) {
            return;
        }
        MountItem mountItem = (MountItem)this.mIndexToMountedItemMap.get(id);
        if (mountItem != null) {
            this.unmountItemRecursively(mountItem.getRenderTreeNode());
        }
    }

    @Override
    public void mount(RenderTree renderTree) {
        if (renderTree == null) {
            throw new IllegalStateException("Trying to mount a null RenderTreeNode");
        }
        if (this.mIsMounting) {
            throw new IllegalStateException("Trying to mount while already mounting!");
        }
        if (!this.updateRenderTree(renderTree)) {
            return;
        }
        RenderCoreSystrace.beginSection("MountState.mount");
        this.mIsMounting = true;
        RenderCoreSystrace.beginSection("RenderCoreExtension.beforeMount");
        RenderCoreExtension.beforeMount(this, this.mRootHost, this.mRenderTree.getExtensionResults());
        RenderCoreSystrace.endSection();
        RenderCoreSystrace.beginSection("MountState.prepareMount");
        this.prepareMount();
        RenderCoreSystrace.endSection();
        int size = renderTree.getMountableOutputCount();
        for (int i = 1; i < size; ++i) {
            boolean isMounted;
            RenderTreeNode renderTreeNode = renderTree.getRenderTreeNodeAtIndex(i);
            boolean isMountable = this.isMountable(renderTreeNode, i);
            MountItem currentMountItem = this.getItemAt(i);
            boolean bl = isMounted = currentMountItem != null;
            if (!isMountable) {
                if (!isMounted) continue;
                this.unmountItemRecursively(renderTreeNode);
                continue;
            }
            if (!isMounted) {
                RenderCoreSystrace.beginSection("MountItem: ", renderTreeNode.getRenderUnit().getDescription());
                this.mountRenderUnit(i, renderTreeNode);
                RenderCoreSystrace.endSection();
                continue;
            }
            MountState.updateMountItemIfNeeded(this.mContext, renderTreeNode, currentMountItem);
        }
        this.mNeedsRemount = false;
        this.mIsMounting = false;
        RenderCoreSystrace.endSection();
        RenderCoreSystrace.beginSection("RenderCoreExtension.afterMount");
        RenderCoreExtension.afterMount(this, this.mRenderTree.getExtensionResults());
        RenderCoreSystrace.endSection();
    }

    @Override
    public void unmountAllItems() {
        this.unregisterAllExtensions();
        if (this.mRenderUnitIds == null) {
            return;
        }
        RenderTreeNode rootRenderTreeNode = this.mRenderTree.getRoot();
        for (int i = 0; i < rootRenderTreeNode.getChildrenCount(); ++i) {
            this.unmountItemRecursively(rootRenderTreeNode.getChildAt(i));
        }
        MountItem item = (MountItem)this.mIndexToMountedItemMap.get(0L);
        if (item != null) {
            if (item.isBound()) {
                MountState.unbindRenderUnitFromContent(this.mMountDelegate, this.mContext, item);
            }
            this.mIndexToMountedItemMap.remove(0L);
            MountState.unmountRenderUnitFromContent(this.mContext, rootRenderTreeNode, rootRenderTreeNode.getRenderUnit(), item.getContent(), this.mMountDelegate);
        }
        this.mRenderUnitIds = null;
        this.mNeedsRemount = true;
    }

    @Override
    public boolean isRootItem(int position) {
        MountItem mountItem = this.getItemAt(position);
        if (mountItem == null) {
            return false;
        }
        return mountItem == this.mIndexToMountedItemMap.get(0L);
    }

    @Override
    @Nullable
    public MountItem getRootItem() {
        return this.mIndexToMountedItemMap != null ? (MountItem)this.mIndexToMountedItemMap.get(0L) : null;
    }

    @Override
    public Object getContentAt(int position) {
        MountItem mountItem = this.getItemAt(position);
        if (mountItem == null) {
            return null;
        }
        return mountItem.getContent();
    }

    @Override
    @Nullable
    public Object getContentById(long id) {
        if (this.mIndexToMountedItemMap == null) {
            return null;
        }
        MountItem mountItem = (MountItem)this.mIndexToMountedItemMap.get(id);
        if (mountItem == null) {
            return null;
        }
        return mountItem.getContent();
    }

    @Override
    @Deprecated
    public void registerMountDelegateExtension(MountExtension mountExtension) {
        if (this.mMountDelegate == null) {
            this.mMountDelegate = new MountDelegate(this);
        }
        this.mMountDelegate.addExtension(mountExtension);
    }

    @Override
    @Deprecated
    public void unregisterMountDelegateExtension(MountExtension mountExtension) {
        if (this.mMountDelegate == null) {
            return;
        }
        this.mMountDelegate.removeExtension(mountExtension);
    }

    @Override
    public ArrayList<Host> getHosts() {
        ArrayList<Host> hosts = new ArrayList<Host>();
        int size = this.mIndexToMountedItemMap.size();
        for (int i = 0; i < size; ++i) {
            MountItem item = (MountItem)this.mIndexToMountedItemMap.valueAt(i);
            Object content = item.getContent();
            if (!(content instanceof Host)) continue;
            hosts.add((Host)((Object)content));
        }
        return hosts;
    }

    @Override
    @Nullable
    public MountItem getMountItemAt(int position) {
        return this.getItemAt(position);
    }

    @Override
    public int getMountItemCount() {
        return this.mIndexToMountedItemMap.size();
    }

    @Override
    public int getRenderUnitCount() {
        return this.mRenderUnitIds == null ? 0 : this.mRenderUnitIds.length;
    }

    @Override
    public void setUnmountDelegateExtension(UnmountDelegateExtension unmountDelegateExtension) {
        this.mUnmountDelegateExtension = unmountDelegateExtension;
    }

    @Override
    public void removeUnmountDelegateExtension() {
        this.mUnmountDelegateExtension = null;
    }

    @Override
    @Nullable
    public ExtensionState getExtensionState(MountExtension mountExtension) {
        return this.mMountDelegate != null ? this.mMountDelegate.getExtensionState(mountExtension) : null;
    }

    @Override
    public void attach() {
        if (this.mRenderUnitIds == null) {
            return;
        }
        int size = this.mRenderUnitIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || mountItem.isBound()) continue;
            Object content = mountItem.getContent();
            MountState.bindRenderUnitToContent(this.mMountDelegate, this.mContext, mountItem);
            if (!(content instanceof View) || content instanceof Host || !((View)content).isLayoutRequested()) continue;
            View view = (View)content;
            BoundsUtils.applyBoundsToMountContent(mountItem.getRenderTreeNode(), view, true);
        }
    }

    @Override
    public void detach() {
        if (this.mRenderUnitIds == null) {
            return;
        }
        int size = this.mRenderUnitIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || !mountItem.isBound()) continue;
            MountState.unbindRenderUnitFromContent(this.mMountDelegate, this.mContext, mountItem);
        }
    }

    @Nullable
    RenderTree getRenderTree() {
        return this.mRenderTree;
    }

    private boolean isMountable(RenderTreeNode renderTreeNode, int index) {
        return this.mMountDelegate == null || this.mMountDelegate.maybeLockForMount(renderTreeNode, index);
    }

    private static void updateBoundsForMountedRenderTreeNode(RenderTreeNode renderTreeNode, MountItem item) {
        if (renderTreeNode.getRenderUnit().getId() == 0L) {
            return;
        }
        Object content = item.getContent();
        boolean forceTraversal = content instanceof View && ((View)content).isLayoutRequested();
        BoundsUtils.applyBoundsToMountContent(item.getRenderTreeNode(), item.getContent(), forceTraversal);
    }

    private boolean updateRenderTree(RenderTree renderTree) {
        if (renderTree == this.mRenderTree && !this.mNeedsRemount) {
            return false;
        }
        if (this.mRenderTree == null || this.mNeedsRemount) {
            this.addExtensions(renderTree.getExtensionResults());
        } else if (RenderCoreExtension.shouldUpdate(this.mRenderTree.getExtensionResults(), renderTree.getExtensionResults())) {
            this.unregisterAllExtensions();
            this.addExtensions(renderTree.getExtensionResults());
        }
        this.mRenderTree = renderTree;
        return true;
    }

    private void prepareMount() {
        this.unmountOrMoveOldItems();
        MountItem rootItem = (MountItem)this.mIndexToMountedItemMap.get(0L);
        RenderTreeNode rootNode = this.mRenderTree.getRenderTreeNodeAtIndex(0);
        RenderUnit rootRenderUnit = rootNode.getRenderUnit();
        if (rootItem == null) {
            MountState.mountRenderUnitToContent(this.mMountDelegate, this.mContext, rootNode, rootRenderUnit, (Object)this.mRootHost);
            MountItem item = new MountItem(rootNode, this.mRootHost, (Object)this.mRootHost);
            this.mIndexToMountedItemMap.put(0L, (Object)item);
            MountState.bindRenderUnitToContent(this.mMountDelegate, this.mContext, item);
        } else {
            MountState.updateMountItemIfNeeded(this.mContext, rootNode, rootItem);
        }
        int outputCount = this.mRenderTree.getMountableOutputCount();
        if (this.mRenderUnitIds == null || outputCount != this.mRenderUnitIds.length) {
            this.mRenderUnitIds = new long[outputCount];
        }
        for (int i = 0; i < outputCount; ++i) {
            this.mRenderUnitIds[i] = this.mRenderTree.getRenderTreeNodeAtIndex(i).getRenderUnit().getId();
        }
    }

    private void unmountOrMoveOldItems() {
        if (this.mRenderUnitIds == null) {
            return;
        }
        for (int i = 0; i < this.mRenderUnitIds.length; ++i) {
            Host newHost;
            boolean hasUnmountDelegate;
            int newPosition = this.mRenderTree.getRenderTreeNodeIndex(this.mRenderUnitIds[i]);
            RenderTreeNode renderTreeNode = newPosition > -1 ? this.mRenderTree.getRenderTreeNodeAtIndex(newPosition) : null;
            MountItem oldItem = this.getItemAt(i);
            boolean bl = hasUnmountDelegate = this.mUnmountDelegateExtension != null && oldItem != null ? this.mUnmountDelegateExtension.shouldDelegateUnmount(this.mMountDelegate.getUnmountDelegateExtensionState(), oldItem) : false;
            if (hasUnmountDelegate) continue;
            if (newPosition == -1) {
                if (oldItem == null) continue;
                this.unmountItemRecursively(oldItem.getRenderTreeNode());
                continue;
            }
            long newHostMarker = renderTreeNode.getParent() == null ? 0L : renderTreeNode.getParent().getRenderUnit().getId();
            Host host = newHost = this.mIndexToMountedItemMap.get(newHostMarker) == null ? null : (Host)((Object)((MountItem)this.mIndexToMountedItemMap.get(newHostMarker)).getContent());
            if (oldItem == null) continue;
            if (oldItem.getHost() != newHost) {
                this.unmountItemRecursively(oldItem.getRenderTreeNode());
                continue;
            }
            if (oldItem.getRenderTreeNode().getPositionInParent() == renderTreeNode.getPositionInParent()) continue;
            oldItem.getHost().moveItem(oldItem, oldItem.getRenderTreeNode().getPositionInParent(), renderTreeNode.getPositionInParent());
        }
    }

    private MountItem mountContentInHost(int index, Object content, Host host, RenderTreeNode renderTreeNode) {
        MountItem item = new MountItem(renderTreeNode, host, content);
        this.mIndexToMountedItemMap.put(this.mRenderUnitIds[index], (Object)item);
        host.mount(renderTreeNode.getPositionInParent(), item);
        return item;
    }

    private void mountRenderUnit(int index, RenderTreeNode renderTreeNode) {
        RenderTreeNode hostTreeNode = renderTreeNode.getParent();
        RenderUnit parentRenderUnit = hostTreeNode.getRenderUnit();
        RenderUnit renderUnit = renderTreeNode.getRenderUnit();
        MountItem mountItem = (MountItem)this.mIndexToMountedItemMap.get(parentRenderUnit.getId());
        if (mountItem == null) {
            throw new HostNotMountedException(renderUnit, parentRenderUnit, "Trying to mount a RenderTreeNode, but its host is not mounted.\nParent RenderUnit: id=" + parentRenderUnit.getId() + "; contentType='" + parentRenderUnit.getRenderContentType() + "'.\nChild RenderUnit: id=" + renderUnit.getId() + "; contentType='" + renderUnit.getRenderContentType() + "'.");
        }
        Object parentContent = mountItem.getContent();
        if (!(parentContent instanceof Host)) {
            throw new RuntimeException("Trying to mount a RenderTreeNode, its parent should be a Host, but was '" + parentContent.getClass().getSimpleName() + "'.\nParent RenderUnit: id=" + parentRenderUnit.getId() + "; contentType='" + parentRenderUnit.getRenderContentType() + "'.\nChild RenderUnit: id=" + renderUnit.getId() + "; contentType='" + renderUnit.getRenderContentType() + "'.");
        }
        Host host = (Host)((Object)parentContent);
        Object content = MountItemsPool.acquireMountContent(this.mContext, renderUnit);
        MountState.mountRenderUnitToContent(this.mMountDelegate, this.mContext, renderTreeNode, renderUnit, content);
        MountItem item = this.mountContentInHost(index, content, host, renderTreeNode);
        MountState.bindRenderUnitToContent(this.mMountDelegate, this.mContext, item);
        BoundsUtils.applyBoundsToMountContent(renderTreeNode, item.getContent(), true);
    }

    private void unmountItemRecursively(RenderTreeNode node) {
        Host host;
        boolean hasUnmountDelegate;
        RenderUnit unit = node.getRenderUnit();
        MountItem item = (MountItem)this.mIndexToMountedItemMap.get(unit.getId());
        if (item == null) {
            return;
        }
        Object content = item.getContent();
        if (unit.getId() == 0L) {
            return;
        }
        this.mIndexToMountedItemMap.remove(unit.getId());
        boolean bl = hasUnmountDelegate = this.mUnmountDelegateExtension != null && this.mUnmountDelegateExtension.shouldDelegateUnmount(this.mMountDelegate.getUnmountDelegateExtensionState(), item);
        if (node.getChildrenCount() > 0) {
            host = (Host)((Object)content);
            for (int i = 0; i < node.getChildrenCount(); ++i) {
                this.unmountItemRecursively(node.getChildAt(i));
            }
            if (!hasUnmountDelegate && host.getMountItemCount() > 0) {
                throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
            }
        }
        host = item.getHost();
        if (hasUnmountDelegate) {
            this.mUnmountDelegateExtension.unmount(this.mMountDelegate.getUnmountDelegateExtensionState(), item, host);
        } else {
            if (item.isBound()) {
                MountState.unbindRenderUnitFromContent(this.mMountDelegate, this.mContext, item);
            }
            host.unmount(node.getPositionInParent(), item);
            if (content instanceof View) {
                ((View)content).setPadding(0, 0, 0, 0);
            }
            MountState.unmountRenderUnitFromContent(this.mContext, node, unit, content, this.mMountDelegate);
            item.releaseMountContent(this.mContext);
        }
    }

    @Override
    public void unbindMountItem(MountItem mountItem) {
        Object content;
        if (mountItem.isBound()) {
            MountState.unbindRenderUnitFromContent(this.mMountDelegate, this.mContext, mountItem);
        }
        if ((content = mountItem.getContent()) instanceof View) {
            ((View)content).setPadding(0, 0, 0, 0);
        }
        MountState.unmountRenderUnitFromContent(this.mContext, mountItem.getRenderTreeNode(), mountItem.getRenderTreeNode().getRenderUnit(), content, this.mMountDelegate);
        mountItem.releaseMountContent(this.mContext);
    }

    @Nullable
    private MountItem getItemAt(int i) {
        if (this.mIndexToMountedItemMap == null || this.mRenderUnitIds == null) {
            return null;
        }
        if (i >= this.mRenderUnitIds.length) {
            return null;
        }
        return (MountItem)this.mIndexToMountedItemMap.get(this.mRenderUnitIds[i]);
    }

    private void addExtensions(@Nullable Map<RenderCoreExtension<?, ?>, Object> extensions) {
        if (extensions != null) {
            if (this.mMountDelegate == null) {
                this.mMountDelegate = new MountDelegate(this);
            }
            for (Map.Entry<RenderCoreExtension<?, ?>, Object> e : extensions.entrySet()) {
                MountExtension<?, ?> extension = e.getKey().getMountExtension();
                if (extension == null) continue;
                this.mMountDelegate.addExtension(extension);
            }
        }
    }

    private void unregisterAllExtensions() {
        if (this.mMountDelegate != null) {
            this.mMountDelegate.unBind();
            this.mMountDelegate.unMount();
            if (this.mRenderTree != null && this.mRenderTree.getExtensionResults() != null) {
                this.mMountDelegate.unregisterAllExtensions();
            }
            this.mMountDelegate.releaseAllAcquiredReferences();
        }
    }

    private static void mountRenderUnitToContent(@Nullable MountDelegate mountDelegate, Context context, RenderTreeNode node, RenderUnit unit, Object content) {
        unit.mountExtensions(context, content, node.getLayoutData());
        if (mountDelegate != null) {
            mountDelegate.onMountItem(unit, content, node.getLayoutData());
        }
    }

    private static void unmountRenderUnitFromContent(Context context, RenderTreeNode node, RenderUnit unit, Object content, @Nullable MountDelegate mountDelegate) {
        unit.unmountExtensions(context, content, node.getLayoutData());
        if (mountDelegate != null) {
            mountDelegate.onUnmountItem(unit, content, node.getLayoutData());
        }
    }

    private static void bindRenderUnitToContent(@Nullable MountDelegate mountDelegate, Context context, MountItem item) {
        RenderUnit renderUnit = item.getRenderUnit();
        Object content = item.getContent();
        Object layoutData = item.getRenderTreeNode().getLayoutData();
        renderUnit.attachExtensions(context, content, layoutData);
        if (mountDelegate != null) {
            mountDelegate.onBindItem(renderUnit, content, layoutData);
        }
        item.setIsBound(true);
    }

    private static void unbindRenderUnitFromContent(@Nullable MountDelegate mountDelegate, Context context, MountItem item) {
        RenderUnit renderUnit = item.getRenderUnit();
        Object content = item.getContent();
        Object layoutData = item.getRenderTreeNode().getLayoutData();
        renderUnit.detachExtensions(context, content, layoutData);
        if (mountDelegate != null) {
            mountDelegate.onUnbindItem(renderUnit, content, layoutData);
        }
        item.setIsBound(false);
    }

    private static void updateMountItemIfNeeded(Context context, RenderTreeNode renderTreeNode, MountItem currentMountItem) {
        RenderUnit renderUnit = renderTreeNode.getRenderUnit();
        Object newLayoutData = renderTreeNode.getLayoutData();
        RenderTreeNode currentNode = currentMountItem.getRenderTreeNode();
        RenderUnit currentRenderUnit = currentNode.getRenderUnit();
        Object currentLayoutData = currentNode.getLayoutData();
        Object content = currentMountItem.getContent();
        currentMountItem.update(renderTreeNode);
        if (currentRenderUnit != renderUnit) {
            RenderCoreSystrace.beginSection("Update Item: ", renderUnit.getDescription());
            renderUnit.updateExtensions(context, content, currentRenderUnit, currentLayoutData, newLayoutData);
        }
        MountState.updateBoundsForMountedRenderTreeNode(renderTreeNode, currentMountItem);
        RenderCoreSystrace.endSection();
        RenderCoreSystrace.endSection();
    }
}

