/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pools;
import com.facebook.rendercore.RenderUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class MountItemsPool {
    private static final int DEFAULT_POOL_SIZE = 3;
    private static final Map<Context, Map<Object, Pools.SimplePool>> sMountContentPoolsByContext = new HashMap<Context, Map<Object, Pools.SimplePool>>(4);
    private static final WeakHashMap<Context, Boolean> sDestroyedRootContexts = new WeakHashMap();
    private static PoolsActivityCallback sActivityCallbacks;
    static boolean sIsManualCallbacks;

    private MountItemsPool() {
    }

    static Object acquireMountContent(Context context, RenderUnit renderUnit) {
        Pools.SimplePool pool = MountItemsPool.getMountContentPool(context, renderUnit.getRenderContentType());
        Object content = null;
        if (pool == null) {
            return renderUnit.createContent(context);
        }
        content = pool.acquire();
        if (content == null) {
            content = renderUnit.createContent(context);
        }
        return content;
    }

    static void release(Context context, RenderUnit renderUnit, Object mountContent) {
        Pools.SimplePool pool = MountItemsPool.getMountContentPool(context, renderUnit.getRenderContentType());
        if (pool != null) {
            pool.release(mountContent);
        }
    }

    @Nullable
    private static Pools.SimplePool getMountContentPool(Context context, Object lifecycle) {
        Pools.SimplePool pool;
        Map<Object, Pools.SimplePool> poolsMap = sMountContentPoolsByContext.get(context);
        if (poolsMap == null) {
            Context rootContext = MountItemsPool.getRootContext(context);
            if (sDestroyedRootContexts.containsKey(rootContext)) {
                return null;
            }
            MountItemsPool.ensureActivityCallbacks(context);
            poolsMap = new HashMap<Object, Pools.SimplePool>();
            sMountContentPoolsByContext.put(context, poolsMap);
        }
        if ((pool = poolsMap.get(lifecycle)) == null) {
            pool = new Pools.SimplePool(3);
            poolsMap.put(lifecycle, pool);
        }
        return pool;
    }

    @VisibleForTesting(otherwise=3)
    public static void clear() {
        sMountContentPoolsByContext.clear();
        sDestroyedRootContexts.clear();
    }

    private static Context getRootContext(Context context) {
        Context currentContext = context;
        while (currentContext instanceof ContextWrapper && !(currentContext instanceof Activity) && !(currentContext instanceof Application) && !(currentContext instanceof Service)) {
            currentContext = ((ContextWrapper)currentContext).getBaseContext();
        }
        return currentContext;
    }

    private static void ensureActivityCallbacks(Context context) {
        if (sActivityCallbacks == null && !sIsManualCallbacks) {
            if (Build.VERSION.SDK_INT < 14) {
                throw new RuntimeException("Activity callbacks must be invoked manually below ICS (API level 14)");
            }
            sActivityCallbacks = new PoolsActivityCallback();
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sActivityCallbacks);
        }
    }

    static void onContextCreated(Context context) {
        if (sMountContentPoolsByContext.containsKey(context)) {
            throw new IllegalStateException("The MountContentPools has a reference to an activity that has just been created");
        }
    }

    static void onContextDestroyed(Context context) {
        sMountContentPoolsByContext.remove(context);
        Iterator<Map.Entry<Context, Map<Object, Pools.SimplePool>>> it = sMountContentPoolsByContext.entrySet().iterator();
        while (it.hasNext()) {
            Context contextKey = it.next().getKey();
            if (!MountItemsPool.isContextWrapper(contextKey, context)) continue;
            it.remove();
        }
        sDestroyedRootContexts.put(MountItemsPool.getRootContext(context), true);
    }

    private static boolean isContextWrapper(Context contextWrapper, Context baseContext) {
        while (baseContext instanceof ContextWrapper) {
            baseContext = ((ContextWrapper)baseContext).getBaseContext();
        }
        Context currentContext = contextWrapper;
        while (currentContext instanceof ContextWrapper) {
            currentContext = ((ContextWrapper)currentContext).getBaseContext();
        }
        return currentContext == baseContext;
    }

    @TargetApi(value=14)
    private static class PoolsActivityCallback
    implements Application.ActivityLifecycleCallbacks {
        private PoolsActivityCallback() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            MountItemsPool.onContextCreated((Context)activity);
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            MountItemsPool.onContextDestroyed((Context)activity);
        }
    }
}

