/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountItemsPool;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;

public class MountItem {
    private Object mContent;
    @Nullable
    private Host mHost;
    private boolean mBound;
    private RenderTreeNode mRenderTreeNode;
    private Object mMountData;

    public MountItem(RenderTreeNode renderTreeNode, @Nullable Host host, Object content) {
        this.mRenderTreeNode = renderTreeNode;
        this.mHost = host;
        this.mContent = content;
    }

    public Object getContent() {
        return this.mContent;
    }

    public boolean isBound() {
        return this.mBound;
    }

    RenderUnit getRenderUnit() {
        return this.mRenderTreeNode.getRenderUnit();
    }

    void setContent(Object content) {
        this.mContent = content;
    }

    public void setIsBound(boolean bound) {
        this.mBound = bound;
    }

    @Nullable
    public Host getHost() {
        return this.mHost;
    }

    public void setHost(@Nullable Host host) {
        this.mHost = host;
    }

    public void update(RenderTreeNode renderTreeNode) {
        this.mRenderTreeNode = renderTreeNode;
    }

    public void releaseMountContent(Context context) {
        MountItemsPool.release(context, this.getRenderUnit(), this.mContent);
    }

    public RenderTreeNode getRenderTreeNode() {
        return this.mRenderTreeNode;
    }

    public Object getMountData() {
        return this.mMountData;
    }

    public void setMountData(Object mountData) {
        this.mMountData = mountData;
    }
}

