/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LongSparseArray;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.UnmountDelegateExtension;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MountDelegate {
    private final LongSparseArray<Integer> mReferenceCountMap = new LongSparseArray();
    private final List<MountExtension> mMountExtensions = new ArrayList<MountExtension>();
    private final MountDelegateTarget mMountDelegateTarget;
    private final Map<MountExtension, ExtensionState> mExtensionStates = new HashMap<MountExtension, ExtensionState>();
    @Nullable
    private ExtensionState mUnmountDelegateExtensionState;
    private boolean mReferenceCountingEnabled = false;

    public MountDelegate(MountDelegateTarget mountDelegateTarget) {
        this.mMountDelegateTarget = mountDelegateTarget;
    }

    public void addExtension(MountExtension mountExtension) {
        ExtensionState extensionState = mountExtension.createExtensionState(this);
        if (mountExtension instanceof UnmountDelegateExtension) {
            this.mMountDelegateTarget.setUnmountDelegateExtension((UnmountDelegateExtension)((Object)mountExtension));
            this.mUnmountDelegateExtensionState = extensionState;
        }
        this.mReferenceCountingEnabled = this.mReferenceCountingEnabled || mountExtension.canPreventMount();
        this.mExtensionStates.put(mountExtension, extensionState);
        this.mMountExtensions.add(mountExtension);
    }

    public void removeExtension(MountExtension mountExtension) {
        this.mMountExtensions.remove(mountExtension);
        this.mExtensionStates.remove(mountExtension);
        if (mountExtension instanceof UnmountDelegateExtension) {
            this.mMountDelegateTarget.removeUnmountDelegateExtension();
            this.mUnmountDelegateExtensionState = null;
        }
        this.updateRefCountEnabled();
    }

    void unregisterAllExtensions() {
        this.mMountExtensions.clear();
        this.mExtensionStates.clear();
        this.mReferenceCountingEnabled = false;
    }

    private void updateRefCountEnabled() {
        this.mReferenceCountingEnabled = false;
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            this.mReferenceCountingEnabled = this.mReferenceCountingEnabled || this.mMountExtensions.get(i).canPreventMount();
        }
    }

    void unBind() {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension mountExtension = this.mMountExtensions.get(i);
            mountExtension.onUnbind(this.getExtensionState(mountExtension));
        }
    }

    void unMount() {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension mountExtension = this.mMountExtensions.get(i);
            mountExtension.onUnmount(this.getExtensionState(mountExtension));
        }
    }

    void onBindItem(RenderUnit renderUnit, Object content, Object layoutData) {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension extension = this.mMountExtensions.get(i);
            extension.onBindItem(this.getExtensionState(extension), renderUnit, content, layoutData);
        }
    }

    void onUnbindItem(RenderUnit renderUnit, Object content, Object layoutData) {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension extension = this.mMountExtensions.get(i);
            extension.onUnbindItem(this.getExtensionState(extension), renderUnit, content, layoutData);
        }
    }

    public void onMountItem(RenderUnit renderUnit, Object content, Object layoutData) {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension extension = this.mMountExtensions.get(i);
            extension.onMountItem(this.getExtensionState(extension), renderUnit, content, layoutData);
        }
    }

    public void onUnmountItem(RenderUnit renderUnit, Object content, @Nullable Object layoutData) {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension extension = this.mMountExtensions.get(i);
            extension.onUnmountItem(this.getExtensionState(extension), renderUnit, content, layoutData);
        }
    }

    public ExtensionState getExtensionState(MountExtension mountExtension) {
        return this.mExtensionStates.get(mountExtension);
    }

    @Nullable
    public ExtensionState getUnmountDelegateExtensionState() {
        return this.mUnmountDelegateExtensionState;
    }

    public Object getContentAt(int position) {
        return this.mMountDelegateTarget.getContentAt(position);
    }

    @Nullable
    public Object getContentById(long id) {
        return this.mMountDelegateTarget.getContentById(id);
    }

    public boolean isRootItem(int position) {
        return this.mMountDelegateTarget.isRootItem(position);
    }

    public boolean maybeLockForMount(RenderTreeNode renderTreeNode, int index) {
        if (!this.mReferenceCountingEnabled) {
            return true;
        }
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension mountExtension = this.mMountExtensions.get(i);
            mountExtension.beforeMountItem(this.getExtensionState(mountExtension), renderTreeNode, index);
        }
        return this.hasAcquiredRef(renderTreeNode.getRenderUnit().getId());
    }

    public boolean isLockedForMount(RenderTreeNode renderTreeNode) {
        return this.isLockedForMount(renderTreeNode.getRenderUnit().getId());
    }

    public boolean isLockedForMount(long id) {
        if (!this.mReferenceCountingEnabled) {
            return true;
        }
        return this.hasAcquiredRef(id);
    }

    private boolean hasAcquiredRef(long renderUnitId) {
        Integer refCount = (Integer)this.mReferenceCountMap.get(renderUnitId);
        return refCount != null && refCount > 0;
    }

    @VisibleForTesting(otherwise=3)
    public void acquireMountRef(RenderTreeNode node) {
        this.acquireMountRef(node.getRenderUnit().getId());
    }

    public void acquireMountRef(long id) {
        this.incrementExtensionRefCount(id);
    }

    public void acquireAndMountRef(RenderTreeNode node) {
        this.acquireAndMountRef(node.getRenderUnit().getId());
    }

    public void acquireAndMountRef(long id) {
        this.acquireMountRef(id);
        this.mMountDelegateTarget.notifyMount(id);
    }

    @VisibleForTesting(otherwise=3)
    public void releaseMountRef(RenderTreeNode renderTreeNode) {
        this.releaseMountRef(renderTreeNode.getRenderUnit().getId());
    }

    public void releaseMountRef(long id) {
        this.decrementExtensionRefCount(id);
    }

    public void releaseAndUnmountRef(RenderTreeNode renderTreeNode) {
        this.releaseAndUnmountRef(renderTreeNode.getRenderUnit().getId());
    }

    public void releaseAndUnmountRef(long id) {
        boolean wasLockedForMount = this.isLockedForMount(id);
        this.releaseMountRef(id);
        if (wasLockedForMount && !this.isLockedForMount(id)) {
            this.mMountDelegateTarget.notifyUnmount(id);
        }
    }

    public void releaseAllAcquiredReferences() {
        if (!this.mReferenceCountingEnabled) {
            return;
        }
        for (MountExtension extension : this.mMountExtensions) {
            ExtensionState state = this.getExtensionState(extension);
            state.releaseAllAcquiredReferences();
        }
        this.mReferenceCountMap.clear();
    }

    private void incrementExtensionRefCount(long renderUnitId) {
        if (!this.mReferenceCountingEnabled) {
            return;
        }
        Integer refCount = (Integer)this.mReferenceCountMap.get(renderUnitId);
        if (refCount == null) {
            refCount = 0;
        }
        this.mReferenceCountMap.put(renderUnitId, (Object)(refCount + 1));
    }

    private void decrementExtensionRefCount(long renderUnitId) {
        if (!this.mReferenceCountingEnabled) {
            return;
        }
        Integer refCount = (Integer)this.mReferenceCountMap.get(renderUnitId);
        if (refCount == null || refCount == 0) {
            throw new IllegalStateException("Trying to decrement reference count for an item you don't own.");
        }
        this.mReferenceCountMap.put(renderUnitId, (Object)(refCount - 1));
    }

    public MountDelegateTarget getMountDelegateTarget() {
        return this.mMountDelegateTarget;
    }

    @VisibleForTesting
    public int getRefCount(long id) {
        return (Integer)this.mReferenceCountMap.get(id);
    }
}

