/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LongSparseArray;
import com.facebook.rendercore.Node;
import java.util.HashMap;
import java.util.Map;

public class LayoutCache {
    private final Map<Node<?>, Node.LayoutResult<?>> mWriteCacheByNode = new HashMap();
    private final LongSparseArray<Object> mWriteCacheById = new LongSparseArray();
    private final Map<Node<?>, Node.LayoutResult<?>> mReadCacheByNode;
    private final LongSparseArray<Object> mReadCacheById;

    @VisibleForTesting(otherwise=3)
    public LayoutCache() {
        this(null);
    }

    LayoutCache(@Nullable LayoutCache oldCache) {
        if (oldCache == null) {
            this.mReadCacheByNode = new HashMap();
            this.mReadCacheById = new LongSparseArray();
        } else {
            this.mReadCacheByNode = oldCache.mWriteCacheByNode;
            this.mReadCacheById = oldCache.mWriteCacheById;
        }
    }

    @Nullable
    public Node.LayoutResult<?> get(Node<?> node) {
        return this.mReadCacheByNode.get(node);
    }

    public void put(Node<?> node, Node.LayoutResult<?> layout) {
        this.mWriteCacheByNode.put(node, layout);
    }

    @Nullable
    public <T> T get(long uniqueId) {
        return (T)this.mReadCacheById.get(uniqueId);
    }

    public void put(long uniqueId, Object value) {
        this.mWriteCacheById.put(uniqueId, value);
    }
}

