/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.InterceptTouchHandler;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.MountUtils;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.Touchable;

public class HostView
extends Host {
    private static final int INITIAL_MOUNT_ITEMS_SIZE = 8;
    private final InterleavedDispatchDraw mDispatchDraw = new InterleavedDispatchDraw();
    private MountItem[] mMountItems;
    private int[] mChildDrawingOrder = new int[0];
    private boolean mIsChildDrawingOrderDirty;
    private boolean mInLayout;
    @Nullable
    private InterceptTouchHandler mOnInterceptTouchEventHandler;
    @Nullable
    private MountItem[] mScrapMountItemsArray;
    @Nullable
    private Object mViewTag;
    @Nullable
    private SparseArray<Object> mViewTags;
    @Nullable
    private Drawable mForeground;

    public HostView(Context context) {
        this(context, null);
    }

    public HostView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.setChildrenDrawingOrderEnabled(true);
        this.mMountItems = new MountItem[8];
    }

    @Override
    public void mount(int index, MountItem mountItem) {
        if (mountItem.getRenderUnit().getRenderType() == RenderUnit.RenderType.DRAWABLE) {
            this.mountDrawable(mountItem);
        } else {
            this.mountView(mountItem);
        }
        this.ensureSize(index);
        this.mMountItems[index] = mountItem;
    }

    private void ensureSize(int index) {
        if (index >= this.mMountItems.length) {
            int newLength;
            for (newLength = this.mMountItems.length * 2; index >= newLength; newLength *= 2) {
            }
            MountItem[] tmp = new MountItem[newLength];
            System.arraycopy(this.mMountItems, 0, tmp, 0, this.mMountItems.length);
            this.mMountItems = tmp;
        }
    }

    @Override
    public void unmount(MountItem item) {
        int index = this.findItemIndex(item);
        this.unmount(index, item);
    }

    private int findItemIndex(MountItem item) {
        for (int i = 0; i < this.mMountItems.length; ++i) {
            if (this.mMountItems[i] != item) continue;
            return i;
        }
        throw new IllegalStateException("Mount item " + item + "Was selected for unmount but was not found in the list of mounted items");
    }

    @Override
    public void unmount(int index, MountItem mountItem) {
        if (mountItem.getRenderUnit().getRenderType() == RenderUnit.RenderType.DRAWABLE) {
            this.unmountDrawable(mountItem);
        } else {
            this.unmountView(mountItem);
            this.mIsChildDrawingOrderDirty = true;
        }
        MountUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
    }

    @Override
    public int getMountItemCount() {
        int size = 0;
        for (int i = 0; i < this.mMountItems.length; ++i) {
            if (this.mMountItems[i] == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public MountItem getMountItemAt(int index) {
        return this.mMountItems[index];
    }

    @Override
    public void moveItem(MountItem item, int oldIndex, int newIndex) {
        if (item == null && this.mScrapMountItemsArray != null) {
            item = this.mScrapMountItemsArray[oldIndex];
        }
        if (item == null) {
            return;
        }
        Object content = item.getContent();
        if (item.getRenderUnit().getRenderType() == RenderUnit.RenderType.DRAWABLE) {
            this.invalidate();
        } else {
            this.mIsChildDrawingOrderDirty = true;
            HostView.startTemporaryDetach((View)content);
        }
        this.ensureSize(newIndex);
        if (this.mMountItems[newIndex] != null) {
            this.ensureScrapMountItemsArray();
            MountUtils.scrapItemAt(newIndex, this.mMountItems, this.mScrapMountItemsArray);
        }
        MountUtils.moveItem(oldIndex, newIndex, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        if (item.getRenderUnit().getRenderType() == RenderUnit.RenderType.VIEW) {
            HostView.finishTemporaryDetach((View)content);
        }
    }

    public void setInterceptTouchEventHandler(@Nullable InterceptTouchHandler interceptTouchEventHandler) {
        this.mOnInterceptTouchEventHandler = interceptTouchEventHandler;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventHandler != null) {
            return this.mOnInterceptTouchEventHandler.onInterceptTouchEvent((View)this, ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void mountView(MountItem mountItem) {
        View view = (View)mountItem.getContent();
        this.mIsChildDrawingOrderDirty = true;
        if (view instanceof HostView && view.getParent() == this) {
            HostView.finishTemporaryDetach(view);
            view.setVisibility(0);
            return;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
            view.setLayoutParams(lp);
        }
        if (this.mInLayout) {
            super.addViewInLayout(view, -1, view.getLayoutParams(), true);
        } else {
            super.addView(view, -1, view.getLayoutParams());
        }
    }

    private void unmountView(MountItem mountItem) {
        View view = (View)mountItem.getContent();
        this.mIsChildDrawingOrderDirty = true;
        if (view.isPressed()) {
            view.setPressed(false);
        }
        if (this.mInLayout) {
            super.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    public void dispatchDraw(Canvas canvas) {
        this.mDispatchDraw.start(canvas);
        super.dispatchDraw(canvas);
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        this.mDispatchDraw.end();
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        this.updateChildDrawingOrderIfNeeded();
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        return this.mChildDrawingOrder[i];
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        if (this.isEnabled()) {
            for (int i = (this.mMountItems == null ? 0 : this.mMountItems.length) - 1; i >= 0; --i) {
                Touchable t;
                MountItem item = this.mMountItems[i];
                if (item == null || item.getRenderUnit().getRenderType() != RenderUnit.RenderType.DRAWABLE || !(item.getContent() instanceof Touchable) || !(t = (Touchable)item.getContent()).shouldHandleTouchEvent(event) || !t.onTouchEvent(event, (View)this)) continue;
                handled = true;
                break;
            }
        }
        if (!handled) {
            handled = super.onTouchEvent(event);
        }
        return handled;
    }

    void performLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected final void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        this.performLayout(changed, l, t, r, b);
        this.mInLayout = false;
    }

    public void requestLayout() {
        HostView parent = this;
        while (parent instanceof HostView) {
            HostView host = parent;
            if (!host.shouldRequestLayout()) {
                return;
            }
            parent = parent.getParent();
        }
        super.requestLayout();
    }

    protected boolean shouldRequestLayout() {
        return !this.mInLayout;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected boolean verifyDrawable(Drawable who) {
        return true;
    }

    protected void drawableStateChanged() {
        int size;
        super.drawableStateChanged();
        int n = size = this.mMountItems == null ? 0 : this.mMountItems.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.mMountItems[i];
            if (mountItem == null || mountItem.getRenderUnit().getRenderType() != RenderUnit.RenderType.DRAWABLE) continue;
            MountUtils.maybeSetDrawableState((View)this, (Drawable)mountItem.getContent());
        }
        if (this.mForeground != null) {
            this.mForeground.setState(this.getDrawableState());
        }
    }

    public void jumpDrawablesToCurrentState() {
        int size;
        super.jumpDrawablesToCurrentState();
        int n = size = this.mMountItems == null ? 0 : this.mMountItems.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.mMountItems[i];
            if (mountItem == null || mountItem.getRenderUnit().getRenderType() != RenderUnit.RenderType.DRAWABLE) continue;
            Drawable drawable = (Drawable)mountItem.getContent();
            DrawableCompat.jumpToCurrentState((Drawable)drawable);
        }
        if (this.mForeground != null) {
            this.mForeground.jumpToCurrentState();
        }
    }

    public void setVisibility(int visibility) {
        int size;
        super.setVisibility(visibility);
        int n = size = this.mMountItems == null ? 0 : this.mMountItems.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.mMountItems[i];
            if (mountItem == null || mountItem.getRenderUnit().getRenderType() != RenderUnit.RenderType.DRAWABLE) continue;
            Drawable drawable = (Drawable)mountItem.getContent();
            drawable.setVisible(visibility == 0, false);
        }
    }

    public void setViewTag(Object viewTag) {
        this.mViewTag = viewTag;
    }

    public void setViewTags(SparseArray<Object> viewTags) {
        this.mViewTags = viewTags;
    }

    public Object getTag() {
        if (this.mViewTag != null) {
            return this.mViewTag;
        }
        return super.getTag();
    }

    public Object getTag(int key) {
        Object value;
        if (this.mViewTags != null && (value = this.mViewTags.get(key)) != null) {
            return value;
        }
        return super.getTag(key);
    }

    private static void startTemporaryDetach(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            view.cancelPendingInputEvents();
        }
        ViewCompat.dispatchStartTemporaryDetach((View)view);
    }

    private static void finishTemporaryDetach(View view) {
        ViewCompat.dispatchFinishTemporaryDetach((View)view);
    }

    private void updateChildDrawingOrderIfNeeded() {
        if (!this.mIsChildDrawingOrderDirty) {
            return;
        }
        int childCount = this.getChildCount();
        if (this.mChildDrawingOrder.length < childCount) {
            this.mChildDrawingOrder = new int[childCount + 5];
        }
        int index = 0;
        int mountItemCount = this.mMountItems == null ? 0 : this.mMountItems.length;
        for (int i = 0; i < mountItemCount; ++i) {
            MountItem mountItem = this.mMountItems[i];
            if (mountItem == null || mountItem.getRenderUnit().getRenderType() != RenderUnit.RenderType.VIEW) continue;
            View child = (View)mountItem.getContent();
            this.mChildDrawingOrder[index++] = this.indexOfChild(child);
        }
        this.mIsChildDrawingOrderDirty = false;
    }

    private void ensureScrapMountItemsArray() {
        if (this.mScrapMountItemsArray == null) {
            this.mScrapMountItemsArray = new MountItem[this.mMountItems.length];
        }
    }

    private void releaseScrapDataStructuresIfNeeded() {
        if (this.mScrapMountItemsArray != null && HostView.isEmpty(this.mScrapMountItemsArray)) {
            this.mScrapMountItemsArray = null;
        }
    }

    private static boolean isEmpty(MountItem[] scrapMountItemsArray) {
        for (int i = 0; i < scrapMountItemsArray.length; ++i) {
            if (scrapMountItemsArray[i] == null) continue;
            return false;
        }
        return true;
    }

    private void mountDrawable(MountItem mountItem) {
        Drawable drawable = (Drawable)mountItem.getContent();
        MountUtils.mountDrawable((View)this, drawable);
        this.invalidate(mountItem.getRenderTreeNode().getBounds());
    }

    private void unmountDrawable(MountItem mountItem) {
        Drawable drawable = (Drawable)mountItem.getContent();
        drawable.setCallback(null);
        this.invalidate(drawable.getBounds());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mForeground != null) {
            this.mForeground.setBounds(0, 0, this.getRight(), this.getBottom());
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            this.mForeground.draw(canvas);
        }
    }

    public void setForegroundCompat(@Nullable Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 23) {
            MarshmallowHelper.setForeground(this, drawable);
        } else {
            this.setForegroundLollipop(drawable);
        }
    }

    private void setForegroundLollipop(@Nullable Drawable newForeground) {
        if (this.mForeground != newForeground) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = newForeground;
            if (newForeground != null) {
                newForeground.setCallback((Drawable.Callback)this);
                if (newForeground.isStateful()) {
                    newForeground.setState(this.getDrawableState());
                }
            }
            this.invalidate();
        }
    }

    static void performLayoutOnChildrenIfNecessary(HostView host) {
        int count = host.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = host.getChildAt(i);
            if (child.isLayoutRequested()) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getHeight(), (int)0x40000000));
                child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
            }
            if (!(child instanceof HostView)) continue;
            HostView.performLayoutOnChildrenIfNecessary((HostView)child);
        }
    }

    static class MarshmallowHelper {
        MarshmallowHelper() {
        }

        @RequiresApi(api=23)
        static void setForeground(HostView hostView, @Nullable Drawable newForeground) {
            hostView.setForeground(newForeground);
        }
    }

    private class InterleavedDispatchDraw {
        @Nullable
        private Canvas mCanvas;
        private int mDrawIndex;
        private int mItemsToDraw;

        private InterleavedDispatchDraw() {
        }

        private void start(Canvas canvas) {
            this.mCanvas = canvas;
            this.mDrawIndex = 0;
            this.mItemsToDraw = HostView.this.mMountItems == null ? 0 : HostView.this.mMountItems.length;
        }

        private boolean isRunning() {
            return this.mCanvas != null && this.mDrawIndex < this.mItemsToDraw;
        }

        private void drawNext() {
            int size;
            if (this.mCanvas == null) {
                return;
            }
            int n = size = HostView.this.mMountItems == null ? 0 : HostView.this.mMountItems.length;
            for (int i = this.mDrawIndex; i < size; ++i) {
                MountItem mountItem = HostView.this.mMountItems[i];
                if (mountItem == null) continue;
                if (mountItem.getRenderUnit().getRenderType() == RenderUnit.RenderType.VIEW) {
                    this.mDrawIndex = i + 1;
                    return;
                }
                if (!mountItem.isBound()) continue;
                ((Drawable)mountItem.getContent()).draw(this.mCanvas);
            }
            this.mDrawIndex = this.mItemsToDraw;
        }

        private void end() {
            this.mCanvas = null;
        }
    }
}

