/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.visibility;

import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.rendercore.Function;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.visibility.VisibilityExtensionConfigs;

public class VisibilityUtils {
    private static VisibleEvent sVisibleEvent;
    private static InvisibleEvent sInvisibleEvent;
    private static FocusedVisibleEvent sFocusedVisibleEvent;
    private static UnfocusedVisibleEvent sUnfocusedVisibleEvent;
    private static FullImpressionVisibleEvent sFullImpressionVisibleEvent;
    private static VisibilityChangedEvent sVisibleRectChangedEvent;

    public static void dispatchOnVisible(Function<Void> visibleHandler, @Nullable Object content) {
        RenderCoreSystrace.beginSection((String)"VisibilityUtils.dispatchOnVisible");
        if (sVisibleEvent == null) {
            sVisibleEvent = new VisibleEvent();
        }
        VisibilityUtils.sVisibleEvent.content = content;
        VisibilityUtils.log("Dispatch:VisibleEvent to: " + visibleHandler.toString());
        visibleHandler.call(new Object[]{sVisibleEvent});
        VisibilityUtils.sVisibleEvent.content = null;
        RenderCoreSystrace.endSection();
    }

    public static void dispatchOnFocused(Function<Void> focusedHandler) {
        if (sFocusedVisibleEvent == null) {
            sFocusedVisibleEvent = new FocusedVisibleEvent();
        }
        VisibilityUtils.log("Dispatch:FocusedVisibleEvent to: " + focusedHandler.toString());
        focusedHandler.call(new Object[]{sFocusedVisibleEvent});
    }

    public static void dispatchOnUnfocused(Function<Void> unfocusedHandler) {
        if (sUnfocusedVisibleEvent == null) {
            sUnfocusedVisibleEvent = new UnfocusedVisibleEvent();
        }
        VisibilityUtils.log("Dispatch:UnfocusedVisibleEvent to: " + unfocusedHandler.toString());
        unfocusedHandler.call(new Object[]{sUnfocusedVisibleEvent});
    }

    public static void dispatchOnFullImpression(Function<Void> fullImpressionHandler) {
        if (sFullImpressionVisibleEvent == null) {
            sFullImpressionVisibleEvent = new FullImpressionVisibleEvent();
        }
        VisibilityUtils.log("Dispatch:FullImpressionVisibleEvent to: " + fullImpressionHandler.toString());
        fullImpressionHandler.call(new Object[]{sFullImpressionVisibleEvent});
    }

    public static void dispatchOnInvisible(Function<Void> invisibleHandler) {
        if (sInvisibleEvent == null) {
            sInvisibleEvent = new InvisibleEvent();
        }
        VisibilityUtils.log("Dispatch:InvisibleEvent to: " + invisibleHandler.toString());
        invisibleHandler.call(new Object[]{sInvisibleEvent});
    }

    public static void dispatchOnVisibilityChanged(@Nullable Function<Void> visibilityChangedHandler, int visibleTop, int visibleLeft, int visibleWidth, int visibleHeight, float percentVisibleWidth, float percentVisibleHeight) {
        if (visibilityChangedHandler == null) {
            return;
        }
        if (sVisibleRectChangedEvent == null) {
            sVisibleRectChangedEvent = new VisibilityChangedEvent();
        }
        VisibilityUtils.sVisibleRectChangedEvent.visibleTop = visibleTop;
        VisibilityUtils.sVisibleRectChangedEvent.visibleLeft = visibleLeft;
        VisibilityUtils.sVisibleRectChangedEvent.visibleHeight = visibleHeight;
        VisibilityUtils.sVisibleRectChangedEvent.visibleWidth = visibleWidth;
        VisibilityUtils.sVisibleRectChangedEvent.percentVisibleHeight = percentVisibleHeight;
        VisibilityUtils.sVisibleRectChangedEvent.percentVisibleWidth = percentVisibleWidth;
        VisibilityUtils.log("Dispatch:VisibilityChangedEvent to: " + visibilityChangedHandler.toString());
        visibilityChangedHandler.call(new Object[]{sVisibleRectChangedEvent});
    }

    public static void log(String log) {
        if (VisibilityExtensionConfigs.isDebugLoggingEnabled) {
            Log.d((String)"VisibilityExtension", (String)log);
        }
    }
}

