/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.visibility;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Function;
import com.facebook.rendercore.Node;

public class VisibilityOutput {
    private final String mId;
    private final String mKey;
    private final Rect mBounds;
    public final boolean hasMountableContent;
    public final long mRenderUnitId;
    private final float mVisibleHeightRatio;
    private final float mVisibleWidthRatio;
    @Nullable
    private final Function<Void> mVisibleEventHandler;
    @Nullable
    private final Function<Void> mInvisibleEventHandler;
    @Nullable
    private final Function<Void> mFocusedEventHandler;
    @Nullable
    private final Function<Void> mUnfocusedEventHandler;
    @Nullable
    private final Function<Void> mFullImpressionEventHandler;
    @Nullable
    private final Function<Void> mVisibilityChangedEventHandler;
    private float mFocusedRatio;

    public VisibilityOutput(String id, String key, Rect bounds, float visibleHeightRatio, float visibleWidthRatio, @Nullable Function<Void> visibleEventHandler, @Nullable Function<Void> invisibleEventHandler, @Nullable Function<Void> focusedEventHandler, @Nullable Function<Void> unfocusedEventHandler, @Nullable Function<Void> fullImpressionEventHandler, @Nullable Function<Void> visibilityChangedEventHandler) {
        this(id, key, bounds, false, 0L, visibleHeightRatio, visibleWidthRatio, visibleEventHandler, invisibleEventHandler, focusedEventHandler, unfocusedEventHandler, fullImpressionEventHandler, visibilityChangedEventHandler);
    }

    public VisibilityOutput(String id, String key, Rect bounds, boolean hasMountableContent, long renderUnitId, float visibleHeightRatio, float visibleWidthRatio, @Nullable Function<Void> visibleEventHandler, @Nullable Function<Void> invisibleEventHandler, @Nullable Function<Void> focusedEventHandler, @Nullable Function<Void> unfocusedEventHandler, @Nullable Function<Void> fullImpressionEventHandler, @Nullable Function<Void> visibilityChangedEventHandler) {
        this.mId = id;
        this.mKey = key;
        this.mBounds = bounds;
        this.hasMountableContent = hasMountableContent;
        this.mRenderUnitId = renderUnitId;
        this.mVisibleHeightRatio = visibleHeightRatio;
        this.mVisibleWidthRatio = visibleWidthRatio;
        this.mVisibleEventHandler = visibleEventHandler;
        this.mInvisibleEventHandler = invisibleEventHandler;
        this.mFocusedEventHandler = focusedEventHandler;
        this.mUnfocusedEventHandler = unfocusedEventHandler;
        this.mFullImpressionEventHandler = fullImpressionEventHandler;
        this.mVisibilityChangedEventHandler = visibilityChangedEventHandler;
    }

    public String getId() {
        return this.mId;
    }

    public String getKey() {
        return this.mKey;
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public float getVisibilityTop() {
        if (this.getVisibleHeightRatio() == 0.0f) {
            return this.mBounds.top;
        }
        return (float)this.mBounds.top + this.getVisibleHeightRatio() * (float)(this.mBounds.bottom - this.mBounds.top);
    }

    public float getVisibilityBottom() {
        if (this.getVisibleHeightRatio() == 0.0f) {
            return this.mBounds.bottom;
        }
        return (float)this.mBounds.bottom - this.getVisibleHeightRatio() * (float)(this.mBounds.bottom - this.mBounds.top);
    }

    public float getVisibilityLeft() {
        return (float)this.mBounds.left + this.getVisibleWidthRatio() * (float)(this.mBounds.right - this.mBounds.left);
    }

    public float getVisibilityRight() {
        return (float)this.mBounds.right - this.getVisibleHeightRatio() * (float)(this.mBounds.right - this.mBounds.left);
    }

    public float getFullImpressionTop() {
        return this.mBounds.bottom;
    }

    public float getFullImpressionBottom() {
        return this.mBounds.top;
    }

    public float getFullImpressionLeft() {
        return this.mBounds.right;
    }

    public float getFullImpressionRight() {
        return this.mBounds.left;
    }

    public float getFocusedTop() {
        return (float)this.mBounds.top + this.mFocusedRatio * (float)(this.mBounds.bottom - this.mBounds.top);
    }

    public float getFocusedBottom() {
        return (float)this.mBounds.bottom - this.mFocusedRatio * (float)(this.mBounds.bottom - this.mBounds.top);
    }

    public float getFocusedLeft() {
        return (float)this.mBounds.left + this.mFocusedRatio * (float)(this.mBounds.right - this.mBounds.left);
    }

    public float getFocusedRight() {
        return (float)this.mBounds.right - this.mFocusedRatio * (float)(this.mBounds.right - this.mBounds.left);
    }

    public int getComponentArea() {
        Rect rect = this.getBounds();
        return rect.isEmpty() ? 0 : rect.width() * rect.height();
    }

    public float getVisibleHeightRatio() {
        return this.mVisibleHeightRatio;
    }

    public float getVisibleWidthRatio() {
        return this.mVisibleWidthRatio;
    }

    public void setFocusedRatio(float focusedRatio) {
        this.mFocusedRatio = focusedRatio;
    }

    @Nullable
    public Function<Void> getVisibleEventHandler() {
        return this.mVisibleEventHandler;
    }

    @Nullable
    public Function<Void> getInvisibleEventHandler() {
        return this.mInvisibleEventHandler;
    }

    @Nullable
    public Function<Void> getFocusedEventHandler() {
        return this.mFocusedEventHandler;
    }

    @Nullable
    public Function<Void> getUnfocusedEventHandler() {
        return this.mUnfocusedEventHandler;
    }

    @Nullable
    public Function<Void> getFullImpressionEventHandler() {
        return this.mFullImpressionEventHandler;
    }

    @Nullable
    public Function<Void> getVisibilityChangedEventHandler() {
        return this.mVisibilityChangedEventHandler;
    }

    public static interface Factory<R extends Node.LayoutResult<?>> {
        @Nullable
        public VisibilityOutput createVisibilityOutput(R var1, Rect var2);

        public boolean hasRenderTreeHosts(R var1);
    }
}

