/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.visibility;

import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.facebook.rendercore.Function;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.visibility.VisibilityExtensionConfigs;
import com.facebook.rendercore.visibility.VisibilityExtensionInput;
import com.facebook.rendercore.visibility.VisibilityItem;
import com.facebook.rendercore.visibility.VisibilityOutput;
import com.facebook.rendercore.visibility.VisibilityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisibilityMountExtension<Input extends VisibilityExtensionInput>
extends MountExtension<Input, VisibilityMountExtensionState> {
    private static final VisibilityMountExtension sInstance = new VisibilityMountExtension();
    private static final boolean IS_JELLYBEAN_OR_HIGHER = Build.VERSION.SDK_INT >= 16;

    private VisibilityMountExtension() {
    }

    public static VisibilityMountExtension getInstance() {
        return sInstance;
    }

    public VisibilityMountExtensionState createState() {
        return new VisibilityMountExtensionState();
    }

    public void beforeMount(ExtensionState<VisibilityMountExtensionState> extensionState, Input input, @Nullable Rect localVisibleRect) {
        VisibilityUtils.log("beforeMount");
        RenderCoreSystrace.beginSection((String)"VisibilityExtension.beforeMount");
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        state.mVisibilityOutputs = input.getVisibilityOutputs();
        state.mRenderUnitIdsWhichHostRenderTrees = input.getRenderUnitIdsWhichHostRenderTrees();
        state.mPreviousLocalVisibleRect.setEmpty();
        state.mCurrentLocalVisibleRect = localVisibleRect;
        RenderCoreSystrace.endSection();
    }

    public void afterMount(ExtensionState<VisibilityMountExtensionState> extensionState) {
        boolean processVisibilityOutputs;
        VisibilityUtils.log("afterMount");
        RenderCoreSystrace.beginSection((String)"VisibilityExtension.afterMount");
        boolean bl = processVisibilityOutputs = !VisibilityMountExtension.hasTransientState(extensionState);
        if (processVisibilityOutputs) {
            VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
            VisibilityMountExtension.processVisibilityOutputs(extensionState, state.mCurrentLocalVisibleRect, true);
        }
        RenderCoreSystrace.endSection();
    }

    public void onVisibleBoundsChanged(ExtensionState<VisibilityMountExtensionState> extensionState, @Nullable Rect localVisibleRect) {
        boolean processVisibilityOutputs = !VisibilityMountExtension.hasTransientState(extensionState);
        VisibilityUtils.log("onVisibleBoundsChanged [hasTransientState=" + VisibilityMountExtension.hasTransientState(extensionState) + "]");
        RenderCoreSystrace.beginSection((String)"VisibilityExtension.onVisibleBoundsChanged");
        if (processVisibilityOutputs) {
            VisibilityMountExtension.processVisibilityOutputs(extensionState, localVisibleRect, false);
        }
        RenderCoreSystrace.endSection();
    }

    public void onUnbind(ExtensionState<VisibilityMountExtensionState> extensionState) {
        VisibilityMountExtension.clearVisibilityItems(extensionState);
    }

    public void onUnmount(ExtensionState<VisibilityMountExtensionState> extensionState) {
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        state.mPreviousLocalVisibleRect.setEmpty();
    }

    @VisibleForTesting
    public static Map<String, VisibilityItem> getVisibilityIdToItemMap(ExtensionState<VisibilityMountExtensionState> extensionState) {
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        return state.mVisibilityIdToItemMap;
    }

    @UiThread
    public static void clearVisibilityItems(ExtensionState<VisibilityMountExtensionState> extensionState) {
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        VisibilityMountExtension.clearVisibilityItemsNonincremental(state);
        state.mPreviousLocalVisibleRect.setEmpty();
    }

    @Deprecated
    public static void setRootHost(ExtensionState<VisibilityMountExtensionState> extensionState, Host root) {
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        state.mRootHost = root;
    }

    public static void notifyOnUnbind(ExtensionState<VisibilityMountExtensionState> extensionState) {
        VisibilityMountExtension.clearVisibilityItems(extensionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    private static void processVisibilityOutputs(ExtensionState<VisibilityMountExtensionState> extensionState, @Nullable Rect localVisibleRect, boolean isDirty) {
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        try {
            VisibilityUtils.log("processVisibilityOutputs");
            RenderCoreSystrace.beginSection((String)"VisibilityExtension.processVisibilityOutputs");
            VisibilityMountExtension.processVisibilityOutputsNonInc(extensionState, localVisibleRect, isDirty);
        }
        finally {
            RenderCoreSystrace.endSection();
        }
        if (localVisibleRect != null) {
            state.mPreviousLocalVisibleRect.set(localVisibleRect);
        }
    }

    @UiThread
    private static void processVisibilityOutputsNonInc(ExtensionState<VisibilityMountExtensionState> extensionState, @Nullable Rect localVisibleRect, boolean isDirty) {
        Rect previousVisibleRect = ((VisibilityMountExtensionState)extensionState.getState()).mPreviousLocalVisibleRect;
        if (localVisibleRect == null || !isDirty && previousVisibleRect.equals((Object)localVisibleRect)) {
            VisibilityUtils.log("Skip Processing: [isDirty=" + isDirty + ", previousVisibleRect=" + previousVisibleRect + "]");
            return;
        }
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        int size = state.mVisibilityOutputs.size();
        VisibilityUtils.log("Visibility Outputs to process: " + size);
        Rect intersection = new Rect();
        for (int j = 0; j < size; ++j) {
            boolean isCurrentlyVisible;
            boolean wasFullyVisible;
            VisibilityOutput visibilityOutput = (VisibilityOutput)state.mVisibilityOutputs.get(j);
            String componentName = visibilityOutput.getKey();
            VisibilityUtils.log("Processing Visibility for: " + componentName);
            RenderCoreSystrace.beginSection((String)("visibilityHandlers:" + componentName));
            Rect visibilityOutputBounds = visibilityOutput.getBounds();
            boolean boundsIntersect = intersection.setIntersect(visibilityOutputBounds, localVisibleRect);
            boolean isFullyVisible = boundsIntersect && intersection.equals((Object)visibilityOutputBounds);
            String visibilityOutputId = visibilityOutput.getId();
            VisibilityItem visibilityItem = (VisibilityItem)state.mVisibilityIdToItemMap.get(visibilityOutputId);
            if (visibilityItem != null) {
                wasFullyVisible = visibilityItem.wasFullyVisible();
                visibilityItem.setWasFullyVisible(isFullyVisible);
            } else {
                wasFullyVisible = false;
            }
            if (isFullyVisible && wasFullyVisible && VisibilityExtensionConfigs.skipVisChecksForFullyVisible) {
                RenderCoreSystrace.endSection();
                visibilityItem.setDoNotClearInThisPass(isDirty);
                continue;
            }
            Function<Void> visibleHandler = visibilityOutput.getVisibleEventHandler();
            Function<Void> focusedHandler = visibilityOutput.getFocusedEventHandler();
            Function<Void> unfocusedHandler = visibilityOutput.getUnfocusedEventHandler();
            Function<Void> fullImpressionHandler = visibilityOutput.getFullImpressionEventHandler();
            Function<Void> invisibleHandler = visibilityOutput.getInvisibleEventHandler();
            Function<Void> visibilityChangedHandler = visibilityOutput.getVisibilityChangedEventHandler();
            boolean bl = isCurrentlyVisible = boundsIntersect && VisibilityMountExtension.isInVisibleRange(visibilityOutput, visibilityOutputBounds, intersection);
            if (visibilityItem != null) {
                visibilityItem.setUnfocusedHandler(unfocusedHandler);
                visibilityItem.setInvisibleHandler(invisibleHandler);
                if (!isCurrentlyVisible) {
                    if (visibilityItem.getInvisibleHandler() != null) {
                        VisibilityUtils.dispatchOnInvisible(visibilityItem.getInvisibleHandler());
                    }
                    if (visibilityChangedHandler != null) {
                        VisibilityUtils.dispatchOnVisibilityChanged(visibilityChangedHandler, 0, 0, 0, 0, 0.0f, 0.0f);
                    }
                    if (visibilityItem.isInFocusedRange()) {
                        visibilityItem.setFocusedRange(false);
                        if (visibilityItem.getUnfocusedHandler() != null) {
                            VisibilityUtils.dispatchOnUnfocused(visibilityItem.getUnfocusedHandler());
                        }
                    }
                    state.mVisibilityIdToItemMap.remove(visibilityOutputId);
                    visibilityItem = null;
                } else {
                    visibilityItem.setDoNotClearInThisPass(isDirty);
                }
            }
            if (isCurrentlyVisible) {
                if (visibilityItem == null) {
                    String globalKey = visibilityOutput.getId();
                    visibilityItem = new VisibilityItem(globalKey, invisibleHandler, unfocusedHandler, visibilityChangedHandler);
                    visibilityItem.setDoNotClearInThisPass(isDirty);
                    visibilityItem.setWasFullyVisible(isFullyVisible);
                    state.mVisibilityIdToItemMap.put(visibilityOutputId, visibilityItem);
                    if (visibleHandler != null) {
                        Object content = visibilityOutput.hasMountableContent ? VisibilityMountExtension.getContentById(extensionState, (long)visibilityOutput.mRenderUnitId) : null;
                        VisibilityUtils.dispatchOnVisible(visibleHandler, content);
                    }
                }
                if (focusedHandler != null || unfocusedHandler != null) {
                    if (VisibilityMountExtension.isInFocusedRange(extensionState, visibilityOutputBounds, intersection)) {
                        if (!visibilityItem.isInFocusedRange()) {
                            visibilityItem.setFocusedRange(true);
                            if (focusedHandler != null) {
                                VisibilityUtils.dispatchOnFocused(focusedHandler);
                            }
                        }
                    } else if (visibilityItem.isInFocusedRange()) {
                        visibilityItem.setFocusedRange(false);
                        if (unfocusedHandler != null) {
                            VisibilityUtils.dispatchOnUnfocused(unfocusedHandler);
                        }
                    }
                }
                if (fullImpressionHandler != null && !visibilityItem.isInFullImpressionRange()) {
                    visibilityItem.setVisibleEdges(visibilityOutputBounds, intersection);
                    if (visibilityItem.isInFullImpressionRange()) {
                        VisibilityUtils.dispatchOnFullImpression(fullImpressionHandler);
                    }
                }
                if (visibilityChangedHandler != null) {
                    int visibleWidth = intersection.right - intersection.left;
                    int visibleHeight = intersection.bottom - intersection.top;
                    VisibilityUtils.dispatchOnVisibilityChanged(visibilityChangedHandler, intersection.top, intersection.left, visibleWidth, visibleHeight, 100.0f * (float)visibleWidth / (float)visibilityOutputBounds.width(), 100.0f * (float)visibleHeight / (float)visibilityOutputBounds.height());
                }
            }
            RenderCoreSystrace.endSection();
        }
        Iterator iterator = state.mRenderUnitIdsWhichHostRenderTrees.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            VisibilityUtils.log("RecursivelyNotify:RenderUnit[id=" + id + "]");
            RenderCoreExtension.recursivelyNotifyVisibleBoundsChanged((Object)extensionState.getMountDelegate().getContentById(id));
        }
        if (isDirty) {
            VisibilityMountExtension.clearVisibilityItems(extensionState);
        }
    }

    private static boolean isInVisibleRange(VisibilityOutput visibilityOutput, Rect bounds, Rect visibleBounds) {
        float heightRatio = visibilityOutput.getVisibleHeightRatio();
        float widthRatio = visibilityOutput.getVisibleWidthRatio();
        if (heightRatio == 0.0f && widthRatio == 0.0f) {
            return true;
        }
        return VisibilityMountExtension.isInRatioRange(heightRatio, bounds.height(), visibleBounds.height()) && VisibilityMountExtension.isInRatioRange(widthRatio, bounds.width(), visibleBounds.width());
    }

    private static boolean isInFocusedRange(ExtensionState<VisibilityMountExtensionState> extensionState, Rect componentBounds, Rect componentVisibleBounds) {
        Host host = VisibilityMountExtension.getRootHost(extensionState);
        if (host == null) {
            return false;
        }
        View parent = (View)host.getParent();
        if (parent == null) {
            return false;
        }
        int halfViewportArea = parent.getWidth() * parent.getHeight() / 2;
        int totalComponentArea = VisibilityMountExtension.computeRectArea(componentBounds);
        int visibleComponentArea = VisibilityMountExtension.computeRectArea(componentVisibleBounds);
        return totalComponentArea >= halfViewportArea ? visibleComponentArea >= halfViewportArea : componentBounds.equals((Object)componentVisibleBounds);
    }

    @UiThread
    private static void clearVisibilityItemsNonincremental(VisibilityMountExtensionState state) {
        RenderCoreSystrace.beginSection((String)"VisibilityExtension.clearIncrementalItems");
        ArrayList toClear = new ArrayList();
        for (Map.Entry entry : state.mVisibilityIdToItemMap.entrySet()) {
            VisibilityItem visibilityItem = (VisibilityItem)entry.getValue();
            if (visibilityItem.doNotClearInThisPass()) {
                visibilityItem.setDoNotClearInThisPass(false);
                continue;
            }
            toClear.add(entry.getKey());
        }
        int size = toClear.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)toClear.get(i);
            VisibilityItem visibilityItem = (VisibilityItem)state.mVisibilityIdToItemMap.get(key);
            if (visibilityItem != null) {
                Function<Void> invisibleHandler = visibilityItem.getInvisibleHandler();
                Function<Void> unfocusedHandler = visibilityItem.getUnfocusedHandler();
                Function<Void> visibilityChangedHandler = visibilityItem.getVisibilityChangedHandler();
                if (invisibleHandler != null) {
                    VisibilityUtils.dispatchOnInvisible(invisibleHandler);
                }
                if (visibilityItem.isInFocusedRange()) {
                    visibilityItem.setFocusedRange(false);
                    if (unfocusedHandler != null) {
                        VisibilityUtils.dispatchOnUnfocused(unfocusedHandler);
                    }
                }
                if (visibilityChangedHandler != null) {
                    VisibilityUtils.dispatchOnVisibilityChanged(visibilityChangedHandler, 0, 0, 0, 0, 0.0f, 0.0f);
                }
                visibilityItem.setWasFullyVisible(false);
            }
            state.mVisibilityIdToItemMap.remove(key);
        }
        RenderCoreSystrace.endSection();
    }

    private static boolean hasTransientState(ExtensionState<VisibilityMountExtensionState> state) {
        Host host = VisibilityMountExtension.getRootHost(state);
        return IS_JELLYBEAN_OR_HIGHER && host != null && host.hasTransientState();
    }

    @Nullable
    private static Host getRootHost(ExtensionState<VisibilityMountExtensionState> extensionState) {
        VisibilityMountExtensionState state = (VisibilityMountExtensionState)extensionState.getState();
        if (state.mRootHost == null) {
            return extensionState.getRootHost();
        }
        return state.mRootHost;
    }

    private static boolean isInRatioRange(float ratio, int length, int visibleLength) {
        return (float)visibleLength >= ratio * (float)length;
    }

    private static int computeRectArea(Rect rect) {
        return rect.isEmpty() ? 0 : rect.width() * rect.height();
    }

    public static class VisibilityMountExtensionState {
        private final Map<String, VisibilityItem> mVisibilityIdToItemMap = new HashMap<String, VisibilityItem>();
        private final Rect mPreviousLocalVisibleRect = new Rect();
        private List<VisibilityOutput> mVisibilityOutputs = Collections.emptyList();
        private Set<Long> mRenderUnitIdsWhichHostRenderTrees = Collections.emptySet();
        @Nullable
        private Rect mCurrentLocalVisibleRect;
        @Deprecated
        @Nullable
        private Host mRootHost;

        private VisibilityMountExtensionState() {
        }
    }
}

