/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.visibility;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Function;

public class VisibilityItem {
    private static final int FLAG_LEFT_EDGE_VISIBLE = 2;
    private static final int FLAG_TOP_EDGE_VISIBLE = 4;
    private static final int FLAG_RIGHT_EDGE_VISIBLE = 8;
    private static final int FLAG_BOTTOM_EDGE_VISIBLE = 16;
    private static final int FLAG_FOCUSED_RANGE = 32;
    private final String mKey;
    @Nullable
    private final Function<Void> mVisibilityChangedHandler;
    @Nullable
    private Function<Void> mInvisibleHandler;
    @Nullable
    private Function<Void> mUnfocusedHandler;
    private boolean mDoNotClearInThisPass;
    private boolean mWasFullyVisible;
    private int mFlags;

    public VisibilityItem(String key, @Nullable Function<Void> invisibleHandler, @Nullable Function<Void> unfocusedHandler, @Nullable Function<Void> visibilityChangedHandler) {
        this.mKey = key;
        this.mInvisibleHandler = invisibleHandler;
        this.mUnfocusedHandler = unfocusedHandler;
        this.mVisibilityChangedHandler = visibilityChangedHandler;
    }

    public String getKey() {
        return this.mKey;
    }

    public void setInvisibleHandler(@Nullable Function<Void> invisibleHandler) {
        this.mInvisibleHandler = invisibleHandler;
    }

    @Nullable
    public Function<Void> getInvisibleHandler() {
        return this.mInvisibleHandler;
    }

    public void setUnfocusedHandler(@Nullable Function<Void> unfocusedHandler) {
        this.mUnfocusedHandler = unfocusedHandler;
    }

    @Nullable
    public Function<Void> getUnfocusedHandler() {
        return this.mUnfocusedHandler;
    }

    @Nullable
    public Function<Void> getVisibilityChangedHandler() {
        return this.mVisibilityChangedHandler;
    }

    public boolean isInFocusedRange() {
        return (this.mFlags & 0x20) != 0;
    }

    public void setFocusedRange(boolean isFocused) {
        this.mFlags = isFocused ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    public boolean isInFullImpressionRange() {
        int allEdgesVisible = 30;
        return (this.mFlags & 0x1E) == 30;
    }

    public void setVisibleEdges(Rect componentBounds, Rect componentVisibleBounds) {
        if (componentBounds.top == componentVisibleBounds.top) {
            this.mFlags |= 4;
        }
        if (componentBounds.bottom == componentVisibleBounds.bottom) {
            this.mFlags |= 0x10;
        }
        if (componentBounds.left == componentVisibleBounds.left) {
            this.mFlags |= 2;
        }
        if (componentBounds.right == componentVisibleBounds.right) {
            this.mFlags |= 8;
        }
    }

    public boolean doNotClearInThisPass() {
        return this.mDoNotClearInThisPass;
    }

    public void setDoNotClearInThisPass(boolean doNotClearInThisPass) {
        this.mDoNotClearInThisPass = doNotClearInThisPass;
    }

    public boolean wasFullyVisible() {
        return this.mWasFullyVisible;
    }

    public void setWasFullyVisible(boolean fullyVisible) {
        this.mWasFullyVisible = fullyVisible;
    }
}

