/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.visibility;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import com.facebook.rendercore.Node;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.LayoutResultVisitor;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.visibility.VisibilityExtensionInput;
import com.facebook.rendercore.visibility.VisibilityMountExtension;
import com.facebook.rendercore.visibility.VisibilityOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class VisibilityExtension
extends RenderCoreExtension<Results, VisibilityMountExtension.VisibilityMountExtensionState> {
    private final Visitor visitor;
    private final VisibilityMountExtension<Results> mountExtension = VisibilityMountExtension.getInstance();

    public VisibilityExtension(VisibilityOutput.Factory<?> factory) {
        this.visitor = new Visitor(factory);
    }

    public Visitor getLayoutVisitor() {
        return this.visitor;
    }

    public VisibilityMountExtension<Results> getMountExtension() {
        return this.mountExtension;
    }

    public Results createInput() {
        return new Results();
    }

    public static class Visitor
    implements LayoutResultVisitor<Results> {
        private final VisibilityOutput.Factory factory;

        public Visitor(VisibilityOutput.Factory factory) {
            this.factory = factory;
        }

        public void visit(@Nullable RenderTreeNode parent, Node.LayoutResult<?> layoutResult, Rect bounds, int x, int y, int position, @Nullable Results results) {
            if (position == 0) {
                return;
            }
            if (results != null) {
                Rect absoluteBounds = new Rect(x, y, x + bounds.width(), y + bounds.height());
                results.addOutput(this.factory.createVisibilityOutput(layoutResult, absoluteBounds));
                if (this.factory.hasRenderTreeHosts(layoutResult)) {
                    RenderUnit unit = layoutResult.getRenderUnit();
                    if (unit == null) {
                        throw new IllegalArgumentException("Layout results which host RenderTrees must have a RenderUnit");
                    }
                    results.addRenderUnitIdWhichHostsRenderTree(unit.getId());
                }
            }
        }
    }

    public static class Results
    implements VisibilityExtensionInput {
        private final List<VisibilityOutput> outputs = new ArrayList<VisibilityOutput>(8);
        private final Set<Long> renderUnitIdsWhichHostRenderTrees = new ArraySet(4);

        @Override
        public List<VisibilityOutput> getVisibilityOutputs() {
            return this.outputs;
        }

        @Override
        public Set<Long> getRenderUnitIdsWhichHostRenderTrees() {
            return this.renderUnitIdsWhichHostRenderTrees;
        }

        void addOutput(@Nullable VisibilityOutput output) {
            if (output != null) {
                this.outputs.add(output);
            }
        }

        void addRenderUnitIdWhichHostsRenderTree(long id) {
            this.renderUnitIdsWhichHostRenderTrees.add(id);
        }
    }
}

