/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.transitions;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperty;
import java.util.ArrayList;
import java.util.List;

public class TransitionUtils {
    public static void applySizeToDrawableForAnimation(Drawable drawable, int width, int height) {
        Rect bounds = drawable.getBounds();
        drawable.setBounds(bounds.left, bounds.top, bounds.left + width, bounds.top + height);
        if (drawable instanceof BoundsCallback) {
            ((BoundsCallback)drawable).onWidthHeightBoundsApplied(width, height);
        }
    }

    public static void applyXYToDrawableForAnimation(Drawable drawable, int x, int y) {
        Rect bounds = drawable.getBounds();
        drawable.setBounds(x, y, bounds.width() + x, bounds.height() + y);
        if (drawable instanceof BoundsCallback) {
            ((BoundsCallback)drawable).onXYBoundsApplied(x, y);
        }
    }

    public static void collectRootBoundsTransitions(TransitionId rootTransitionId, Transition transition, AnimatedProperty property, Transition.RootBoundsTransition outRootBoundsTransition) {
        if (transition instanceof TransitionSet) {
            ArrayList<Transition> children = ((TransitionSet)transition).getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, children.get(i), property, outRootBoundsTransition);
            }
        } else if (transition instanceof Transition.TransitionUnit) {
            Transition.TransitionUnit transitionUnit = (Transition.TransitionUnit)transition;
            if (transitionUnit.targets(rootTransitionId) && transitionUnit.targetsProperty(property)) {
                outRootBoundsTransition.hasTransition = true;
                if (transitionUnit.hasAppearAnimation()) {
                    outRootBoundsTransition.appearTransition = transitionUnit;
                }
            }
        } else if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            Transition.BaseTransitionUnitsBuilder builder = (Transition.BaseTransitionUnitsBuilder)transition;
            ArrayList<Transition.TransitionUnit> units = builder.getTransitionUnits();
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, units.get(i), property, outRootBoundsTransition);
            }
        } else {
            throw new RuntimeException("Unhandled transition type: " + transition);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static TransitionId createTransitionId(@Nullable String transitionKey, Transition.TransitionKeyType transitionKeyType, String transitionOwnerKey, @Nullable String transitionGlobalKey) {
        String extraData;
        int type;
        String reference;
        if (!TextUtils.isEmpty((CharSequence)transitionKey)) {
            reference = transitionKey;
            if (transitionKeyType == Transition.TransitionKeyType.GLOBAL) {
                type = 1;
                extraData = null;
            } else {
                if (transitionKeyType != Transition.TransitionKeyType.LOCAL) throw new IllegalArgumentException("Unhandled transition key type " + (Object)((Object)transitionKeyType));
                type = 2;
                extraData = transitionOwnerKey;
            }
        } else {
            type = 3;
            reference = transitionGlobalKey;
            extraData = null;
        }
        if (reference == null) return null;
        TransitionId transitionId = new TransitionId(type, reference, extraData);
        return transitionId;
    }

    public static void addTransitions(Transition transition, List<Transition> outList, @Nullable String logContext) {
        if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            outList.addAll(((Transition.BaseTransitionUnitsBuilder)transition).getTransitionUnits());
        } else if (transition != null) {
            outList.add(transition);
        } else {
            throw new IllegalStateException("[" + logContext + "] Adding null to transition list is not allowed.");
        }
    }

    public static void setOwnerKey(Transition transition, @Nullable String ownerKey) {
        if (transition instanceof Transition.TransitionUnit) {
            ((Transition.TransitionUnit)transition).setOwnerKey(ownerKey);
        } else if (transition instanceof TransitionSet) {
            ArrayList<Transition> children = ((TransitionSet)transition).getChildren();
            for (int index = children.size() - 1; index >= 0; --index) {
                TransitionUtils.setOwnerKey(children.get(index), ownerKey);
            }
        } else if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            ArrayList<Transition.TransitionUnit> units = ((Transition.BaseTransitionUnitsBuilder)transition).getTransitionUnits();
            for (int index = units.size() - 1; index >= 0; --index) {
                units.get(index).setOwnerKey(ownerKey);
            }
        } else {
            throw new RuntimeException("Unhandled transition type: " + transition);
        }
    }

    public static interface BoundsCallback {
        public void onWidthHeightBoundsApplied(int var1, int var2);

        public void onXYBoundsApplied(int var1, int var2);
    }
}

