/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import androidx.core.util.Pair;
import com.facebook.litho.choreographercompat.ChoreographerCompat;
import com.facebook.litho.dataflow.DataFlowGraph;
import com.facebook.litho.dataflow.TimingSource;
import java.util.ArrayList;

public class MockTimingSource
implements TimingSource,
ChoreographerCompat {
    public static int FRAME_TIME_MS = 16;
    private static final long FRAME_TIME_NANOS = (long)((double)FRAME_TIME_MS * 1000000.0);
    private final ArrayList<Pair<ChoreographerCompat.FrameCallback, Long>> mChoreographerCallbacksToStartTimes = new ArrayList();
    private DataFlowGraph mDataFlowGraph;
    private boolean mIsRunning = false;
    private long mCurrentTimeNanos = 0L;

    @Override
    public void setDataFlowGraph(DataFlowGraph dataFlowGraph) {
        this.mDataFlowGraph = dataFlowGraph;
    }

    @Override
    public void start() {
        this.mIsRunning = true;
    }

    @Override
    public void stop() {
        this.mIsRunning = false;
    }

    public void step(int numFrames) {
        for (int i = 0; i < numFrames; ++i) {
            if (!this.mIsRunning) {
                return;
            }
            this.mCurrentTimeNanos += FRAME_TIME_NANOS;
            this.mDataFlowGraph.doFrame(this.mCurrentTimeNanos);
            this.fireChoreographerCallbacks();
        }
    }

    private void fireChoreographerCallbacks() {
        int size = this.mChoreographerCallbacksToStartTimes.size();
        for (int i = 0; i < size; ++i) {
            Pair<ChoreographerCompat.FrameCallback, Long> entry = this.mChoreographerCallbacksToStartTimes.get(i);
            if ((Long)entry.second > this.mCurrentTimeNanos) continue;
            ((ChoreographerCompat.FrameCallback)entry.first).doFrame(this.mCurrentTimeNanos);
            this.mChoreographerCallbacksToStartTimes.remove(i);
            --i;
            --size;
        }
    }

    @Override
    public void postFrameCallback(ChoreographerCompat.FrameCallback callbackWrapper) {
        this.postFrameCallbackDelayed(callbackWrapper, 0L);
    }

    @Override
    public void postFrameCallbackDelayed(ChoreographerCompat.FrameCallback callbackWrapper, long delayMillis) {
        this.mChoreographerCallbacksToStartTimes.add((Pair<ChoreographerCompat.FrameCallback, Long>)new Pair((Object)callbackWrapper, (Object)((long)((double)this.mCurrentTimeNanos + (double)delayMillis * 1000000.0))));
    }

    @Override
    public void removeFrameCallback(ChoreographerCompat.FrameCallback callbackWrapper) {
        for (int i = this.mChoreographerCallbacksToStartTimes.size() - 1; i >= 0; --i) {
            Pair<ChoreographerCompat.FrameCallback, Long> entry = this.mChoreographerCallbacksToStartTimes.get(i);
            if (entry.first != callbackWrapper) continue;
            this.mChoreographerCallbacksToStartTimes.remove(i);
        }
    }
}

