/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.collection.SimpleArrayMap;
import com.facebook.litho.dataflow.ChoreographerTimingSource;
import com.facebook.litho.dataflow.DetectedCycleException;
import com.facebook.litho.dataflow.GraphBinding;
import com.facebook.litho.dataflow.NodeCanFinish;
import com.facebook.litho.dataflow.TimingSource;
import com.facebook.litho.dataflow.ValueNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class DataFlowGraph {
    private static final String STATE_NOT_INTIALIZED_FOR_VALUE_NODE = "DataFlowGraph:StateNotInitializedForValueNode";
    private static DataFlowGraph sInstance;
    @GuardedBy(value="this")
    private final TimingSource mTimingSource;
    @GuardedBy(value="this")
    private final ArrayList<GraphBinding> mBindings = new ArrayList();
    @GuardedBy(value="this")
    private final ArrayList<ValueNode> mSortedNodes = new ArrayList();
    @GuardedBy(value="this")
    private final Map<ValueNode, NodeState> mNodeStates = new HashMap<ValueNode, NodeState>();
    private boolean mIsDirty = false;

    public static DataFlowGraph getInstance() {
        if (sInstance == null) {
            ChoreographerTimingSource timingSource = new ChoreographerTimingSource();
            sInstance = new DataFlowGraph(timingSource);
            timingSource.setDataFlowGraph(sInstance);
        }
        return sInstance;
    }

    @VisibleForTesting
    public static void setInstance(@Nullable DataFlowGraph dataFlowGraph) {
        sInstance = dataFlowGraph;
    }

    @VisibleForTesting
    public static DataFlowGraph create(TimingSource timingSource) {
        DataFlowGraph instance = new DataFlowGraph(timingSource);
        timingSource.setDataFlowGraph(instance);
        return instance;
    }

    private DataFlowGraph(TimingSource timingSource) {
        this.mTimingSource = timingSource;
    }

    public synchronized void register(GraphBinding binding) {
        if (!binding.isActive()) {
            throw new RuntimeException("Expected added GraphBinding to be active: " + binding);
        }
        this.mBindings.add(binding);
        this.registerNodes(binding);
        if (this.mBindings.size() == 1) {
            this.mTimingSource.start();
        }
        this.mIsDirty = true;
    }

    public synchronized void unregister(GraphBinding binding) {
        if (!this.mBindings.remove(binding)) {
            throw new RuntimeException("Tried to unregister non-existent binding");
        }
        this.unregisterNodes(binding);
        if (this.mBindings.isEmpty()) {
            this.mTimingSource.stop();
            this.mSortedNodes.clear();
            if (!this.mNodeStates.isEmpty()) {
                throw new RuntimeException("Failed to clean up all nodes");
            }
        }
        this.mIsDirty = true;
    }

    synchronized void doFrame(long frameTimeNanos) {
        if (this.mIsDirty) {
            this.regenerateSortedNodes();
        }
        this.propagate(frameTimeNanos);
        this.updateFinishedStates();
    }

    @GuardedBy(value="this")
    private void propagate(long frameTimeNanos) {
        int size = this.mSortedNodes.size();
        for (int i = 0; i < size; ++i) {
            ValueNode node = this.mSortedNodes.get(i);
            node.doCalculateValue(frameTimeNanos);
        }
    }

    @GuardedBy(value="this")
    private void regenerateSortedNodes() {
        this.mSortedNodes.clear();
        if (this.mBindings.size() == 0) {
            return;
        }
        ArraySet leafNodes = new ArraySet();
        SimpleArrayMap nodesToOutputsLeft = new SimpleArrayMap();
        int bindingsSize = this.mBindings.size();
        for (int i = 0; i < bindingsSize; ++i) {
            ArrayList<ValueNode> nodes = this.mBindings.get(i).getAllNodes();
            int nodesSize = nodes.size();
            for (int j = 0; j < nodesSize; ++j) {
                ValueNode node = nodes.get(j);
                int outputCount = node.getOutputCount();
                if (outputCount == 0) {
                    leafNodes.add((Object)node);
                    continue;
                }
                nodesToOutputsLeft.put((Object)node, (Object)outputCount);
            }
        }
        if (!nodesToOutputsLeft.isEmpty() && leafNodes.isEmpty()) {
            throw new DetectedCycleException("Graph has nodes, but they represent a cycle with no leaf nodes!");
        }
        ArrayDeque<ValueNode> nodesToProcess = new ArrayDeque<ValueNode>();
        nodesToProcess.addAll((Collection<ValueNode>)leafNodes);
        while (!nodesToProcess.isEmpty()) {
            ValueNode next = (ValueNode)nodesToProcess.pollFirst();
            this.mSortedNodes.add(next);
            for (ValueNode input : next.getAllInputs()) {
                int outputsLeft = (Integer)nodesToOutputsLeft.get((Object)input) - 1;
                nodesToOutputsLeft.put((Object)input, (Object)outputsLeft);
                if (outputsLeft == 0) {
                    nodesToProcess.addLast(input);
                    continue;
                }
                if (outputsLeft >= 0) continue;
                throw new DetectedCycleException("Detected cycle.");
            }
        }
        int expectedTotalNodes = nodesToOutputsLeft.size() + leafNodes.size();
        if (this.mSortedNodes.size() != expectedTotalNodes) {
            throw new DetectedCycleException("Had unreachable nodes in graph -- this likely means there was a cycle");
        }
        Collections.reverse(this.mSortedNodes);
        this.mIsDirty = false;
    }

    @GuardedBy(value="this")
    private void updateFinishedStates() {
        this.updateFinishedNodes();
        this.notifyFinishedBindings();
    }

    @GuardedBy(value="this")
    private void updateFinishedNodes() {
        int size = this.mSortedNodes.size();
        for (int i = 0; i < size; ++i) {
            boolean nodeIsNowFinished;
            ValueNode node = this.mSortedNodes.get(i);
            NodeState nodeState = this.mNodeStates.get(node);
            if (nodeState == null || nodeState.isFinished || !this.areInputsFinished(node)) continue;
            boolean bl = nodeIsNowFinished = !(node instanceof NodeCanFinish) || ((NodeCanFinish)((Object)node)).isFinished();
            if (!nodeIsNowFinished) continue;
            nodeState.isFinished = true;
        }
    }

    @GuardedBy(value="this")
    private boolean areInputsFinished(ValueNode node) {
        for (ValueNode input : node.getAllInputs()) {
            NodeState nodeState = this.mNodeStates.get(input);
            if (nodeState.isFinished) continue;
            return false;
        }
        return true;
    }

    @GuardedBy(value="this")
    private void notifyFinishedBindings() {
        for (int i = this.mBindings.size() - 1; i >= 0; --i) {
            GraphBinding binding = this.mBindings.get(i);
            boolean allAreFinished = true;
            ArrayList<ValueNode> nodesToCheck = binding.getAllNodes();
            int nodesSize = nodesToCheck.size();
            for (int j = 0; j < nodesSize; ++j) {
                NodeState nodeState = this.mNodeStates.get(nodesToCheck.get(j));
                if (nodeState.isFinished) continue;
                allAreFinished = false;
                break;
            }
            if (!allAreFinished) continue;
            binding.notifyNodesHaveFinished();
        }
    }

    @GuardedBy(value="this")
    private void registerNodes(GraphBinding binding) {
        ArrayList<ValueNode> nodes = binding.getAllNodes();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            ValueNode node = nodes.get(i);
            NodeState nodeState = this.mNodeStates.get(node);
            if (nodeState != null) {
                nodeState.refCount++;
                continue;
            }
            NodeState newState = new NodeState();
            newState.refCount = 1;
            this.mNodeStates.put(node, newState);
        }
    }

    @GuardedBy(value="this")
    private void unregisterNodes(GraphBinding binding) {
        ArrayList<ValueNode> nodes = binding.getAllNodes();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            ValueNode node = nodes.get(i);
            NodeState nodeState = this.mNodeStates.get(node);
            nodeState.refCount--;
            if (nodeState.refCount != 0) continue;
            this.mNodeStates.remove(node);
        }
    }

    @VisibleForTesting
    @GuardedBy(value="this")
    boolean hasReferencesToNodes() {
        return !this.mBindings.isEmpty() || !this.mSortedNodes.isEmpty() || !this.mNodeStates.isEmpty();
    }

    private static class NodeState {
        private boolean isFinished = false;
        private int refCount = 0;

        private NodeState() {
        }
    }
}

