/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.choreographercompat;

import android.annotation.TargetApi;
import android.view.Choreographer;
import com.facebook.litho.WorkContinuationInstrumenter;
import java.util.concurrent.atomic.AtomicReference;

public interface ChoreographerCompat {
    public void postFrameCallback(FrameCallback var1);

    public void postFrameCallbackDelayed(FrameCallback var1, long var2);

    public void removeFrameCallback(FrameCallback var1);

    public static abstract class FrameCallback {
        private Runnable mRunnable;
        private Choreographer.FrameCallback mFrameCallback;
        final AtomicReference<Object> mTokenReference = new AtomicReference();

        @TargetApi(value=16)
        Choreographer.FrameCallback getFrameCallback() {
            if (this.mFrameCallback == null) {
                this.mFrameCallback = new Choreographer.FrameCallback(){

                    public void doFrame(long frameTimeNanos) {
                        FrameCallback.this.doFrameInternal(frameTimeNanos);
                    }
                };
            }
            return this.mFrameCallback;
        }

        Runnable getRunnable() {
            if (this.mRunnable == null) {
                this.mRunnable = new Runnable(){

                    @Override
                    public void run() {
                        FrameCallback.this.doFrameInternal(System.nanoTime());
                    }
                };
            }
            return this.mRunnable;
        }

        private void doFrameInternal(long frameTimeNanos) {
            Object continuationToken = WorkContinuationInstrumenter.onBeginWorkContinuation("ChoreographerCompat_doFrame", this.mTokenReference.getAndSet(null));
            try {
                this.doFrame(frameTimeNanos);
            }
            catch (Throwable th) {
                WorkContinuationInstrumenter.markFailure(continuationToken, th);
                throw th;
            }
            finally {
                WorkContinuationInstrumenter.onEndWorkContinuation(continuationToken);
            }
        }

        public abstract void doFrame(long var1);
    }
}

