/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import androidx.annotation.VisibleForTesting;
import com.facebook.litho.animation.BaseAnimationBinding;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.dataflow.BindingListener;
import com.facebook.litho.dataflow.GraphBinding;
import com.facebook.litho.dataflow.ValueNode;

public abstract class TransitionAnimationBinding
extends BaseAnimationBinding {
    private final GraphBinding mGraphBinding;

    public TransitionAnimationBinding() {
        this(GraphBinding.create());
    }

    @VisibleForTesting
    TransitionAnimationBinding(GraphBinding graphBinding) {
        this.mGraphBinding = graphBinding;
        this.mGraphBinding.setListener(new BindingListener(){

            @Override
            public void onAllNodesFinished(GraphBinding binding) {
                TransitionAnimationBinding.this.onAllNodesFinished();
            }
        });
    }

    public void addBinding(ValueNode fromNode, ValueNode toNode, String inputName) {
        this.mGraphBinding.addBinding(fromNode, toNode, inputName);
    }

    public void addBinding(ValueNode fromNode, ValueNode toNode) {
        this.mGraphBinding.addBinding(fromNode, toNode);
    }

    @Override
    public void start(Resolver resolver) {
        if (!this.shouldStart()) {
            this.notifyCanceledBeforeStart();
            return;
        }
        this.notifyWillStart();
        this.setupBinding(resolver);
        this.mGraphBinding.activate();
    }

    protected abstract void setupBinding(Resolver var1);

    @Override
    public void stop() {
        if (!this.isActive()) {
            return;
        }
        this.mGraphBinding.deactivate();
    }

    @Override
    public boolean isActive() {
        return this.mGraphBinding.isActive();
    }

    @Override
    public void prepareToStartLater() {
        this.notifyScheduledToStartLater();
    }

    private void onAllNodesFinished() {
        this.notifyFinished();
        this.stop();
    }
}

