/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.animation.TimeInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.animation.TransitionAnimationBinding;
import com.facebook.litho.dataflow.ConstantNode;
import com.facebook.litho.dataflow.InterpolatorNode;
import com.facebook.litho.dataflow.MappingNode;
import com.facebook.litho.dataflow.TimingNode;
import java.util.ArrayList;

public class TimingTransition
extends TransitionAnimationBinding {
    private final int mDurationMs;
    private final PropertyAnimation mPropertyAnimation;
    @Nullable
    private final Interpolator mInterpolator;

    public TimingTransition(int durationMs, PropertyAnimation propertyAnimation) {
        this(durationMs, propertyAnimation, null);
    }

    public TimingTransition(int durationMs, PropertyAnimation propertyAnimation, Interpolator interpolator) {
        this.mDurationMs = durationMs;
        this.mPropertyAnimation = propertyAnimation;
        this.mInterpolator = interpolator;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        outList.add(this.mPropertyAnimation);
    }

    @Override
    protected void setupBinding(Resolver resolver) {
        TimingNode timingNode = new TimingNode(this.mDurationMs);
        ConstantNode initial = new ConstantNode(resolver.getCurrentState(this.mPropertyAnimation.getPropertyHandle()));
        ConstantNode end = new ConstantNode(this.mPropertyAnimation.getTargetValue());
        MappingNode mappingNode = new MappingNode();
        if (this.mInterpolator != null) {
            InterpolatorNode interpolatorNode = new InterpolatorNode((TimeInterpolator)this.mInterpolator);
            this.addBinding(timingNode, interpolatorNode);
            this.addBinding(interpolatorNode, mappingNode);
        } else {
            this.addBinding(timingNode, mappingNode);
        }
        this.addBinding(initial, mappingNode, "initial");
        this.addBinding(end, mappingNode, "end");
        this.addBinding(mappingNode, resolver.getAnimatedPropertyNode(this.mPropertyAnimation.getPropertyHandle()));
    }
}

