/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.TransitionId;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.animation.PropertyHandle;

public class PropertyAnimation {
    private final PropertyHandle mPropertyHandle;
    private final float mTargetValue;

    public PropertyAnimation(PropertyHandle propertyHandle, float targetValue) {
        this.mPropertyHandle = propertyHandle;
        this.mTargetValue = targetValue;
    }

    public PropertyHandle getPropertyHandle() {
        return this.mPropertyHandle;
    }

    public TransitionId getTransitionId() {
        return this.mPropertyHandle.getTransitionId();
    }

    public AnimatedProperty getProperty() {
        return this.mPropertyHandle.getProperty();
    }

    public float getTargetValue() {
        return this.mTargetValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyAnimation that = (PropertyAnimation)o;
        return Float.compare(that.mTargetValue, this.mTargetValue) == 0 && this.mPropertyHandle.equals(that.mPropertyHandle);
    }

    public int hashCode() {
        int result = this.mPropertyHandle.hashCode();
        result = 31 * result + (this.mTargetValue != 0.0f ? Float.floatToIntBits(this.mTargetValue) : 0);
        return result;
    }

    public String toString() {
        return "PropertyAnimation{ PropertyHandle=" + this.mPropertyHandle + ", TargetValue=" + this.mTargetValue + "}";
    }
}

