/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.BaseAnimationBinding;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.choreographercompat.ChoreographerCompat;
import com.facebook.litho.choreographercompat.ChoreographerCompatImpl;
import java.util.ArrayList;

public class DelayBinding
extends BaseAnimationBinding {
    private final AnimationBinding mBinding;
    private final int mDelayMs;
    private boolean mHasStarted = false;
    private boolean mIsActive = false;
    private Resolver mResolver;

    public DelayBinding(int mDelayMs, AnimationBinding mBinding) {
        this.mDelayMs = mDelayMs;
        this.mBinding = mBinding;
    }

    @Override
    public void prepareToStartLater() {
        this.notifyScheduledToStartLater();
        this.mBinding.prepareToStartLater();
    }

    @Override
    public void start(Resolver resolver) {
        if (this.mHasStarted) {
            throw new RuntimeException("Starting binding multiple times");
        }
        this.mHasStarted = true;
        this.mResolver = resolver;
        if (!this.shouldStart()) {
            this.notifyCanceledBeforeStart();
            return;
        }
        this.notifyWillStart();
        this.mIsActive = true;
        this.mBinding.prepareToStartLater();
        AnimationBindingListener bindingListener = new AnimationBindingListener(){

            @Override
            public void onScheduledToStartLater(AnimationBinding binding) {
            }

            @Override
            public void onWillStart(AnimationBinding binding) {
            }

            @Override
            public void onFinish(AnimationBinding binding) {
                binding.removeListener(this);
                DelayBinding.this.finish();
            }

            @Override
            public void onCanceledBeforeStart(AnimationBinding binding) {
                this.onFinish(binding);
            }

            @Override
            public boolean shouldStart(AnimationBinding binding) {
                return true;
            }
        };
        this.mBinding.addListener(bindingListener);
        ChoreographerCompat.FrameCallback delayedStartCallback = new ChoreographerCompat.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                if (!DelayBinding.this.mIsActive) {
                    return;
                }
                DelayBinding.this.mBinding.start(DelayBinding.this.mResolver);
            }
        };
        ChoreographerCompatImpl.getInstance().postFrameCallbackDelayed(delayedStartCallback, this.mDelayMs);
    }

    @Override
    public void stop() {
        if (!this.mIsActive) {
            return;
        }
        this.mIsActive = false;
        this.mResolver = null;
        if (this.mBinding.isActive()) {
            this.mBinding.stop();
        }
    }

    @Override
    public boolean isActive() {
        return this.mIsActive;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        this.mBinding.collectTransitioningProperties(outList);
    }

    private void finish() {
        this.mIsActive = false;
        this.notifyFinished();
    }
}

