/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import androidx.annotation.Nullable;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import java.util.concurrent.CopyOnWriteArrayList;

abstract class BaseAnimationBinding
implements AnimationBinding {
    private CopyOnWriteArrayList<AnimationBindingListener> mListeners = new CopyOnWriteArrayList();
    @Nullable
    private Object mTag;

    BaseAnimationBinding() {
    }

    @Override
    public final void addListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.add(animationBindingListener);
    }

    @Override
    public final void removeListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.remove(animationBindingListener);
    }

    @Override
    @Nullable
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public void setTag(@Nullable Object tag) {
        this.mTag = tag;
    }

    final boolean shouldStart() {
        for (int index = this.mListeners.size() - 1; index >= 0; --index) {
            AnimationBindingListener listener = this.mListeners.get(index);
            if (listener.shouldStart(this)) continue;
            return false;
        }
        return true;
    }

    final void notifyCanceledBeforeStart() {
        for (int index = this.mListeners.size() - 1; index >= 0; --index) {
            AnimationBindingListener listener = this.mListeners.get(index);
            listener.onCanceledBeforeStart(this);
        }
    }

    final void notifyWillStart() {
        for (int index = this.mListeners.size() - 1; index >= 0; --index) {
            AnimationBindingListener listener = this.mListeners.get(index);
            listener.onWillStart(this);
        }
    }

    final void notifyFinished() {
        for (int index = this.mListeners.size() - 1; index >= 0; --index) {
            AnimationBindingListener listener = this.mListeners.get(index);
            listener.onFinish(this);
        }
    }

    final void notifyScheduledToStartLater() {
        for (int index = this.mListeners.size() - 1; index >= 0; --index) {
            AnimationBindingListener listener = this.mListeners.get(index);
            listener.onScheduledToStartLater(this);
        }
    }
}

