/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.OutputUnitsAffinityGroup;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionEndEvent;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionManager;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.rendercore.Function;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.RootHost;
import com.facebook.rendercore.UnmountDelegateExtension;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.transitions.AnimatedRootHost;
import com.facebook.rendercore.transitions.DisappearingHost;
import com.facebook.rendercore.transitions.TransitionUtils;
import com.facebook.rendercore.transitions.TransitionsExtensionInput;
import com.facebook.rendercore.utils.BoundsUtils;
import com.facebook.rendercore.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransitionsExtension
extends MountExtension<TransitionsExtensionInput, TransitionsExtensionState>
implements UnmountDelegateExtension<TransitionsExtensionState> {
    private static TransitionsExtension sInstance = new TransitionsExtension(null);
    private static TransitionsExtension sDebugInstance;
    @Nullable
    private final String mDebugTag;

    private TransitionsExtension(@Nullable String debugTag) {
        this.mDebugTag = debugTag;
    }

    public static TransitionsExtension getInstance() {
        return sInstance;
    }

    public static TransitionsExtension getInstance(@Nullable String debugTag) {
        TransitionsExtension instance;
        if (debugTag != null) {
            sDebugInstance = instance = sDebugInstance != null ? sDebugInstance : new TransitionsExtension(debugTag);
        } else {
            instance = sInstance;
        }
        return instance;
    }

    public boolean shouldDelegateUnmount(ExtensionState<TransitionsExtensionState> extensionState, MountItem mountItem) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        return state.mLockedDisappearingMountitems.containsKey(mountItem.getRenderTreeNode().getRenderUnit());
    }

    public void unmount(ExtensionState<TransitionsExtensionState> extensionState, MountItem mountItem, Host host) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        AnimatableItem animatableItem = (AnimatableItem)state.mLockedDisappearingMountitems.get(mountItem.getRenderTreeNode().getRenderUnit());
        TransitionId transitionId = animatableItem.getTransitionId();
        OutputUnitsAffinityGroup group = (OutputUnitsAffinityGroup)state.mDisappearingMountItems.get(transitionId);
        if (group != null) {
            boolean isRoot;
            boolean bl = isRoot = group.get(animatableItem.getOutputType()) != null;
            if (isRoot) {
                ((DisappearingHost)host).startDisappearingMountItem(mountItem);
            }
        }
    }

    protected TransitionsExtensionState createState() {
        return new TransitionsExtensionState(this.mDebugTag);
    }

    public void beforeMount(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input, Rect localVisibleRect) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        state.mInput = input;
        if (input.getTreeId() != state.mLastMountedTreeId) {
            state.mLastTransitionsExtensionInput = null;
        }
        TransitionsExtension.updateTransitions(extensionState, input, this.mDebugTag);
        TransitionsExtension.extractDisappearingItems(extensionState, input);
    }

    public void afterMount(ExtensionState<TransitionsExtensionState> extensionState) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        TransitionsExtension.maybeUpdateAnimatingMountContent(extensionState);
        if (TransitionsExtension.shouldAnimateTransitions(state, state.mInput) && TransitionsExtension.hasTransitionsToAnimate(state)) {
            state.mTransitionManager.runTransitions();
        }
        state.mInput.setNeedsToRerunTransitions(false);
        state.mLastTransitionsExtensionInput = state.mInput;
        state.mTransitionsHasBeenCollected = false;
        state.mLastMountedTreeId = state.mInput.getTreeId();
    }

    public void onUnmount(ExtensionState<TransitionsExtensionState> extensionState) {
        extensionState.releaseAllAcquiredReferences();
        this.clearLastMountedTreeId(extensionState);
    }

    public void onUnbind(ExtensionState<TransitionsExtensionState> extensionState) {
        extensionState.releaseAllAcquiredReferences();
    }

    public void clearLastMountedTreeId(ExtensionState<TransitionsExtensionState> extensionState) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        state.mLastMountedTreeId = -1;
    }

    public void onUnbindItem(ExtensionState<TransitionsExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        AnimatableItem animatableItem;
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        if (content instanceof Host) {
            TransitionsExtension.removeDisappearingMountContentFromHost(extensionState, (Host)content);
        }
        if ((animatableItem = state.mInput != null ? state.mInput.getAnimatableItem(renderUnit) : null) != null && animatableItem.getTransitionId() != null) {
            TransitionsExtension.maybeRemoveAnimatingMountContent(state, animatableItem.getTransitionId(), animatableItem.getOutputType());
        }
    }

    public void onMountItem(ExtensionState<TransitionsExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        if (extensionState.ownsReference(renderUnit.getId()) && ((TransitionsExtensionState)extensionState.getState()).mInput.renderUnitWithIdHostsRenderTrees(renderUnit.getId())) {
            View view = (View)content;
            TransitionsExtension.recursivelyNotifyVisibleBoundsChanged(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTransitions(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input, @Nullable String debugTag) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        RenderCoreSystrace.beginSection((String)"MountState.updateTransitions");
        try {
            int treeId = input.getTreeId();
            if (state.mLastMountedTreeId != treeId) {
                TransitionsExtension.resetAnimationState(extensionState);
                if (!state.mInput.needsToRerunTransitions()) {
                    return;
                }
            }
            if (!state.mDisappearingMountItems.isEmpty()) {
                TransitionsExtension.updateDisappearingMountItems(extensionState, input);
            }
            if (TransitionsExtension.shouldAnimateTransitions(state, input)) {
                TransitionsExtension.collectAllTransitions(extensionState, input);
                if (TransitionsExtension.hasTransitionsToAnimate(state)) {
                    TransitionsExtension.createNewTransitions(extensionState, input, state.mRootTransition, debugTag);
                }
            }
            if (state.mTransitionManager != null) {
                state.mTransitionManager.finishUndeclaredTransitions();
            }
            extensionState.releaseAllAcquiredReferences();
            if (!state.mAnimatingTransitionIds.isEmpty()) {
                TransitionsExtension.regenerateAnimationLockedIndices(extensionState, input);
            }
        }
        finally {
            RenderCoreSystrace.endSection();
        }
    }

    private static void updateDisappearingMountItems(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> nextMountedTransitionIds = input.getTransitionIdMapping();
        for (TransitionId transitionId : nextMountedTransitionIds.keySet()) {
            OutputUnitsAffinityGroup disappearingItem = (OutputUnitsAffinityGroup)state.mDisappearingMountItems.remove(transitionId);
            if (disappearingItem == null) continue;
            TransitionsExtension.endUnmountDisappearingItem(extensionState, disappearingItem);
        }
    }

    private static void resetAnimationState(ExtensionState<TransitionsExtensionState> extensionState) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        if (state.mTransitionManager == null) {
            return;
        }
        for (OutputUnitsAffinityGroup group : state.mDisappearingMountItems.values()) {
            TransitionsExtension.endUnmountDisappearingItem(extensionState, group);
        }
        extensionState.releaseAllAcquiredReferences();
        state.mDisappearingMountItems.clear();
        state.mLockedDisappearingMountitems.clear();
        state.mAnimatingTransitionIds.clear();
        state.mTransitionManager.reset();
    }

    private static void regenerateAnimationLockedIndices(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> transitionMapping = input.getTransitionIdMapping();
        if (transitionMapping != null) {
            for (Map.Entry<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> transition : transitionMapping.entrySet()) {
                if (!state.mAnimatingTransitionIds.contains(transition.getKey())) continue;
                OutputUnitsAffinityGroup<AnimatableItem> group = transition.getValue();
                int sz = group.size();
                for (int j = 0; j < sz; ++j) {
                    int position = input.getPositionForId(group.getAt(j).getId());
                    TransitionsExtension.updateAnimationLockCount(extensionState, input, position, true);
                }
            }
        }
    }

    private static boolean shouldAnimateTransitions(TransitionsExtensionState state, TransitionsExtensionInput input) {
        return state.mLastMountedTreeId == input.getTreeId() || state.mInput.needsToRerunTransitions();
    }

    private static boolean hasTransitionsToAnimate(TransitionsExtensionState state) {
        return state.mRootTransition != null;
    }

    static void collectAllTransitions(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        ThreadUtils.assertMainThread();
        if (state.mTransitionsHasBeenCollected) {
            return;
        }
        ArrayList<Transition> allTransitions = new ArrayList<Transition>();
        if (input.getTransitions() != null) {
            allTransitions.addAll(input.getTransitions());
        }
        TransitionsExtension.collectMountTimeTransitions(input, allTransitions);
        Transition.RootBoundsTransition rootWidthTransition = new Transition.RootBoundsTransition();
        Transition.RootBoundsTransition rootHeightTransition = new Transition.RootBoundsTransition();
        TransitionId rootTransitionId = input.getRootTransitionId();
        if (rootTransitionId != null) {
            int size = allTransitions.size();
            for (int i = 0; i < size; ++i) {
                Transition transition = allTransitions.get(i);
                if (transition == null) {
                    throw new IllegalStateException("NULL_TRANSITION when collecting root bounds anim. Root: " + input.getRootName() + ", root TransitionId: " + rootTransitionId);
                }
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, transition, AnimatedProperties.WIDTH, rootWidthTransition);
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, transition, AnimatedProperties.HEIGHT, rootHeightTransition);
            }
        }
        rootWidthTransition = rootWidthTransition.hasTransition ? rootWidthTransition : null;
        rootHeightTransition = rootHeightTransition.hasTransition ? rootHeightTransition : null;
        input.setInitialRootBoundsForAnimation(rootWidthTransition, rootHeightTransition);
        state.mRootTransition = TransitionManager.getRootTransition(allTransitions);
        state.mTransitionsHasBeenCollected = true;
    }

    private static void collectMountTimeTransitions(TransitionsExtensionInput input, List<Transition> outList) {
        List<Transition> transitions = input.getMountTimeTransitions();
        if (transitions != null) {
            for (Transition transition : transitions) {
                TransitionUtils.addTransitions(transition, outList, input.getRootName());
            }
        }
    }

    private static void prepareTransitionManager(ExtensionState<TransitionsExtensionState> extensionState, @Nullable String debugTag) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        if (state.mTransitionManager == null) {
            state.mTransitionManager = new TransitionManager(new AnimationCompleteListener(extensionState), debugTag);
        }
    }

    private static void createNewTransitions(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input, Transition rootTransition, @Nullable String debugTag) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        TransitionsExtension.prepareTransitionManager(extensionState, debugTag);
        Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> lastTransitions = state.mLastTransitionsExtensionInput == null ? null : state.mLastTransitionsExtensionInput.getTransitionIdMapping();
        state.mTransitionManager.setupTransitions(lastTransitions, input.getTransitionIdMapping(), rootTransition);
        Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> nextTransitionIds = input.getTransitionIdMapping();
        for (TransitionId transitionId : nextTransitionIds.keySet()) {
            if (!state.mTransitionManager.isAnimating(transitionId)) continue;
            state.mAnimatingTransitionIds.add(transitionId);
        }
    }

    private static boolean isItemDisappearing(TransitionsExtensionState state, TransitionsExtensionInput input, int index) {
        if (!TransitionsExtension.shouldAnimateTransitions(state, input) || !TransitionsExtension.hasTransitionsToAnimate(state)) {
            return false;
        }
        if (state.mTransitionManager == null || state.mLastTransitionsExtensionInput == null) {
            return false;
        }
        AnimatableItem animatableItem = state.mLastTransitionsExtensionInput.getAnimatableItem(state.mLastTransitionsExtensionInput.getMountableOutputAt(index).getRenderUnit());
        TransitionId transitionId = animatableItem.getTransitionId();
        if (transitionId == null) {
            return false;
        }
        return state.mTransitionManager.isDisappearing(transitionId);
    }

    private static void extractDisappearingItems(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput newTransitionsExtensionInput) {
        int mountItemCount = TransitionsExtension.getMountTarget(extensionState).getRenderUnitCount();
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        if (state.mLastTransitionsExtensionInput == null || mountItemCount == 0) {
            return;
        }
        for (int i = 1; i < mountItemCount; ++i) {
            if (!TransitionsExtension.isItemDisappearing(state, newTransitionsExtensionInput, i)) continue;
            int lastDescendantIndex = TransitionsExtension.findLastDescendantIndex(state.mLastTransitionsExtensionInput, i);
            for (int j = i; j <= lastDescendantIndex; ++j) {
                if (TransitionsExtension.getMountTarget(extensionState).getMountItemAt(j) == null) {
                    long id = state.mLastTransitionsExtensionInput.getMountableOutputAt(j).getRenderUnit().getId();
                    if (extensionState.ownsReference(id)) {
                        extensionState.releaseMountReference(id, false);
                    }
                    extensionState.acquireMountReference(id, true);
                    extensionState.releaseMountReference(id, false);
                }
                RenderUnit renderUnit = TransitionsExtension.getMountTarget(extensionState).getMountItemAt(j).getRenderTreeNode().getRenderUnit();
                state.mLockedDisappearingMountitems.put(renderUnit, state.mLastTransitionsExtensionInput.getAnimatableItem(renderUnit));
            }
            MountItem disappearingItem = TransitionsExtension.getMountTarget(extensionState).getMountItemAt(i);
            if (disappearingItem == null) {
                throw new IllegalStateException("The root of the disappearing subtree should not be null, acquireMountReference on this index should be called before this. Index: " + i);
            }
            TransitionsExtension.remountHostToRootIfNeeded(extensionState, i, disappearingItem);
            TransitionsExtension.mapDisappearingItemWithTransitionId(state, disappearingItem);
            long id = disappearingItem.getRenderTreeNode().getRenderUnit().getId();
            TransitionsExtension.getMountTarget(extensionState).notifyUnmount(id);
            i = lastDescendantIndex;
        }
    }

    private static void unmountDisappearingItem(ExtensionState<TransitionsExtensionState> extensionState, MountItem mountItem, boolean isRoot) {
        Host host;
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        Object content = mountItem.getContent();
        if (content instanceof Host && !(content instanceof RootHost)) {
            Host contentHost = (Host)content;
            for (int j = contentHost.getMountItemCount() - 1; j >= 0; --j) {
                TransitionsExtension.unmountDisappearingItem(extensionState, contentHost.getMountItemAt(j), false);
            }
            if (contentHost.getMountItemCount() > 0) {
                throw new IllegalStateException("Recursively unmounting items from a Host, left some items behind, this should never happen.");
            }
        }
        if ((host = mountItem.getHost()) == null) {
            throw new IllegalStateException("Disappearing mountItem has no host, can not be unmounted.");
        }
        if (isRoot) {
            ((DisappearingHost)host).finaliseDisappearingItem(mountItem);
        } else {
            host.unmount(mountItem);
        }
        TransitionsExtension.getMountTarget(extensionState).unbindMountItem(mountItem);
        state.mLockedDisappearingMountitems.remove(mountItem.getRenderTreeNode().getRenderUnit());
    }

    private static void endUnmountDisappearingItem(ExtensionState<TransitionsExtensionState> extensionState, OutputUnitsAffinityGroup<MountItem> group) {
        TransitionsExtension.maybeRemoveAnimatingMountContent((TransitionsExtensionState)extensionState.getState(), ((AnimatableItem)((TransitionsExtensionState)extensionState.getState()).mLockedDisappearingMountitems.get(group.getMostSignificantUnit().getRenderTreeNode().getRenderUnit())).getTransitionId());
        int size = group.size();
        for (int i = 0; i < size; ++i) {
            TransitionsExtension.unmountDisappearingItem(extensionState, group.getAt(i), true);
        }
    }

    private static void mapDisappearingItemWithTransitionId(TransitionsExtensionState state, MountItem item) {
        AnimatableItem animatableItem = state.mLastTransitionsExtensionInput.getAnimatableItem(item.getRenderTreeNode().getRenderUnit());
        TransitionId transitionId = animatableItem.getTransitionId();
        OutputUnitsAffinityGroup<MountItem> disappearingGroup = (OutputUnitsAffinityGroup<MountItem>)state.mDisappearingMountItems.get(transitionId);
        if (disappearingGroup == null) {
            disappearingGroup = new OutputUnitsAffinityGroup<MountItem>();
            state.mDisappearingMountItems.put(transitionId, disappearingGroup);
        }
        int type = animatableItem.getOutputType();
        disappearingGroup.add(type, item);
    }

    private static void remountHostToRootIfNeeded(ExtensionState<TransitionsExtensionState> extensionState, int index, MountItem mountItem) {
        int bottom;
        int right;
        Host rootHost = TransitionsExtension.getMountTarget(extensionState).getRootItem().getHost();
        Host originalHost = mountItem.getHost();
        if (originalHost == null) {
            throw new IllegalStateException("Disappearing item host should never be null. Index: " + index);
        }
        if (rootHost == originalHost) {
            return;
        }
        Object content = mountItem.getContent();
        if (content == null) {
            throw new IllegalStateException("Disappearing item content should never be null. Index: " + index);
        }
        int left = 0;
        int top = 0;
        for (Host host = originalHost; host != rootHost; host = (Host)host.getParent()) {
            left += host.getLeft();
            top += host.getTop();
        }
        if (content instanceof View) {
            View view = (View)content;
            right = (left += view.getLeft()) + view.getWidth();
            bottom = (top += view.getTop()) + view.getHeight();
        } else {
            Rect bounds = ((Drawable)content).getBounds();
            right = (left += bounds.left) + bounds.width();
            bottom = (top += bounds.top) + bounds.height();
        }
        originalHost.unmount(mountItem);
        BoundsUtils.applyBoundsToMountContent((Rect)new Rect(left, top, right, bottom), null, (Object)content, (boolean)false);
        rootHost.mount(index, mountItem);
        mountItem.setHost(rootHost);
    }

    private static void maybeUpdateAnimatingMountContent(ExtensionState<TransitionsExtensionState> extensionState) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        if (state.mTransitionManager == null) {
            return;
        }
        RenderCoreSystrace.beginSection((String)"updateAnimatingMountContent");
        LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<Object>> animatingContent = new LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<Object>>(state.mAnimatingTransitionIds.size());
        int size = TransitionsExtension.getMountTarget(extensionState).getRenderUnitCount();
        for (int i = 0; i < size; ++i) {
            AnimatableItem animatableItem;
            MountItem mountItem = TransitionsExtension.getMountTarget(extensionState).getMountItemAt(i);
            if (mountItem == null || (animatableItem = state.mInput.getAnimatableItem(mountItem.getRenderTreeNode().getRenderUnit())).getTransitionId() == null) continue;
            int type = animatableItem.getOutputType();
            OutputUnitsAffinityGroup<Object> group = (OutputUnitsAffinityGroup<Object>)animatingContent.get(animatableItem.getTransitionId());
            if (group == null) {
                group = new OutputUnitsAffinityGroup<Object>();
                animatingContent.put(animatableItem.getTransitionId(), group);
            }
            group.replace(type, mountItem.getContent());
        }
        for (Map.Entry content : animatingContent.entrySet()) {
            state.mTransitionManager.setMountContent((TransitionId)content.getKey(), (OutputUnitsAffinityGroup)content.getValue());
        }
        for (Map.Entry entry : state.mDisappearingMountItems.entrySet()) {
            OutputUnitsAffinityGroup mountItemsGroup = (OutputUnitsAffinityGroup)entry.getValue();
            OutputUnitsAffinityGroup<Object> mountContentGroup = new OutputUnitsAffinityGroup<Object>();
            int sz = mountItemsGroup.size();
            for (int j = 0; j < sz; ++j) {
                int type = mountItemsGroup.typeAt(j);
                MountItem mountItem = (MountItem)mountItemsGroup.getAt(j);
                mountContentGroup.add(type, mountItem.getContent());
            }
            state.mTransitionManager.setMountContent((TransitionId)entry.getKey(), mountContentGroup);
        }
        RenderCoreSystrace.endSection();
    }

    private static void removeDisappearingMountContentFromHost(ExtensionState<TransitionsExtensionState> extensionState, Host host) {
        TransitionsExtensionState state = (TransitionsExtensionState)extensionState.getState();
        int size = host.getMountItemCount();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = host.getMountItemAt(i);
            AnimatableItem animatableItem = (AnimatableItem)state.mLockedDisappearingMountitems.get(mountItem.getRenderTreeNode().getRenderUnit());
            if (animatableItem == null) continue;
            state.mTransitionManager.setMountContent(animatableItem.getTransitionId(), null);
        }
    }

    private static void maybeRemoveAnimatingMountContent(TransitionsExtensionState state, @Nullable TransitionId transitionId) {
        if (state.mTransitionManager == null || transitionId == null) {
            return;
        }
        state.mTransitionManager.setMountContent(transitionId, null);
    }

    private static void maybeRemoveAnimatingMountContent(TransitionsExtensionState state, TransitionId transitionId, int type) {
        if (state.mTransitionManager == null || transitionId == null) {
            return;
        }
        state.mTransitionManager.removeMountContent(transitionId, type);
    }

    private static void updateAnimationLockCount(ExtensionState<TransitionsExtensionState> extensionState, TransitionsExtensionInput input, int index, boolean increment) {
        int lastDescendantIndex = TransitionsExtension.findLastDescendantIndex(input, index);
        for (int i = index; i <= lastDescendantIndex; ++i) {
            RenderTreeNode renderTreeNode = input.getMountableOutputAt(i);
            long id = renderTreeNode.getRenderUnit().getId();
            if (increment) {
                if (extensionState.ownsReference(id)) continue;
                extensionState.acquireMountReference(id, false);
                continue;
            }
            if (!extensionState.ownsReference(id)) continue;
            extensionState.releaseMountReference(id, false);
        }
        for (RenderTreeNode parentRenderTreeNode = input.getMountableOutputAt(index).getParent(); parentRenderTreeNode != null && parentRenderTreeNode.getParent() != null; parentRenderTreeNode = parentRenderTreeNode.getParent()) {
            long id = parentRenderTreeNode.getRenderUnit().getId();
            if (increment) {
                if (!extensionState.ownsReference(id)) {
                    extensionState.acquireMountReference(id, false);
                }
                if (extensionState.ownsReference(id)) continue;
                extensionState.acquireMountReference(id, false);
                continue;
            }
            if (!extensionState.ownsReference(id)) continue;
            extensionState.releaseMountReference(id, false);
        }
    }

    private static int findLastDescendantIndex(TransitionsExtensionInput input, int index) {
        RenderTreeNode rootRenderTreeNode = input.getMountableOutputAt(index);
        int size = input.getMountableOutputCount();
        for (int i = index + 1; i < size; ++i) {
            for (RenderTreeNode parentRenderTreeNode = input.getMountableOutputAt(i).getParent(); parentRenderTreeNode != rootRenderTreeNode; parentRenderTreeNode = parentRenderTreeNode.getParent()) {
                if (parentRenderTreeNode != null && parentRenderTreeNode.getParent() != null) continue;
                return i - 1;
            }
        }
        return input.getMountableOutputCount() - 1;
    }

    private static void recursivelyNotifyVisibleBoundsChanged(View view) {
        ThreadUtils.assertMainThread();
        if (view instanceof AnimatedRootHost) {
            ((AnimatedRootHost)view).notifyVisibleBoundsChanged(new Rect(0, 0, view.getWidth(), view.getHeight()), false);
        } else if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                View child = parent.getChildAt(i);
                TransitionsExtension.recursivelyNotifyVisibleBoundsChanged(child);
            }
        }
    }

    private static class AnimationCompleteListener
    implements TransitionManager.OnAnimationCompleteListener<Function<TransitionEndEvent>> {
        private final ExtensionState<TransitionsExtensionState> mExtensionState;
        private final TransitionsExtensionState mState;

        private AnimationCompleteListener(ExtensionState<TransitionsExtensionState> extensionState) {
            this.mExtensionState = extensionState;
            this.mState = (TransitionsExtensionState)this.mExtensionState.getState();
        }

        @Override
        public void onAnimationComplete(TransitionId transitionId) {
            OutputUnitsAffinityGroup disappearingGroup = (OutputUnitsAffinityGroup)this.mState.mDisappearingMountItems.remove(transitionId);
            if (disappearingGroup != null) {
                TransitionsExtension.endUnmountDisappearingItem((ExtensionState<TransitionsExtensionState>)this.mExtensionState, disappearingGroup);
            } else {
                OutputUnitsAffinityGroup<AnimatableItem> animatableItemGroup;
                if (!this.mState.mAnimatingTransitionIds.remove(transitionId) && ((TransitionsExtensionState)this.mExtensionState.getState()).mDebugTag != null) {
                    Log.e((String)((TransitionsExtensionState)this.mExtensionState.getState()).mDebugTag, (String)("Ending animation for id " + transitionId + " but it wasn't recorded as animating!"));
                }
                OutputUnitsAffinityGroup<AnimatableItem> outputUnitsAffinityGroup = animatableItemGroup = this.mState.mLastTransitionsExtensionInput != null ? this.mState.mLastTransitionsExtensionInput.getAnimatableItemForTransitionId(transitionId) : null;
                if (animatableItemGroup == null) {
                    return;
                }
                int size = animatableItemGroup.size();
                for (int i = 0; i < size; ++i) {
                    int position = this.mState.mLastTransitionsExtensionInput.getPositionForId(animatableItemGroup.getAt(i).getId());
                    TransitionsExtension.updateAnimationLockCount((ExtensionState<TransitionsExtensionState>)this.mExtensionState, this.mState.mLastTransitionsExtensionInput, position, false);
                }
            }
        }

        @Override
        public void onAnimationUnitComplete(PropertyHandle propertyHandle, Function transitionEndHandler) {
            if (transitionEndHandler != null) {
                transitionEndHandler.call(new Object[]{new TransitionEndEvent(propertyHandle.getTransitionId().mReference, propertyHandle.getProperty())});
            }
        }
    }

    static class TransitionsExtensionState {
        private final Map<TransitionId, OutputUnitsAffinityGroup<MountItem>> mDisappearingMountItems = new LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<MountItem>>();
        private static final int UNSET = -1;
        private final Map<RenderUnit, AnimatableItem> mLockedDisappearingMountitems = new HashMap<RenderUnit, AnimatableItem>();
        private TransitionsExtensionInput mInput;
        private int mLastMountedTreeId = -1;
        private TransitionManager mTransitionManager;
        private final HashSet<TransitionId> mAnimatingTransitionIds = new HashSet();
        private boolean mTransitionsHasBeenCollected = false;
        @Nullable
        private Transition mRootTransition;
        @Nullable
        private TransitionsExtensionInput mLastTransitionsExtensionInput;
        @Nullable
        private final String mDebugTag;

        public TransitionsExtensionState(@Nullable String debugTag) {
            this.mDebugTag = debugTag;
        }
    }
}

