/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.Nullable;
import androidx.collection.SparseArrayCompat;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.OutputUnitsAffinityGroup;
import com.facebook.litho.ParallelTransitionSet;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionIdMap;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.animation.AnimatedPropertyNode;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.ParallelBinding;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.litho.animation.Resolver;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.RootHost;
import com.facebook.rendercore.transitions.TransitionsExtensionInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransitionManager {
    private final Map<AnimationBinding, List<PropertyHandle>> mAnimationsToPropertyHandles = new HashMap<AnimationBinding, List<PropertyHandle>>();
    private final TransitionIdMap<AnimationState> mAnimationStates = new TransitionIdMap();
    private final SparseArrayCompat<String> mTraceNames = new SparseArrayCompat();
    private final Map<PropertyHandle, Float> mInitialStatesToRestore = new HashMap<PropertyHandle, Float>();
    private final ArrayList<AnimationBinding> mRunningRootAnimations = new ArrayList();
    private final TransitionsAnimationBindingListener mAnimationBindingListener = new TransitionsAnimationBindingListener();
    private final RootAnimationListener mRootAnimationListener = new RootAnimationListener();
    private final TransitionsResolver mResolver = new TransitionsResolver();
    private final OnAnimationCompleteListener mOnAnimationCompleteListener;
    private AnimationBinding mRootAnimationToRun;
    private final String mDebugTag;
    private final Map<Host, Boolean> mOverriddenClipChildrenFlags = new LinkedHashMap<Host, Boolean>();

    public TransitionManager(OnAnimationCompleteListener onAnimationCompleteListener, @Nullable String debugTag) {
        this.mOnAnimationCompleteListener = onAnimationCompleteListener;
        this.mDebugTag = debugTag;
    }

    void setupTransitions(TransitionsExtensionInput currentInput, TransitionsExtensionInput nextInput, Transition rootTransition) {
        Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> nextTransitionIds = nextInput.getTransitionIdMapping();
        Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> currentTransitionIds = currentInput == null ? null : currentInput.getTransitionIdMapping();
        this.setupTransitions(currentTransitionIds, nextTransitionIds, rootTransition);
    }

    void setupTransitions(@Nullable Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> currentTransitionIds, @Nullable Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> nextTransitionIds, Transition rootTransition) {
        RenderCoreSystrace.beginSection((String)"TransitionManager.setupTransition");
        for (AnimationState animationState : this.mAnimationStates.values()) {
            animationState.seenInLastTransition = false;
        }
        if (currentTransitionIds == null) {
            for (Map.Entry entry : nextTransitionIds.entrySet()) {
                TransitionId transitionId = (TransitionId)entry.getKey();
                OutputUnitsAffinityGroup nextLayoutOutputsGroup = (OutputUnitsAffinityGroup)entry.getValue();
                this.recordLayoutOutputsGroupDiff(transitionId, null, nextLayoutOutputsGroup);
            }
        } else {
            HashSet<TransitionId> seenInNewLayout = new HashSet<TransitionId>();
            for (TransitionId transitionId : nextTransitionIds.keySet()) {
                boolean isAutogenerated = transitionId.mType == 3;
                OutputUnitsAffinityGroup<AnimatableItem> nextLayoutOutputsGroup = nextTransitionIds.get(transitionId);
                OutputUnitsAffinityGroup<AnimatableItem> currentLayoutOutputsGroup = currentTransitionIds.get(transitionId);
                if (nextLayoutOutputsGroup != null) {
                    seenInNewLayout.add(transitionId);
                } else if (isAutogenerated) continue;
                this.recordLayoutOutputsGroupDiff(transitionId, currentLayoutOutputsGroup, nextLayoutOutputsGroup);
            }
            for (TransitionId transitionId : currentTransitionIds.keySet()) {
                if (seenInNewLayout.contains(transitionId)) continue;
                this.recordLayoutOutputsGroupDiff(transitionId, currentTransitionIds.get(transitionId), null);
            }
        }
        this.createTransitionAnimations(rootTransition);
        this.cleanupNonAnimatingAnimationStates();
        RenderCoreSystrace.endSection();
    }

    void finishUndeclaredTransitions() {
        for (AnimationState animationState : new ArrayList<AnimationState>(this.mAnimationStates.values())) {
            if (!animationState.shouldFinishUndeclaredAnimation) continue;
            animationState.shouldFinishUndeclaredAnimation = false;
            for (PropertyState propertyState : new ArrayList<PropertyState>(animationState.propertyStates.values())) {
                AnimationBinding animationBinding = propertyState.animation;
                if (animationBinding == null) continue;
                animationBinding.stop();
                this.mAnimationBindingListener.finishAnimation(animationBinding);
            }
        }
    }

    void runTransitions() {
        RenderCoreSystrace.beginSection((String)"runTransitions");
        this.restoreInitialStates();
        if (this.mDebugTag != null) {
            this.debugLogStartingAnimations();
        }
        if (this.mRootAnimationToRun != null) {
            this.mRootAnimationToRun.addListener(this.mRootAnimationListener);
            this.mRootAnimationToRun.start(this.mResolver);
            this.mRootAnimationToRun = null;
        }
        RenderCoreSystrace.endSection();
    }

    void removeMountContent(TransitionId transitionId, int type) {
        OutputUnitsAffinityGroup<Object> updatedMountContentGroup;
        AnimationState animationState = this.mAnimationStates.get(transitionId);
        if (animationState == null) {
            return;
        }
        OutputUnitsAffinityGroup<Object> mountContentGroup = animationState.mountContentGroup;
        if (mountContentGroup == null || mountContentGroup.get(type) == null) {
            return;
        }
        if (mountContentGroup.size() > 1) {
            updatedMountContentGroup = new OutputUnitsAffinityGroup<Object>(mountContentGroup);
            updatedMountContentGroup.replace(type, null);
        } else {
            updatedMountContentGroup = null;
        }
        this.setMountContentInner(transitionId, animationState, updatedMountContentGroup);
    }

    void setMountContent(TransitionId transitionId, @Nullable OutputUnitsAffinityGroup<Object> mountContentGroup) {
        AnimationState animationState = this.mAnimationStates.get(transitionId);
        if (animationState != null) {
            this.setMountContentInner(transitionId, animationState, mountContentGroup);
        }
    }

    boolean isAnimating(TransitionId transitionId) {
        return this.mAnimationStates.contains(transitionId);
    }

    boolean isDisappearing(TransitionId transitionId) {
        AnimationState animationState = this.mAnimationStates.get(transitionId);
        if (animationState == null) {
            return false;
        }
        return animationState.changeType == 2 && animationState.hasDisappearingAnimation;
    }

    void reset() {
        for (TransitionId transitionId : this.mAnimationStates.ids()) {
            AnimationState animationState = this.mAnimationStates.get(transitionId);
            this.setMountContentInner(transitionId, animationState, null);
            TransitionManager.clearLayoutOutputs(animationState);
        }
        this.mAnimationStates.clear();
        this.mTraceNames.clear();
        this.mAnimationsToPropertyHandles.clear();
        for (int i = this.mRunningRootAnimations.size() - 1; i >= 0; --i) {
            this.mRunningRootAnimations.get(i).stop();
        }
        this.mRunningRootAnimations.clear();
        this.mRootAnimationToRun = null;
        this.mOverriddenClipChildrenFlags.clear();
    }

    private void recordLayoutOutputsGroupDiff(TransitionId transitionId, OutputUnitsAffinityGroup<AnimatableItem> currentLayoutOutputsGroup, OutputUnitsAffinityGroup<AnimatableItem> nextLayoutOutputsGroup) {
        AnimationState animationState = this.mAnimationStates.get(transitionId);
        if (animationState == null) {
            animationState = new AnimationState();
            this.mAnimationStates.put(transitionId, animationState);
        }
        if (currentLayoutOutputsGroup == null && nextLayoutOutputsGroup == null) {
            throw new RuntimeException("Both current and next LayoutOutput groups were null!");
        }
        if (currentLayoutOutputsGroup == null && nextLayoutOutputsGroup != null) {
            animationState.changeType = 0;
        } else if (currentLayoutOutputsGroup != null && nextLayoutOutputsGroup != null) {
            animationState.changeType = 1;
        } else {
            if (!(animationState.changeType != 0 && animationState.changeType != 1 || animationState.hasDisappearingAnimation)) {
                animationState.shouldFinishUndeclaredAnimation = true;
            }
            animationState.changeType = 2;
        }
        animationState.currentLayoutOutputsGroup = currentLayoutOutputsGroup;
        animationState.nextLayoutOutputsGroup = nextLayoutOutputsGroup;
        this.recordLastMountedValues(animationState);
        animationState.seenInLastTransition = true;
        if (this.mDebugTag != null) {
            Log.d((String)this.mDebugTag, (String)("Saw transition id " + transitionId + " which is " + TransitionManager.changeTypeToString(animationState.changeType)));
        }
    }

    private void recordLastMountedValues(AnimationState animationState) {
        AnimatableItem animatableItem = animationState.nextLayoutOutputsGroup != null ? animationState.nextLayoutOutputsGroup.getMostSignificantUnit() : null;
        for (AnimatedProperty property : animationState.propertyStates.keySet()) {
            PropertyState propertyState = animationState.propertyStates.get(property);
            if (animatableItem == null) {
                propertyState.lastMountedValue = null;
                continue;
            }
            propertyState.lastMountedValue = Float.valueOf(property.get(animatableItem));
        }
    }

    @Nullable
    static Transition getRootTransition(List<Transition> allTransitions) {
        if (allTransitions.isEmpty()) {
            return null;
        }
        if (allTransitions.size() == 1) {
            return allTransitions.get(0);
        }
        return new ParallelTransitionSet(allTransitions);
    }

    private void createTransitionAnimations(Transition rootTransition) {
        this.mRootAnimationToRun = this.createAnimationsForTransition(rootTransition);
    }

    private AnimationBinding createAnimationsForTransition(Transition transition) {
        if (transition instanceof Transition.TransitionUnit) {
            return this.createAnimationsForTransitionUnit((Transition.TransitionUnit)transition);
        }
        if (transition instanceof TransitionSet) {
            return this.createAnimationsForTransitionSet((TransitionSet)transition);
        }
        throw new RuntimeException("Unhandled Transition type: " + transition);
    }

    @Nullable
    private AnimationBinding createAnimationsForTransitionSet(TransitionSet transitionSet) {
        ArrayList<Transition> children = transitionSet.getChildren();
        ArrayList<AnimationBinding> createdAnimations = new ArrayList<AnimationBinding>();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            AnimationBinding animation = this.createAnimationsForTransition(children.get(i));
            if (animation == null) continue;
            createdAnimations.add(animation);
        }
        if (createdAnimations.isEmpty()) {
            return null;
        }
        return transitionSet.createAnimation(createdAnimations);
    }

    @Nullable
    private AnimationBinding createAnimationsForTransitionUnit(Transition.TransitionUnit transition) {
        Transition.AnimationTarget animationTarget = transition.getAnimationTarget();
        ArrayList<AnimationBinding> createdAnimations = new ArrayList<AnimationBinding>();
        switch (animationTarget.componentTarget.componentTargetType) {
            case ALL: 
            case AUTO_LAYOUT: {
                this.createAnimationsForTransitionUnitAllKeys(transition, createdAnimations);
                break;
            }
            case LOCAL_KEY: {
                String key = (String)animationTarget.componentTarget.componentTargetExtraData;
                TransitionId transitionId = this.mAnimationStates.getScopedId(transition.getOwnerKey(), key);
                this.createAnimationsForTransitionUnit(transition, transitionId, createdAnimations);
                break;
            }
            case LOCAL_KEY_SET: {
                String[] keys = (String[])animationTarget.componentTarget.componentTargetExtraData;
                String ownerKey = transition.getOwnerKey();
                for (int j = 0; j < keys.length; ++j) {
                    TransitionId transitionId = this.mAnimationStates.getScopedId(ownerKey, keys[j]);
                    if (transitionId == null) continue;
                    this.createAnimationsForTransitionUnit(transition, transitionId, createdAnimations);
                }
                break;
            }
            case GLOBAL_KEY: {
                String key = (String)animationTarget.componentTarget.componentTargetExtraData;
                TransitionId transitionId = this.mAnimationStates.getGlobalId(key);
                this.createAnimationsForTransitionUnit(transition, transitionId, createdAnimations);
                break;
            }
            case GLOBAL_KEY_SET: {
                String[] keys = (String[])animationTarget.componentTarget.componentTargetExtraData;
                for (int j = 0; j < keys.length; ++j) {
                    TransitionId transitionId = this.mAnimationStates.getGlobalId(keys[j]);
                    if (transitionId == null) continue;
                    this.createAnimationsForTransitionUnit(transition, transitionId, createdAnimations);
                }
                break;
            }
        }
        if (createdAnimations.isEmpty()) {
            return null;
        }
        if (createdAnimations.size() == 1) {
            return createdAnimations.get(0);
        }
        return new ParallelBinding(0, createdAnimations);
    }

    private void createAnimationsForTransitionUnitAllKeys(Transition.TransitionUnit transition, ArrayList<AnimationBinding> outList) {
        for (TransitionId transitionId : this.mAnimationStates.ids()) {
            AnimationState animationState = this.mAnimationStates.get(transitionId);
            if (!animationState.seenInLastTransition) continue;
            this.createAnimationsForTransitionUnit(transition, transitionId, outList);
        }
    }

    private void createAnimationsForTransitionUnit(Transition.TransitionUnit transition, TransitionId transitionId, ArrayList<AnimationBinding> outList) {
        Transition.AnimationTarget animationTarget = transition.getAnimationTarget();
        switch (animationTarget.propertyTarget.propertyTargetType) {
            case AUTO_LAYOUT: {
                for (int i = 0; i < AnimatedProperties.AUTO_LAYOUT_PROPERTIES.length; ++i) {
                    AnimationBinding createdAnimation = this.maybeCreateAnimation(transition, transitionId, AnimatedProperties.AUTO_LAYOUT_PROPERTIES[i]);
                    if (createdAnimation == null) continue;
                    outList.add(createdAnimation);
                }
                break;
            }
            case SET: {
                AnimatedProperty[] properties = (AnimatedProperty[])animationTarget.propertyTarget.propertyTargetExtraData;
                for (int i = 0; i < properties.length; ++i) {
                    AnimationBinding createdAnimation = this.maybeCreateAnimation(transition, transitionId, properties[i]);
                    if (createdAnimation == null) continue;
                    outList.add(createdAnimation);
                }
                break;
            }
            case SINGLE: {
                AnimationBinding createdAnimation = this.maybeCreateAnimation(transition, transitionId, (AnimatedProperty)animationTarget.propertyTarget.propertyTargetExtraData);
                if (createdAnimation == null) break;
                outList.add(createdAnimation);
            }
        }
    }

    @Nullable
    private AnimationBinding maybeCreateAnimation(Transition.TransitionUnit transition, TransitionId transitionId, AnimatedProperty property) {
        AnimationState animationState = this.mAnimationStates.get(transitionId);
        if (this.mDebugTag != null) {
            Log.d((String)this.mDebugTag, (String)("Calculating transitions for " + transitionId + "#" + property.getName() + ":"));
        }
        if (animationState == null || animationState.currentLayoutOutputsGroup == null && animationState.nextLayoutOutputsGroup == null) {
            if (this.mDebugTag != null) {
                Log.d((String)this.mDebugTag, (String)" - this transitionId was not seen in the before/after layout state");
            }
            return null;
        }
        animationState.hasDisappearingAnimation = transition.hasDisappearAnimation() || animationState.hasDisappearingAnimation;
        int changeType = animationState.changeType;
        String changeTypeString = TransitionManager.changeTypeToString(animationState.changeType);
        if (changeType == 0 && !transition.hasAppearAnimation() || changeType == 2 && !transition.hasDisappearAnimation()) {
            animationState.shouldFinishUndeclaredAnimation = true;
            if (this.mDebugTag != null) {
                Log.d((String)this.mDebugTag, (String)(" - did not find matching transition for change type " + changeTypeString));
            }
            return null;
        }
        PropertyState existingState = animationState.propertyStates.get(property);
        PropertyHandle propertyHandle = new PropertyHandle(transitionId, property);
        float startValue = existingState != null ? existingState.animatedPropertyNode.getValue() : (animationState.changeType != 0 ? property.get(animationState.currentLayoutOutputsGroup.getMostSignificantUnit()) : transition.getAppearFrom().resolve(this.mResolver, propertyHandle));
        float endValue = animationState.changeType != 2 ? property.get(animationState.nextLayoutOutputsGroup.getMostSignificantUnit()) : transition.getDisappearTo().resolve(this.mResolver, propertyHandle);
        if (existingState != null && existingState.targetValue != null) {
            if (endValue == existingState.targetValue.floatValue()) {
                if (this.mDebugTag != null) {
                    Log.d((String)this.mDebugTag, (String)(" - property is already animating to this end value: " + endValue));
                }
                return null;
            }
        } else if (startValue == endValue) {
            if (this.mDebugTag != null) {
                Log.d((String)this.mDebugTag, (String)(" - the start and end values were the same: " + startValue + " = " + endValue));
            }
            return null;
        }
        if (this.mDebugTag != null) {
            Log.d((String)this.mDebugTag, (String)" - created animation");
        }
        AnimationBinding animation = transition.createAnimation(propertyHandle, endValue);
        animation.addListener(this.mAnimationBindingListener);
        animation.setTag(transition.getTransitionEndHandler());
        PropertyState propertyState = existingState;
        if (propertyState == null) {
            propertyState = new PropertyState();
            propertyState.animatedPropertyNode = new AnimatedPropertyNode(animationState.mountContentGroup, property);
            animationState.propertyStates.put(property, propertyState);
        }
        propertyState.animatedPropertyNode.setValue(startValue);
        ++propertyState.numPendingAnimations;
        ArrayList<PropertyHandle> animatedPropertyHandles = new ArrayList<PropertyHandle>();
        animatedPropertyHandles.add(propertyHandle);
        this.mAnimationsToPropertyHandles.put(animation, animatedPropertyHandles);
        this.mInitialStatesToRestore.put(propertyHandle, Float.valueOf(startValue));
        if (!TextUtils.isEmpty((CharSequence)transition.getTraceName())) {
            this.mTraceNames.put(animation.hashCode(), (Object)transition.getTraceName());
        }
        return animation;
    }

    private void restoreInitialStates() {
        for (PropertyHandle propertyHandle : this.mInitialStatesToRestore.keySet()) {
            float value = this.mInitialStatesToRestore.get(propertyHandle).floatValue();
            TransitionId transitionId = propertyHandle.getTransitionId();
            AnimationState animationState = this.mAnimationStates.get(transitionId);
            if (animationState.mountContentGroup == null) continue;
            TransitionManager.setPropertyValue(propertyHandle.getProperty(), value, animationState.mountContentGroup);
        }
        this.mInitialStatesToRestore.clear();
    }

    private void setMountContentInner(TransitionId transitionId, AnimationState animationState, @Nullable OutputUnitsAffinityGroup<Object> newMountContentGroup) {
        OutputUnitsAffinityGroup<Object> mountContentGroup = animationState.mountContentGroup;
        if (mountContentGroup == null && newMountContentGroup == null || mountContentGroup != null && mountContentGroup.equals(newMountContentGroup)) {
            return;
        }
        if (this.mDebugTag != null) {
            Log.d((String)this.mDebugTag, (String)("Setting mount content for " + transitionId + " to " + newMountContentGroup));
        }
        Map<AnimatedProperty, PropertyState> animatingProperties = animationState.propertyStates;
        if (animationState.mountContentGroup != null) {
            for (AnimatedProperty animatedProperty : animatingProperties.keySet()) {
                TransitionManager.resetProperty(animatedProperty, animationState.mountContentGroup);
            }
            this.recursivelySetChildClippingForGroup(animationState.mountContentGroup, true);
        }
        for (PropertyState propertyState : animatingProperties.values()) {
            propertyState.animatedPropertyNode.setMountContentGroup(newMountContentGroup);
        }
        if (newMountContentGroup != null) {
            this.recursivelySetChildClippingForGroup(newMountContentGroup, false);
        }
        animationState.mountContentGroup = newMountContentGroup;
    }

    private void recursivelySetChildClippingForGroup(OutputUnitsAffinityGroup<Object> mountContentGroup, boolean clipChildren) {
        this.recursivelySetChildClipping(mountContentGroup.get(3), clipChildren);
    }

    private void recursivelySetChildClipping(Object mountContent, boolean clipChildren) {
        if (!(mountContent instanceof View)) {
            return;
        }
        this.recursivelySetChildClippingForView((View)mountContent, clipChildren);
    }

    private void recursivelySetChildClippingForView(View view, boolean clipChildren) {
        ViewParent parent;
        if (view instanceof Host && !(view instanceof RootHost)) {
            if (clipChildren) {
                if (this.mOverriddenClipChildrenFlags.containsKey(view)) {
                    ((Host)view).setClipChildren(this.mOverriddenClipChildrenFlags.remove(view).booleanValue());
                }
            } else {
                this.mOverriddenClipChildrenFlags.put((Host)view, ((Host)view).getClipChildren());
                ((Host)view).setClipChildren(false);
            }
        }
        if ((parent = view.getParent()) instanceof Host && !(parent instanceof RootHost)) {
            this.recursivelySetChildClippingForView((View)parent, clipChildren);
        }
    }

    private void cleanupNonAnimatingAnimationStates() {
        HashSet<TransitionId> toRemove = new HashSet<TransitionId>();
        for (TransitionId transitionId : this.mAnimationStates.ids()) {
            AnimationState animationState = this.mAnimationStates.get(transitionId);
            if (!animationState.propertyStates.isEmpty()) continue;
            this.setMountContentInner(transitionId, animationState, null);
            TransitionManager.clearLayoutOutputs(animationState);
            toRemove.add(transitionId);
        }
        for (TransitionId transitionId : toRemove) {
            this.mAnimationStates.remove(transitionId);
        }
    }

    private void debugLogStartingAnimations() {
        if (this.mDebugTag == null) {
            throw new RuntimeException("Trying to debug log animations without debug flag set!");
        }
        Log.d((String)this.mDebugTag, (String)"Starting animations:");
    }

    private static String changeTypeToString(int changeType) {
        switch (changeType) {
            case 0: {
                return "APPEARED";
            }
            case 1: {
                return "CHANGED";
            }
            case 2: {
                return "DISAPPEARED";
            }
            case -1: {
                return "UNSET";
            }
        }
        throw new RuntimeException("Unknown changeType: " + changeType);
    }

    private static void clearLayoutOutputs(AnimationState animationState) {
        if (animationState.currentLayoutOutputsGroup != null) {
            animationState.currentLayoutOutputsGroup = null;
        }
        if (animationState.nextLayoutOutputsGroup != null) {
            animationState.nextLayoutOutputsGroup = null;
        }
    }

    private static float getPropertyValue(AnimatedProperty property, OutputUnitsAffinityGroup<AnimatableItem> mountContentGroup) {
        return property.get(mountContentGroup.getMostSignificantUnit());
    }

    private static void setPropertyValue(AnimatedProperty property, float value, OutputUnitsAffinityGroup<Object> mountContentGroup) {
        int size = mountContentGroup.size();
        for (int i = 0; i < size; ++i) {
            property.set(mountContentGroup.getAt(i), value);
        }
    }

    private static void resetProperty(AnimatedProperty property, OutputUnitsAffinityGroup<Object> mountContentGroup) {
        int size = mountContentGroup.size();
        for (int i = 0; i < size; ++i) {
            property.reset(mountContentGroup.getAt(i));
        }
    }

    private class RootAnimationListener
    implements AnimationBindingListener {
        private RootAnimationListener() {
        }

        @Override
        public void onScheduledToStartLater(AnimationBinding binding) {
        }

        @Override
        public void onWillStart(AnimationBinding binding) {
            TransitionManager.this.mRunningRootAnimations.add(binding);
        }

        @Override
        public void onFinish(AnimationBinding binding) {
            TransitionManager.this.mRunningRootAnimations.remove(binding);
        }

        @Override
        public void onCanceledBeforeStart(AnimationBinding binding) {
            TransitionManager.this.mRunningRootAnimations.remove(binding);
        }

        @Override
        public boolean shouldStart(AnimationBinding binding) {
            return true;
        }
    }

    private class TransitionsResolver
    implements Resolver {
        private TransitionsResolver() {
        }

        @Override
        public float getCurrentState(PropertyHandle propertyHandle) {
            OutputUnitsAffinityGroup<AnimatableItem> layoutOutputGroupToCheck;
            AnimatedProperty animatedProperty = propertyHandle.getProperty();
            TransitionId transitionId = propertyHandle.getTransitionId();
            AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get(transitionId);
            PropertyState propertyState = animationState.propertyStates.get(animatedProperty);
            if (propertyState != null) {
                return propertyState.animatedPropertyNode.getValue();
            }
            OutputUnitsAffinityGroup<AnimatableItem> outputUnitsAffinityGroup = layoutOutputGroupToCheck = animationState.changeType == 0 ? animationState.nextLayoutOutputsGroup : animationState.currentLayoutOutputsGroup;
            if (layoutOutputGroupToCheck == null) {
                throw new RuntimeException("Both LayoutOutputs were null!");
            }
            return animatedProperty.get(layoutOutputGroupToCheck.getMostSignificantUnit());
        }

        @Override
        public AnimatedPropertyNode getAnimatedPropertyNode(PropertyHandle propertyHandle) {
            TransitionId transitionId = propertyHandle.getTransitionId();
            AnimationState state = (AnimationState)TransitionManager.this.mAnimationStates.get(transitionId);
            PropertyState propertyState = state.propertyStates.get(propertyHandle.getProperty());
            return propertyState.animatedPropertyNode;
        }
    }

    private class TransitionsAnimationBindingListener
    implements AnimationBindingListener {
        private final ArrayList<PropertyAnimation> mTempPropertyAnimations = new ArrayList();

        private TransitionsAnimationBindingListener() {
        }

        @Override
        public void onScheduledToStartLater(AnimationBinding binding) {
            this.updateAnimationStates(binding);
        }

        @Override
        public void onWillStart(AnimationBinding binding) {
            this.updateAnimationStates(binding);
            String traceName = (String)TransitionManager.this.mTraceNames.get(binding.hashCode());
            if (!TextUtils.isEmpty((CharSequence)traceName)) {
                RenderCoreSystrace.beginAsyncSection((String)traceName, (int)binding.hashCode());
            }
        }

        @Override
        public void onFinish(AnimationBinding binding) {
            List keys = (List)TransitionManager.this.mAnimationsToPropertyHandles.get(binding);
            if (keys != null && TransitionManager.this.mOnAnimationCompleteListener != null) {
                for (PropertyHandle propertyHandle : keys) {
                    TransitionManager.this.mOnAnimationCompleteListener.onAnimationUnitComplete(propertyHandle, binding.getTag());
                }
            }
            this.finishAnimation(binding);
        }

        @Override
        public void onCanceledBeforeStart(AnimationBinding binding) {
            this.finishAnimation(binding);
        }

        @Override
        public boolean shouldStart(AnimationBinding binding) {
            binding.collectTransitioningProperties(this.mTempPropertyAnimations);
            boolean shouldStart = true;
            int size = this.mTempPropertyAnimations.size();
            for (int i = 0; i < size; ++i) {
                PropertyState propertyState;
                PropertyAnimation propertyAnimation = this.mTempPropertyAnimations.get(i);
                TransitionId transitionId = propertyAnimation.getTransitionId();
                AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get(transitionId);
                PropertyState propertyState2 = propertyState = animationState != null ? animationState.propertyStates.get(propertyAnimation.getProperty()) : null;
                if (TransitionManager.this.mDebugTag != null) {
                    Log.d((String)TransitionManager.this.mDebugTag, (String)("Trying to start animation on " + transitionId + "#" + propertyAnimation.getProperty().getName() + " to " + propertyAnimation.getTargetValue() + ":"));
                }
                if (propertyState == null) {
                    if (TransitionManager.this.mDebugTag != null) {
                        Log.d((String)TransitionManager.this.mDebugTag, (String)" - Canceling animation, transitionId not found in the AnimationState. It has been probably cancelled already.");
                    }
                    shouldStart = false;
                }
                if (!shouldStart || propertyState.lastMountedValue == null || propertyState.lastMountedValue.floatValue() == propertyAnimation.getTargetValue()) continue;
                if (TransitionManager.this.mDebugTag != null) {
                    Log.d((String)TransitionManager.this.mDebugTag, (String)(" - Canceling animation, last mounted value does not equal animation target: " + propertyState.lastMountedValue + " != " + propertyAnimation.getTargetValue()));
                }
                shouldStart = false;
            }
            this.mTempPropertyAnimations.clear();
            return shouldStart;
        }

        private void updateAnimationStates(AnimationBinding binding) {
            binding.collectTransitioningProperties(this.mTempPropertyAnimations);
            int size = this.mTempPropertyAnimations.size();
            for (int i = 0; i < size; ++i) {
                PropertyAnimation propertyAnimation = this.mTempPropertyAnimations.get(i);
                TransitionId transitionId = propertyAnimation.getTransitionId();
                AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get(transitionId);
                if (animationState == null) continue;
                PropertyState propertyState = animationState.propertyStates.get(propertyAnimation.getProperty());
                propertyState.targetValue = Float.valueOf(propertyAnimation.getTargetValue());
                propertyState.animation = binding;
            }
            this.mTempPropertyAnimations.clear();
        }

        private void finishAnimation(AnimationBinding binding) {
            List keys = (List)TransitionManager.this.mAnimationsToPropertyHandles.remove(binding);
            if (keys == null) {
                return;
            }
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                boolean didFinish;
                PropertyState propertyState;
                boolean isDisappearAnimation;
                PropertyHandle propertyHandle = (PropertyHandle)keys.get(i);
                TransitionId transitionId = propertyHandle.getTransitionId();
                AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get(transitionId);
                AnimatedProperty property = propertyHandle.getProperty();
                boolean bl = isDisappearAnimation = animationState.changeType == 2;
                if (isDisappearAnimation) {
                    propertyState = animationState.propertyStates.get(property);
                    if (propertyState == null) {
                        throw new RuntimeException("Some animation bookkeeping is wrong: tried to remove an animation from the list of active animations, but it wasn't there.");
                    }
                    --propertyState.numPendingAnimations;
                    didFinish = this.areAllDisappearingAnimationsFinished(animationState);
                    if (didFinish && animationState.mountContentGroup != null) {
                        for (AnimatedProperty animatedProperty : animationState.propertyStates.keySet()) {
                            TransitionManager.resetProperty(animatedProperty, animationState.mountContentGroup);
                        }
                    }
                } else {
                    propertyState = animationState.propertyStates.get(property);
                    if (propertyState == null) {
                        throw new RuntimeException("Some animation bookkeeping is wrong: tried to remove an animation from the list of active animations, but it wasn't there.");
                    }
                    --propertyState.numPendingAnimations;
                    if (propertyState.numPendingAnimations > 0) {
                        didFinish = false;
                    } else {
                        animationState.propertyStates.remove(property);
                        didFinish = animationState.propertyStates.isEmpty();
                        if (animationState.mountContentGroup != null) {
                            float value = TransitionManager.getPropertyValue(property, animationState.nextLayoutOutputsGroup);
                            TransitionManager.setPropertyValue(property, value, animationState.mountContentGroup);
                        }
                    }
                }
                if (!didFinish) continue;
                if (TransitionManager.this.mDebugTag != null) {
                    Log.d((String)TransitionManager.this.mDebugTag, (String)("Finished all animations for transition id " + transitionId));
                }
                if (animationState.mountContentGroup != null) {
                    TransitionManager.this.recursivelySetChildClippingForGroup(animationState.mountContentGroup, true);
                }
                if (TransitionManager.this.mOnAnimationCompleteListener != null) {
                    TransitionManager.this.mOnAnimationCompleteListener.onAnimationComplete(transitionId);
                }
                TransitionManager.this.mAnimationStates.remove(transitionId);
                TransitionManager.clearLayoutOutputs(animationState);
            }
            String traceName = (String)TransitionManager.this.mTraceNames.get(binding.hashCode());
            if (!TextUtils.isEmpty((CharSequence)traceName)) {
                RenderCoreSystrace.endAsyncSection((String)traceName, (int)binding.hashCode());
                TransitionManager.this.mTraceNames.delete(binding.hashCode());
            }
        }

        private boolean areAllDisappearingAnimationsFinished(AnimationState animationState) {
            if (animationState.changeType != 2) {
                throw new RuntimeException("This should only be checked for disappearing animations");
            }
            for (PropertyState propertyState : animationState.propertyStates.values()) {
                if (propertyState.numPendingAnimations <= 0) continue;
                return false;
            }
            return true;
        }
    }

    private static class AnimationState {
        public final Map<AnimatedProperty, PropertyState> propertyStates = new HashMap<AnimatedProperty, PropertyState>();
        @Nullable
        public OutputUnitsAffinityGroup<Object> mountContentGroup;
        public int changeType = -1;
        @Nullable
        public OutputUnitsAffinityGroup<AnimatableItem> currentLayoutOutputsGroup;
        @Nullable
        public OutputUnitsAffinityGroup<AnimatableItem> nextLayoutOutputsGroup;
        public boolean seenInLastTransition = false;
        public boolean shouldFinishUndeclaredAnimation;
        public boolean hasDisappearingAnimation;

        private AnimationState() {
        }
    }

    private static class PropertyState {
        public AnimatedPropertyNode animatedPropertyNode;
        public AnimationBinding animation;
        public Float targetValue;
        public Float lastMountedValue;
        public int numPendingAnimations;

        private PropertyState() {
        }
    }

    public static interface OnAnimationCompleteListener<T> {
        public void onAnimationComplete(TransitionId var1);

        public void onAnimationUnitComplete(PropertyHandle var1, T var2);
    }
}

