/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Transition;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.ParallelBinding;
import java.util.List;

public class ParallelTransitionSet
extends TransitionSet {
    private final int mStaggerMs;

    public <T extends Transition> ParallelTransitionSet(T ... children) {
        super(children);
        this.mStaggerMs = 0;
    }

    public <T extends Transition> ParallelTransitionSet(List<T> children) {
        super(children);
        this.mStaggerMs = 0;
    }

    public <T extends Transition> ParallelTransitionSet(int staggerMs, T ... children) {
        super(children);
        this.mStaggerMs = staggerMs;
    }

    public <T extends Transition> ParallelTransitionSet(int staggerMs, List<T> children) {
        super(children);
        this.mStaggerMs = staggerMs;
    }

    @Override
    AnimationBinding createAnimation(List<AnimationBinding> children) {
        return new ParallelBinding(this.mStaggerMs, children);
    }
}

